
delimiter $

DROP TRIGGER Trig_AI_Installer$
DROP TRIGGER Trig_AD_Installer$

DROP TRIGGER Trig_AD_Poste$
DROP TRIGGER Trig_AI_Poste$

DROP TRIGGER Trig_AU_Salle$

DROP TRIGGER Trig_BI_Installer$


--Reset des compteurs

UPDATE Segment seg SET seg.nbSalle =	(SELECT COUNT(*) FROM   Salle sal WHERE  seg.indIP = sal.indIP)$
UPDATE Segment seg  SET seg.nbPoste =(SELECT COUNT(*) FROM Poste pos WHERE  seg.indIP = pos.indIP)$
UPDATE Logiciel l SET l.nbInstall =(SELECT COUNT(*) FROM  Installer i WHERE  l.nLog = i.nLog)$
UPDATE Poste p SET p.nbLog = (SELECT COUNT(*) FROM Installer i WHERE  p.nPoste = i.nPoste)$



CREATE TRIGGER Trig_AD_Installer
 AFTER DELETE ON Installer
 FOR EACH ROW
BEGIN
  UPDATE Poste SET nbLog=nbLog - 1 WHERE nPoste = OLD.nPoste;
  UPDATE Logiciel SET nbInstall = nbInstall - 1 WHERE nLog = OLD.nLog;
END;
$


CREATE TRIGGER Trig_AI_Installer
 AFTER INSERT ON Installer
 FOR EACH ROW
BEGIN
 UPDATE Poste SET nbLog = nbLog + 1 WHERE nPoste = NEW.nPoste;
 UPDATE Logiciel SET nbInstall = nbInstall + 1 WHERE nLog = NEW.nLog;
END;
$

SELECT * FROM Poste$
SELECT * FROM Logiciel$
SELECT * FROM Installer$

INSERT INTO Installer (nPoste,nLog,dateIns,delai) VALUES ('p8','log7',SYSDATE(),NULL)$

SELECT * FROM Poste$
SELECT * FROM Logiciel$
SELECT * FROM Installer$

DELETE FROM Installer WHERE nPoste='p8' AND nLog='log7'$

SELECT * FROM Poste$
SELECT * FROM Logiciel$
SELECT * FROM Installer$

--


CREATE TRIGGER Trig_AI_Poste
 AFTER INSERT ON Poste FOR EACH ROW
BEGIN
 UPDATE Salle SET nbPoste=nbPoste+1 WHERE nSalle = NEW.nSalle;
END;
$

CREATE TRIGGER Trig_AD_Poste
 AFTER DELETE ON Poste FOR EACH ROW
BEGIN
  UPDATE Salle SET nbPoste = nbPoste - 1 WHERE nSalle = OLD.nSalle;
END;
$

CREATE TRIGGER Trig_AU_Salle
 AFTER UPDATE ON Salle FOR EACH ROW
BEGIN
 DECLARE differ TINYINT(2);
 SET differ := NEW.nbPoste - OLD.nbPoste;
 UPDATE Segment SET nbPoste = nbPoste + differ WHERE indIP = NEW.indIP;
END;
$

--tests

SELECT * FROM Poste$
SELECT * FROM Salle$
SELECT * FROM Segment$

INSERT INTO poste VALUES ('p99','Poste 99','130.120.82','093','PCWS','s21',0)$

SELECT * FROM Poste$
SELECT * FROM Salle$
SELECT * FROM Segment$

DELETE FROM Poste WHERE nPoste='p99'$

SELECT * FROM Poste$
SELECT * FROM Salle$
SELECT * FROM Segment$


-- Contraintes complexes 

delimiter $
DROP TABLE IF EXISTS test.Trace$
CREATE TABLE test.Trace(col VARCHAR(80) PRIMARY KEY)$

CREATE TRIGGER Trig_BI_Installer
 BEFORE INSERT ON Installer FOR EACH ROW
BEGIN
DECLARE v_type_log   VARCHAR(9);
DECLARE v_type_pos   VARCHAR(9);
DECLARE v_date_achat DATETIME;
 SELECT typeLog, dateAch INTO v_type_log,v_date_achat
        FROM Logiciel WHERE NEW.nLog = nLog;

 SELECT typePoste INTO v_type_pos
        FROM Poste WHERE NEW.nPoste = nPoste;

 IF NOT (v_type_log = v_type_pos) THEN
 -- Les types ne correspondent pas : on fait planter...
    INSERT INTO test.Trace VALUES (NULL);
 END IF;
 IF NEW.dateIns IS NOT NULL THEN
     IF DATEDIFF(NEW.dateIns,v_date_achat) < 0 THEN
    -- Installation antrieure a la date achat
       INSERT INTO test.Trace VALUES (NULL);
     END IF;
 END IF;
END;
$

SELECT nPoste, typePoste  FROM Poste$
SELECT nLog, typeLog FROM Logiciel$
SELECT nPoste, nLog  FROM Installer$

--bug types

INSERT INTO Installer (nPoste,nLog,dateIns,delai) VALUES ('p8','log7',SYSDATE(),NULL)$

--bug dates

INSERT INTO Installer (nPoste,nLog,dateIns,delai) VALUES ('p10','log2','1997-06-02',NULL)$

--ok

INSERT INTO Installer (nPoste,nLog,dateIns,delai) VALUES ('p10','log2','2005-06-02',NULL)$

DROP TABLE test.Trace$

DELETE FROM Installer WHERE nPoste='p10' aND nLog='log2'$