/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.jip;

import org.objectweb.asm.jip.ByteVector;
import org.objectweb.asm.jip.Edge;
import org.objectweb.asm.jip.MethodWriter;

public class Label {
    int line;
    boolean resolved;
    int position;
    boolean resized;
    private int referenceCount;
    private int[] srcAndRefPositions;
    int beginStackSize;
    int maxStackSize;
    Edge successors;
    Label next;
    boolean pushed;

    public int getOffset() {
        if (!this.resolved) {
            throw new IllegalStateException("Label offset position has not been resolved yet");
        }
        return this.position;
    }

    void put(MethodWriter methodWriter, ByteVector byteVector, int n, boolean bl) {
        if (this.resolved) {
            if (bl) {
                byteVector.putInt(this.position - n);
            } else {
                byteVector.putShort(this.position - n);
            }
        } else if (bl) {
            this.addReference(-1 - n, byteVector.length);
            byteVector.putInt(-1);
        } else {
            this.addReference(n, byteVector.length);
            byteVector.putShort(-1);
        }
    }

    private void addReference(int n, int n2) {
        if (this.srcAndRefPositions == null) {
            this.srcAndRefPositions = new int[6];
        }
        if (this.referenceCount >= this.srcAndRefPositions.length) {
            int[] nArray = new int[this.srcAndRefPositions.length + 6];
            System.arraycopy(this.srcAndRefPositions, 0, nArray, 0, this.srcAndRefPositions.length);
            this.srcAndRefPositions = nArray;
        }
        this.srcAndRefPositions[this.referenceCount++] = n;
        this.srcAndRefPositions[this.referenceCount++] = n2;
    }

    boolean resolve(MethodWriter methodWriter, int n, byte[] byArray) {
        boolean bl = false;
        this.resolved = true;
        this.position = n;
        int n2 = 0;
        while (n2 < this.referenceCount) {
            int n3;
            int n4 = this.srcAndRefPositions[n2++];
            int n5 = this.srcAndRefPositions[n2++];
            if (n4 >= 0) {
                n3 = n - n4;
                if (n3 < Short.MIN_VALUE || n3 > Short.MAX_VALUE) {
                    int n6 = byArray[n5 - 1] & 0xFF;
                    byArray[n5 - 1] = n6 <= 168 ? (byte)(n6 + 49) : (byte)(n6 + 20);
                    bl = true;
                }
                byArray[n5++] = (byte)(n3 >>> 8);
                byArray[n5] = (byte)n3;
                continue;
            }
            n3 = n + n4 + 1;
            byArray[n5++] = (byte)(n3 >>> 24);
            byArray[n5++] = (byte)(n3 >>> 16);
            byArray[n5++] = (byte)(n3 >>> 8);
            byArray[n5] = (byte)n3;
        }
        return bl;
    }

    public String toString() {
        return "L" + System.identityHashCode(this);
    }
}

