/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor;

import abbot.Log;
import abbot.editor.ActionMapModel;
import abbot.editor.CompactHierarchy;
import abbot.editor.ComponentBrowserListener;
import abbot.editor.ComponentNode;
import abbot.editor.ComponentPropertyModel;
import abbot.editor.ComponentTree;
import abbot.editor.InputMapModel;
import abbot.editor.ReferenceAttributeModel;
import abbot.editor.ReferencesModel;
import abbot.editor.ScriptEditor;
import abbot.editor.editors.XMLEditor;
import abbot.editor.widgets.TextFormat;
import abbot.finder.AWTHierarchy;
import abbot.finder.ComponentSearchException;
import abbot.finder.Hierarchy;
import abbot.finder.MultipleComponentsFoundException;
import abbot.i18n.Strings;
import abbot.script.ArgumentParser;
import abbot.script.ComponentReference;
import abbot.script.Resolver;
import abbot.tester.Robot;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.TreePath;

public class ComponentBrowser
extends JPanel
implements ActionListener {
    private int TAB_HIERARCHY = 0;
    private JButton refreshButton;
    private JCheckBox filterButton;
    private JButton addAssertButton;
    private JButton addSampleButton;
    private JCheckBox filterPropertiesCheckBox;
    private Resolver resolver;
    private ComponentTree componentTree;
    private JTable propTable;
    private ReferencesModel refModel;
    private JTable refTable;
    private ComponentPropertyModel propertyModel;
    private JTable attributeTable;
    private ReferenceAttributeModel attributeModel;
    private JTable inputMapTable;
    private JTable actionMapTable;
    private boolean filter = true;
    private JTabbedPane tabs;
    private JTabbedPane tabs2;
    private Component selectedComponent = null;
    private boolean fakeComponent = false;
    private ComponentReference selectedReference = null;
    private LocalHierarchy hierarchy;
    private boolean ignoreHierarchyChange = false;
    private boolean ignoreReferenceChange = false;
    private ArrayList listeners = new ArrayList();

    public ComponentBrowser(Resolver r, Hierarchy h) {
        this.resolver = r;
        this.hierarchy = new LocalHierarchy(h);
        this.setName("browser");
        this.equip(this);
        this.setSelectedComponent(null);
        this.setSelectedReference(null);
    }

    private void equip(Container pane) {
        this.setLayout(new BorderLayout());
        JSplitPane split = new JSplitPane(1, this.createLeftPanel(), this.createRightPanel());
        split.setResizeWeight(1.0);
        split.setDividerSize(4);
        split.setBorder(null);
        pane.add((Component)split, "Center");
    }

    private JPanel createHierarchyView() {
        JPanel pane = new JPanel(new BorderLayout());
        this.componentTree = new ComponentTree(this.hierarchy);
        this.componentTree.setName("browser.hierarchy");
        this.componentTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                if (!ComponentBrowser.this.ignoreHierarchyChange) {
                    ComponentBrowser.this.setSelectedComponent(ComponentBrowser.this.getSelectedComponentFromTree());
                }
            }
        });
        JScrollPane scroll = new JScrollPane(this.componentTree);
        scroll.getViewport().setBackground(this.componentTree.getBackground());
        pane.add((Component)scroll, "Center");
        this.refreshButton = new JButton(Strings.get("browser.hierarchy.reload"));
        this.refreshButton.addActionListener(this);
        this.filterButton = new JCheckBox(Strings.get("browser.hierarchy.concise"));
        this.filterButton.addActionListener(this);
        this.filterButton.setSelected(this.filter);
        this.filterButton.setToolTipText(Strings.get("browser.hierarchy.filter.tip"));
        JPanel buttons = new JPanel();
        buttons.setBorder(new EmptyBorder(0, 0, 0, 0));
        buttons.add(this.refreshButton);
        buttons.add(this.filterButton);
        JPanel leftJustify = new JPanel(new BorderLayout());
        leftJustify.setBorder(new EmptyBorder(0, 0, 0, 0));
        leftJustify.add((Component)buttons, "West");
        pane.add((Component)leftJustify, "South");
        return pane;
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
        this.refModel = new ReferencesModel(resolver);
        this.refTable.setModel(this.refModel);
    }

    private Component createReferenceView() {
        this.refModel = new ReferencesModel(this.resolver);
        this.refTable = new JTable(this.refModel){

            public void setRowSelectionInterval(int start, int end) {
                super.setRowSelectionInterval(start, end);
                Rectangle cellRect = this.getCellRect(start, 0, true);
                if (cellRect != null) {
                    super.scrollRectToVisible(cellRect);
                }
            }
        };
        this.refTable.setName("browser.references");
        this.refTable.setSelectionMode(0);
        this.refTable.setDefaultEditor(ComponentReference.class, new XMLEditor());
        this.refTable.clearSelection();
        ListSelectionListener lsl = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent lse) {
                if (!lse.getValueIsAdjusting()) {
                    ComponentBrowser.this.referenceListSelectionChanged(lse);
                }
            }
        };
        this.refTable.getSelectionModel().addListSelectionListener(lsl);
        JScrollPane scroll = new JScrollPane(this.refTable);
        scroll.getViewport().setBackground(this.refTable.getBackground());
        return scroll;
    }

    private Component createLeftPanel() {
        this.tabs = new JTabbedPane(){

            public Dimension getPreferredSize() {
                return new Dimension(250, 200);
            }
        };
        this.tabs.add(Strings.get("Hierarchy"), this.createHierarchyView());
        this.tabs.setToolTipTextAt(0, Strings.get("browser.hierarchy.tip"));
        this.tabs.add(Strings.get("References"), this.createReferenceView());
        this.tabs.setToolTipTextAt(1, Strings.get("browser.references.tip"));
        this.tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ComponentBrowser.this.tabChanged(e);
            }
        });
        return this.tabs;
    }

    private Component createRightPanel() {
        JPanel pane = new JPanel(new BorderLayout());
        this.propertyModel = new ComponentPropertyModel();
        this.propTable = new JTable(this.propertyModel);
        this.propTable.setName("browser.properties");
        this.propTable.setAutoResizeMode(4);
        this.propTable.setSelectionMode(0);
        this.propTable.setDefaultRenderer(Object.class, new PropertyRenderer());
        ListSelectionListener lsl = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent lse) {
                if (!lse.getValueIsAdjusting()) {
                    ComponentBrowser.this.enableAssertSampleButtons();
                }
            }
        };
        this.propTable.getSelectionModel().addListSelectionListener(lsl);
        this.addAssertButton = new JButton("");
        this.addAssertButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ComponentBrowser.this.firePropertyCheck(false);
            }
        });
        this.addAssertButton.setEnabled(false);
        this.updateAssertText(false, false);
        this.addSampleButton = new JButton(Strings.get("SampleProperty"));
        this.addSampleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ComponentBrowser.this.firePropertyCheck(true);
            }
        });
        this.addSampleButton.setEnabled(false);
        String waitKeyName = KeyEvent.getKeyText(ScriptEditor.KC_WAIT);
        String invertKeyName = KeyEvent.getKeyText(16);
        String tip = Strings.get("AssertPropertyTip", new Object[]{invertKeyName, waitKeyName});
        this.addAssertButton.setToolTipText(TextFormat.tooltip(tip));
        tip = Strings.get("SamplePropertyTip");
        this.addSampleButton.setToolTipText(TextFormat.tooltip(tip));
        this.filterPropertiesCheckBox = new JCheckBox(Strings.get("Filter"));
        this.filterPropertiesCheckBox.addActionListener(this);
        this.filterPropertiesCheckBox.setEnabled(true);
        this.filterPropertiesCheckBox.setSelected(true);
        this.filterPropertiesCheckBox.setToolTipText(Strings.get("browser.properties.filter.tip"));
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.addAssertButton);
        buttonsPanel.add(this.addSampleButton);
        buttonsPanel.add(this.filterPropertiesCheckBox);
        JPanel leftJustify = new JPanel(new BorderLayout());
        leftJustify.setBorder(new EmptyBorder(0, 0, 0, 0));
        leftJustify.add((Component)buttonsPanel, "West");
        JScrollPane scroll = new JScrollPane(this.propTable);
        scroll.getViewport().setBackground(this.propTable.getBackground());
        scroll.setColumnHeaderView(this.propTable.getTableHeader());
        pane.add((Component)scroll, "Center");
        pane.add((Component)leftJustify, "South");
        this.attributeModel = new ReferenceAttributeModel();
        this.attributeModel.addTableModelListener(new AttributeListener());
        this.attributeTable = new JTable(this.attributeModel);
        JScrollPane scroll1 = new JScrollPane(this.attributeTable);
        scroll1.getViewport().setBackground(this.attributeTable.getBackground());
        this.inputMapTable = new JTable(InputMapModel.EMPTY);
        JScrollPane scroll2 = new JScrollPane(this.inputMapTable);
        scroll2.getViewport().setBackground(this.inputMapTable.getBackground());
        this.actionMapTable = new JTable(ActionMapModel.EMPTY);
        JScrollPane scroll3 = new JScrollPane(this.actionMapTable);
        scroll3.getViewport().setBackground(this.actionMapTable.getBackground());
        this.tabs2 = new JTabbedPane(){

            public Dimension getPreferredSize() {
                return new Dimension(300, 150);
            }
        };
        this.tabs2.add(Strings.get("browser.properties"), pane);
        this.tabs2.setToolTipTextAt(0, Strings.get("browser.properties.tip"));
        this.tabs2.add(Strings.get("browser.attributes"), scroll1);
        this.tabs2.setToolTipTextAt(1, Strings.get("browser.attributes.tip"));
        this.tabs2.add(Strings.get("browser.inputmap"), scroll2);
        this.tabs2.setToolTipTextAt(2, Strings.get("browser.inputmap.tip"));
        this.tabs2.add(Strings.get("browser.actionmap"), scroll3);
        this.tabs2.setToolTipTextAt(3, Strings.get("browser.actionmap.tip"));
        return this.tabs2;
    }

    public void updateAssertText(boolean isWait, boolean invert) {
        this.addAssertButton.setText(Strings.get(isWait ? "WaitProperty" : "AssertProperty", new Object[]{invert ? Strings.get("assert.not_equals") : Strings.get("assert.equals")}));
    }

    public void setSelectedReference(ComponentReference ref) {
        if (ref != this.selectedReference) {
            Component c;
            this.selectedReference = ref;
            this.updateReferenceSelection(ref);
            Component component = c = ref != null ? this.getComponentForReference(ref) : null;
            if (c != this.selectedComponent) {
                this.selectedComponent = c;
                this.updateComponentSelection(c);
            }
            this.fireSelectionChanged();
        }
    }

    public void setSelectedComponent(Component comp) {
        this.selectedComponent = comp;
        ComponentReference ref = null;
        if (comp != null && this.resolver.getHierarchy().contains(comp)) {
            ref = this.resolver.getComponentReference(comp);
        }
        if (ref != this.selectedReference) {
            this.selectedReference = ref;
            this.updateReferenceSelection(ref);
        }
        if (ref == null && !this.showingHierarchy()) {
            this.tabs.setSelectedIndex(this.TAB_HIERARCHY);
        }
        this.updateComponentSelection(comp);
        this.fireSelectionChanged();
    }

    private int getRow(ComponentReference ref) {
        if (ref != null) {
            for (int i = 0; i < this.refTable.getRowCount(); ++i) {
                ComponentReference value = (ComponentReference)this.refTable.getValueAt(i, 0);
                if (ref != value) continue;
                return i;
            }
        }
        return -1;
    }

    private void updateReferenceSelection(ComponentReference ref) {
        if (!this.showingHierarchy()) {
            int row = this.getRow(ref);
            this.ignoreReferenceChange = true;
            if (row == -1) {
                this.refTable.clearSelection();
            } else {
                this.refTable.setRowSelectionInterval(row, row);
            }
            this.ignoreReferenceChange = false;
        }
        this.updateAttributesList();
        this.updatePropertyList();
    }

    private void updateComponentSelection(Component comp) {
        if (this.showingHierarchy()) {
            this.ignoreHierarchyChange = true;
            if (comp == null) {
                this.componentTree.clearSelection();
            } else {
                TreePath path = this.componentTree.getPath(comp);
                ComponentNode node = (ComponentNode)path.getLastPathComponent();
                if (node.getUserObject() != comp) {
                    this.setCompactDisplay(false);
                    path = this.componentTree.getPath(comp);
                }
                this.componentTree.setSelectionPath(path);
            }
            this.ignoreHierarchyChange = false;
        }
        this.updateAttributesList();
        this.updatePropertyList();
    }

    public boolean isComponentSelected() {
        if (this.showingHierarchy()) {
            return (ComponentNode)this.componentTree.getLastSelectedPathComponent() != null;
        }
        return this.refTable.getSelectedRow() != -1;
    }

    public void setEnabled(boolean state) {
        super.setEnabled(state);
        if (state) {
            this.refresh();
        }
    }

    public void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ComponentBrowser.this.componentTree.reload(null);
            }
        });
    }

    private Component getComponentForReference(ComponentReference ref) {
        Component comp = null;
        this.fakeComponent = false;
        try {
            comp = ref.getComponent();
        }
        catch (ComponentSearchException e) {
            if (e instanceof MultipleComponentsFoundException) {
                MultipleComponentsFoundException mc = (MultipleComponentsFoundException)e;
                Component[] list = mc.getComponents();
                String warning = "Multiple components found for " + ref.toXMLString() + ": ";
                for (int i = 0; i < list.length; ++i) {
                    warning = warning + "\n" + Robot.toHierarchyPath(mc.getComponents()[i]);
                }
                Log.warn(warning);
            }
            try {
                this.fakeComponent = true;
                comp = (Component)Class.forName(ref.getRefClassName()).newInstance();
                comp.setName(Strings.get("browser.hierarchy.proxy", new Object[]{ref.getID()}));
                if (comp instanceof Window) {
                    this.hierarchy.filter(comp);
                    this.componentTree.reload();
                }
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
        return comp;
    }

    public boolean showingHierarchy() {
        return this.tabs.getSelectedIndex() == this.TAB_HIERARCHY;
    }

    public ComponentReference getSelectedReference() {
        return this.selectedReference;
    }

    public Component getSelectedComponent() {
        return this.selectedComponent;
    }

    public void setCompactDisplay(boolean compact) {
        this.filter = compact;
        this.filterButton.setSelected(this.filter);
        this.hierarchy.setCompact(this.filter);
        this.componentTree.setHierarchy(this.hierarchy);
    }

    public boolean isCompactDisplay() {
        return this.filter;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.refreshButton) {
            this.refresh();
        } else if (e.getSource() == this.filterButton) {
            this.setCompactDisplay(!this.filter);
        } else if (e.getSource() == this.filterPropertiesCheckBox) {
            this.updatePropertyList();
        }
    }

    private void updateAttributesList() {
        this.attributeModel.setReference(this.selectedReference);
    }

    private void updatePropertyList() {
        int row = this.propTable.getSelectedRow();
        String savedProperty = row == -1 ? "" : (String)this.propTable.getValueAt(row, 0);
        this.addAssertButton.setEnabled(false);
        this.addSampleButton.setEnabled(false);
        Component comp = this.showingHierarchy() || this.selectedReference != null ? this.selectedComponent : null;
        this.propertyModel.setComponent(comp, this.filterPropertiesCheckBox.isSelected());
        for (row = 0; row < this.propTable.getRowCount(); ++row) {
            String prop = (String)this.propTable.getValueAt(row, 0);
            if (!prop.equals(savedProperty)) continue;
            this.propTable.setRowSelectionInterval(row, row);
            Rectangle rect = this.propTable.getCellRect(row, 0, true);
            this.propTable.scrollRectToVisible(rect);
            this.enableAssertSampleButtons();
            break;
        }
        if (comp instanceof JComponent) {
            InputMap im = ((JComponent)comp).getInputMap();
            ActionMap am = ((JComponent)comp).getActionMap();
            this.inputMapTable.setModel(new InputMapModel(im));
            this.actionMapTable.setModel(new ActionMapModel(am));
        } else {
            this.inputMapTable.setModel(InputMapModel.EMPTY);
            this.actionMapTable.setModel(ActionMapModel.EMPTY);
        }
        this.inputMapTable.repaint();
        this.actionMapTable.repaint();
    }

    private Component getSelectedComponentFromTree() {
        ComponentNode node = (ComponentNode)this.componentTree.getLastSelectedPathComponent();
        Component comp = node != null ? node.getComponent() : null;
        return comp;
    }

    private ComponentReference getReferenceAt(int row) {
        return (ComponentReference)this.refTable.getValueAt(row, 0);
    }

    private ComponentReference getSelectedReferenceFromList() {
        int refrow = this.refTable.getSelectedRow();
        return refrow == -1 ? null : this.getReferenceAt(refrow);
    }

    public void enableAssertSampleButtons() {
        int row = this.propTable.getSelectedRow();
        this.addAssertButton.setEnabled(row != -1 && this.isComponentSelected());
        this.addSampleButton.setEnabled(row != -1 && this.isComponentSelected());
    }

    public void referenceListSelectionChanged(ListSelectionEvent e) {
        if (!this.ignoreReferenceChange) {
            this.setSelectedReference(this.getSelectedReferenceFromList());
        }
    }

    public void tabChanged(ChangeEvent e) {
        if (this.showingHierarchy()) {
            if (this.fakeComponent) {
                this.fakeComponent = false;
                this.setSelectedComponent(null);
            } else {
                this.updateComponentSelection(this.selectedComponent);
            }
        } else if (this.selectedReference == null && this.refTable.getRowCount() > 0) {
            this.setSelectedReference(this.getReferenceAt(0));
        } else {
            this.updateReferenceSelection(this.selectedReference);
        }
    }

    public void addSelectionListener(ComponentBrowserListener cbl) {
        ArrayList<ComponentBrowserListener> list = new ArrayList<ComponentBrowserListener>(this.listeners);
        list.add(cbl);
        this.listeners = list;
    }

    public void removeSelectionListener(ComponentBrowserListener cbl) {
        ArrayList list = new ArrayList(this.listeners);
        list.remove(cbl);
        this.listeners = list;
    }

    protected void fireSelectionChanged() {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ComponentBrowserListener)iter.next()).selectionChanged(this, this.selectedComponent, this.selectedReference);
        }
    }

    protected void firePropertyCheck(boolean sample) {
        int row = this.propTable.getSelectedRow();
        if (row == -1 || this.selectedComponent == null) {
            return;
        }
        Method m = (Method)this.propertyModel.getValueAt(row, 3);
        Object value = this.propertyModel.getValueAt(row, 1);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ComponentBrowserListener)iter.next()).propertyAction(this, m, value, sample);
        }
    }

    public void referencesChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.refModel.fireTableDataChanged();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ComponentBrowser.this.referencesChanged();
                }
            });
        }
    }

    private class PropertyRenderer
    extends DefaultTableCellRenderer {
        private PropertyRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent c = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            value = ComponentBrowser.this.propertyModel.getValueAt(row, 2);
            if (isSelected) {
                c.setBackground(table.getSelectionBackground());
                c.setForeground(table.getSelectionForeground());
            } else {
                c.setBackground(table.getBackground());
                c.setForeground(table.getForeground());
            }
            if (column == 1 && Boolean.TRUE.equals(value)) {
                this.setToolTipText(Strings.get("Inaccessible"));
                c.setBackground(Color.gray);
            }
            return c;
        }

        protected void setValue(Object value) {
            String str = ArgumentParser.toString(value);
            this.setToolTipText(str);
            super.setValue(str == "<default-tostring>" ? value.toString() : str);
        }
    }

    private class AttributeListener
    implements TableModelListener {
        private boolean messaging = false;

        private AttributeListener() {
        }

        public void tableChanged(TableModelEvent e) {
            if (!this.messaging) {
                this.messaging = true;
                ComponentReference ref = ComponentBrowser.this.selectedReference;
                ComponentBrowser.this.refModel.fireTableDataChanged();
                ComponentBrowser.this.setSelectedReference(ref);
                this.messaging = false;
            }
        }
    }

    private class LocalHierarchy
    extends CompactHierarchy {
        private Map filtered;
        private Hierarchy raw;

        public LocalHierarchy(Hierarchy h) {
            super(h);
            this.filtered = new WeakHashMap();
            this.raw = new AWTHierarchy();
        }

        public Collection getRoots() {
            Collection roots = this.isCompact() ? super.getRoots() : this.raw.getRoots();
            roots.removeAll(this.filtered.keySet());
            return roots;
        }

        public Collection getComponents(Component c) {
            Collection kids = this.isCompact() ? super.getComponents(c) : this.raw.getComponents(c);
            kids.removeAll(this.filtered.keySet());
            return kids;
        }

        public boolean contains(Component c) {
            return (this.isCompact() ? super.contains(c) : this.raw.contains(c)) && !this.filtered.containsKey(c);
        }

        public void filter(Component c) {
            this.filtered.put(c, Boolean.TRUE);
        }
    }
}

