/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor;

import abbot.Platform;
import abbot.editor.LogoLabel;
import abbot.editor.ScriptEditor;
import abbot.i18n.Strings;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JWindow;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.SoftBevelBorder;

public class Costello {
    private static final String BUNDLE = "abbot.editor.i18n.StringsBundle";
    private static SplashScreen splash;

    public static Window getSplashScreen() {
        return splash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            String lafClass = System.getProperty("abbot.editor.look_and_feel", "system");
            if ("system".equals(lafClass)) {
                lafClass = UIManager.getSystemLookAndFeelClassName();
            }
            if (lafClass != null && !"".equals(lafClass) && !"default".equals(lafClass)) {
                UIManager.setLookAndFeel(lafClass);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        splash = new SplashScreen();
        LogoLabel label = new LogoLabel();
        if (!Platform.isOSX()) {
            CompoundBorder b = new CompoundBorder(new SoftBevelBorder(0), label.getBorder());
            label.setBorder(b);
        }
        splash.getContentPane().add(label);
        splash.pack();
        Rectangle screen = splash.getGraphicsConfiguration().getBounds();
        Dimension size = splash.getSize();
        Point loc = new Point(screen.x + (screen.width - size.width) / 2, screen.y + (screen.height - size.height) / 2);
        splash.setLocation(loc);
        splash.setVisible(true);
        try {
            ScriptEditor.main(args);
            Costello.splash.disposeOK = true;
        }
        catch (Throwable throwable) {
            Costello.splash.disposeOK = true;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    splash.dispose();
                    splash = null;
                }
            });
            throw throwable;
        }
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    static {
        System.setProperty("abbot.robot.verify", "false");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Costello");
        if (Platform.JAVA_VERSION < 5120) {
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "true");
            System.setProperty("com.apple.macos.use-file-dialog-packages", "true");
            System.setProperty("com.apple.macos.useScreenMenuBar", "true");
        } else {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.showGrowBox", "true");
        }
        Strings.addBundle(BUNDLE);
        splash = null;
    }

    private static class SplashScreen
    extends JWindow {
        boolean disposeOK = false;

        private SplashScreen() {
        }

        public void hide() {
            if (this.disposeOK) {
                super.hide();
            }
        }

        public void dispose() {
            if (this.disposeOK) {
                super.dispose();
            }
        }
    }
}

