/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.editors;

import abbot.editor.editors.PropertyCallEditor;
import abbot.i18n.Strings;
import abbot.script.Assert;
import abbot.tester.ComponentTester;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AssertEditor
extends PropertyCallEditor {
    private Assert step;
    private JTextField value;
    private JCheckBox invert;
    private JCheckBox wait;
    private JTextField timeout = null;
    private JTextField interval = null;
    private int optionsIndex;

    public AssertEditor(Assert step) {
        super(step);
        Component c;
        this.step = step;
        this.value = this.addTextField(Strings.get("ExpectedResult"), step.getExpectedResult());
        this.value.setName("value");
        this.invert = this.addCheckBox(Strings.get("Invert"), step.isInverted());
        this.invert.setName("invert");
        this.wait = this.addCheckBox(Strings.get("WaitToggle"), step.isWait());
        this.wait.setName("wait");
        while ((c = this.getComponent(this.getComponentCount() - 1)) != this.value) {
            this.remove(c);
        }
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(0, 2));
        p.add(this.invert);
        p.add(this.wait);
        this.add(p);
        this.optionsIndex = this.getComponentCount();
        this.configureWaitOptionFields();
    }

    protected Collection getComponentTesterMethods(ComponentTester tester) {
        ArrayList<Method> list = new ArrayList<Method>(Arrays.asList(tester.getPropertyMethods()));
        list.addAll(Arrays.asList(tester.getAssertMethods()));
        list.addAll(Arrays.asList(tester.getComponentAssertMethods()));
        return list;
    }

    private void configureWaitOptionFields() {
        if (this.step.isWait()) {
            if (this.timeout == null) {
                this.timeout = this.addTextField(Strings.get("Timeout"), String.valueOf(this.step.getTimeout()), String.valueOf(10000));
                this.timeout.setName("timeout");
                this.interval = this.addTextField(Strings.get("PollInterval"), String.valueOf(this.step.getPollInterval()), String.valueOf(100));
                this.interval.setName("pollInterval");
            }
        } else if (this.timeout != null) {
            while (this.getComponentCount() > this.optionsIndex) {
                this.remove(this.getComponentCount() - 1);
            }
            this.interval = null;
            this.timeout = null;
        }
        this.revalidate();
        this.repaint();
    }

    protected boolean validateTimeout(String value) {
        try {
            this.step.setTimeout(Long.parseLong(value));
            this.timeout.setForeground(DEFAULT_FOREGROUND);
            return true;
        }
        catch (NumberFormatException nfe) {
            this.timeout.setForeground(ERROR_FOREGROUND);
            return false;
        }
    }

    protected boolean validateInterval(String value) {
        try {
            this.step.setPollInterval(Long.parseLong(value));
            this.interval.setForeground(DEFAULT_FOREGROUND);
            return true;
        }
        catch (NumberFormatException nfe) {
            this.interval.setForeground(ERROR_FOREGROUND);
            return false;
        }
    }

    public void actionPerformed(ActionEvent ev) {
        Object src = ev.getSource();
        if (src == this.value) {
            this.step.setExpectedResult(this.value.getText());
            this.fireStepChanged();
        } else if (src == this.invert) {
            this.step.setInverted(!this.step.isInverted());
            this.fireStepChanged();
        } else if (src == this.wait) {
            this.step.setWait(!this.step.isWait());
            this.configureWaitOptionFields();
            this.fireStepChanged();
        } else if (src == this.timeout) {
            String value = this.timeout.getText();
            if (this.validateTimeout(value)) {
                this.fireStepChanged();
            }
        } else if (src == this.interval) {
            String value = this.interval.getText();
            if (this.validateInterval(value)) {
                this.fireStepChanged();
            }
        } else {
            super.actionPerformed(ev);
        }
    }
}

