/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.editors;

import abbot.editor.editors.StepEditor;
import abbot.i18n.Strings;
import abbot.script.Expression;
import bsh.EvalError;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JTextArea;

public class ExpressionEditor
extends StepEditor {
    private Expression step;
    private JTextArea expr;
    private JButton run;
    private Color DEFAULT_FG;
    private JTextArea status;

    public ExpressionEditor(Expression step) {
        super(step);
        this.step = step;
        this.remove(this.getComponentCount() - 1);
        this.expr = this.addTextArea(null, step.getExpression());
        this.expr.setName("expression.text");
        this.expr.setColumns(80);
        this.expr.setToolTipText(Strings.get("expression.text.tip"));
        this.expr.setLineWrap(false);
        this.run = this.addButton(Strings.get("expression.eval"));
        this.run.setToolTipText(Strings.get("expression.eval.tip"));
        this.DEFAULT_FG = this.expr.getForeground();
        this.expr.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10 && (e.getModifiers() & 1) != 0) {
                    ExpressionEditor.this.run.doClick();
                }
            }
        });
        this.status = new JTextArea();
        this.status.setBorder(null);
        this.status.setForeground(Color.red);
        this.status.setBackground(this.getBackground());
        this.status.setLineWrap(true);
        this.status.setEditable(false);
        this.add(this.status);
    }

    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        Dimension size = super.getPreferredSize();
        size.width = this.expr.getPreferredSize().width;
        if (insets != null) {
            size.width += insets.left + insets.right;
        }
        return size;
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.expr) {
            this.expr.setForeground(this.DEFAULT_FG);
            this.expr.setToolTipText(Strings.get("expression.text.tip"));
            this.step.setExpression(this.expr.getText());
            this.status.setText("");
            this.fireStepChanged();
        } else if (ev.getSource() == this.run) {
            this.expr.setForeground(this.DEFAULT_FG);
            this.expr.setToolTipText(Strings.get("expression.text.tip"));
            this.status.setText("");
            new Thread("expression runner"){

                public void run() {
                    try {
                        ExpressionEditor.this.step.run();
                    }
                    catch (Throwable e) {
                        if (e instanceof EvalError) {
                            ExpressionEditor.this.expr.setForeground(Color.red);
                        }
                        ExpressionEditor.this.status.setText(e.getMessage());
                    }
                    ExpressionEditor.this.fireStepChanged();
                }
            }.start();
        } else {
            super.actionPerformed(ev);
        }
    }
}

