/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.recorder;

import abbot.BugReport;
import abbot.editor.recorder.SemanticEvents;
import abbot.script.Resolver;
import abbot.script.Step;
import java.awt.AWTEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

public abstract class SemanticRecorder
implements SemanticEvents {
    private ActionListener al;
    private Resolver resolver;
    protected ArrayList events = new ArrayList();
    private Step step = null;
    private int recordingType = -1;
    private BugReport bug;
    private volatile boolean isFinished;

    public SemanticRecorder(Resolver resolver) {
        this.resolver = resolver;
    }

    public void addActionListener(ActionListener al) {
        this.al = al;
    }

    public int getRecordingType() {
        return this.recordingType;
    }

    protected void setRecordingType(int type) {
        this.recordingType = type;
    }

    protected void init(int recordingType) {
        this.events.clear();
        this.step = null;
        this.bug = null;
        this.setFinished(false);
        this.setRecordingType(recordingType);
    }

    public abstract boolean accept(AWTEvent var1);

    public final boolean record(AWTEvent event) {
        if (!this.isFinished()) {
            try {
                if (this.parse(event)) {
                    this.events.add(event);
                    return true;
                }
            }
            catch (BugReport br) {
                this.setFinished(true);
                this.bug = br;
            }
        }
        return false;
    }

    public abstract boolean parse(AWTEvent var1);

    protected Resolver getResolver() {
        return this.resolver;
    }

    public synchronized Step getStep() throws BugReport {
        if (this.bug != null) {
            throw this.bug;
        }
        if (this.step == null) {
            this.step = this.createStep();
        }
        return this.step;
    }

    protected abstract Step createStep();

    protected synchronized void setStep(Step newStep) {
        this.events.clear();
        this.step = newStep;
    }

    public synchronized boolean isFinished() {
        return this.isFinished;
    }

    protected synchronized void setFinished(boolean state) {
        this.isFinished = state;
    }

    protected void setStatus(String msg) {
        if (this.al != null) {
            ActionEvent event = new ActionEvent(this, 1001, msg);
            this.al.actionPerformed(event);
        }
    }
}

