/*
 * Decompiled with CFR 0.152.
 */
package abbot.i18n;

import abbot.Log;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class Strings {
    private static final String BUNDLE = "abbot.i18n.StringsBundle";
    private static Set bundles = new HashSet();
    private static Map formats = new HashMap();

    private Strings() {
    }

    public static void addBundle(String bundle) {
        Locale locale = Locale.getDefault();
        try {
            bundles.add(ResourceBundle.getBundle(bundle, locale));
        }
        catch (MissingResourceException mre) {
            String msg = "No resource bundle found in " + bundle;
            if (System.getProperty("java.class.path").indexOf("eclipse") != -1) {
                Log.warn(msg + ": copy one into your project output dir or run the ant build");
            }
            throw new Error(msg);
        }
    }

    public static String get(String key) {
        return Strings.get(key, false);
    }

    public static String get(String key, boolean optional) {
        String defaultValue = "#" + key + "#";
        String value = null;
        for (ResourceBundle local : bundles) {
            try {
                value = local.getString(key);
            }
            catch (MissingResourceException mre) {}
        }
        if (value == null && !optional) {
            Log.log("Missing resource '" + key + "'");
            value = defaultValue;
        }
        return value;
    }

    public static String get(String key, Object[] args) {
        MessageFormat fmt = (MessageFormat)formats.get(key);
        if (fmt == null) {
            fmt = new MessageFormat(Strings.get(key));
            formats.put(key, fmt);
        }
        return fmt.format(args);
    }

    static {
        String language = System.getProperty("abbot.locale.language");
        if (language != null) {
            String country = System.getProperty("abbot.locale.country", language.toUpperCase());
            String variant = System.getProperty("abbot.locale.variant", "");
            Locale locale = new Locale(language, country, variant);
            Locale.setDefault(locale);
            System.out.println("Using locale " + locale);
        }
        Strings.addBundle(BUNDLE);
    }
}

