/*
 * Decompiled with CFR 0.152.
 */
package abbot.script;

import abbot.AssertionFailedError;
import abbot.Log;
import abbot.WaitTimedOutError;
import abbot.i18n.Strings;
import abbot.script.ArgumentParser;
import abbot.script.PropertyCall;
import abbot.script.Resolver;
import abbot.tester.ComponentTester;
import abbot.util.ExtendedComparator;
import java.util.Map;
import javax.swing.tree.TreePath;

public class Assert
extends PropertyCall {
    public static final int DEFAULT_INTERVAL = 100;
    public static final int DEFAULT_TIMEOUT = 10000;
    private static final String ASSERT_USAGE = "<assert component=... method=... value=... [invert=true]/>\n<assert method=[!]... [class=...]/>";
    private static final String WAIT_USAGE = "<wait component=... method=... value=... [invert=true] [timeout=...] [pollInterval=...]/>\n<wait method=[!]... [class=...] [timeout=...] [pollInterval=...]/>";
    private String expectedResult = "true";
    private boolean invert;
    private boolean wait;
    private long interval = 100L;
    private long timeout = 10000L;

    public Assert(Resolver resolver, Map attributes) {
        super(resolver, Assert.patchAttributes(attributes));
        String pi;
        this.wait = attributes.get("wait") != null;
        String to = (String)attributes.get("timeout");
        if (to != null) {
            try {
                this.timeout = Integer.parseInt(to);
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        if ((pi = (String)attributes.get("pollInterval")) != null) {
            try {
                this.interval = Integer.parseInt(pi);
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        this.init(Boolean.valueOf((String)attributes.get("invert")), (String)attributes.get("value"));
    }

    public Assert(Resolver resolver, String desc, String targetClassName, String methodName, String[] args, String expectedResult, boolean invert) {
        super(resolver, desc, targetClassName != null ? targetClassName : ComponentTester.class.getName(), methodName, args);
        this.init(invert, expectedResult);
    }

    public Assert(Resolver resolver, String desc, String methodName, String[] args, Class testedClass, String expectedResult, boolean invert) {
        super(resolver, desc, testedClass.getName(), methodName, args);
        this.init(invert, expectedResult);
    }

    public Assert(Resolver resolver, String desc, String methodName, String componentID, String expectedResult, boolean invert) {
        super(resolver, desc, methodName, componentID);
        this.init(invert, expectedResult);
    }

    private void init(boolean inverted, String value) {
        if ("false".equals(value)) {
            inverted = !inverted;
            value = "true";
        }
        this.expectedResult = value != null ? value : "true";
        this.invert = inverted;
    }

    public void setWait(boolean wait) {
        this.wait = wait;
    }

    public boolean isWait() {
        return this.wait;
    }

    public void setPollInterval(long interval) {
        this.interval = interval;
    }

    public long getPollInterval() {
        return this.interval;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public String getExpectedResult() {
        return this.expectedResult;
    }

    public void setExpectedResult(String result) {
        this.init(this.invert, result);
    }

    public boolean isInverted() {
        return this.invert;
    }

    public void setInverted(boolean invert) {
        this.init(invert, this.expectedResult);
    }

    private static Map patchAttributes(Map map) {
        String cls;
        String method = (String)map.get("method");
        if (method != null && method.startsWith("!")) {
            map.put("method", method.substring(1));
            map.put("invert", "true");
        }
        if ((cls = (String)map.get("class")) == null) {
            map.put("class", "abbot.tester.ComponentTester");
        }
        return map;
    }

    public String getXMLTag() {
        return this.wait ? "wait" : "assert";
    }

    public String getUsage() {
        return this.wait ? WAIT_USAGE : ASSERT_USAGE;
    }

    public String getDefaultDescription() {
        String mname = this.getMethodName();
        if (mname.startsWith("assert")) {
            mname = mname.substring(6);
        } else if (mname.startsWith("get") || mname.startsWith("has")) {
            mname = mname.substring(3);
        } else if (mname.startsWith("is")) {
            mname = mname.substring(2);
        }
        String expression = mname + this.getArgumentsDescription();
        if (this.getComponentID() != null) {
            expression = "${" + this.getComponentID() + "}." + expression;
        }
        if (this.invert && "true".equals(this.expectedResult)) {
            expression = "!" + expression;
        }
        if (!"true".equals(this.expectedResult)) {
            expression = expression + (this.invert ? " != " : " == ");
            expression = expression + this.expectedResult;
        }
        if (this.wait && this.timeout != 10000L) {
            expression = expression + " " + Strings.get(this.timeout > 5000L ? "wait.seconds" : "wait.milliseconds", new Object[]{String.valueOf(this.timeout > 5000L ? this.timeout / 1000L : this.timeout)});
        }
        return Strings.get(this.wait ? "wait.desc" : "assert.desc", new Object[]{expression});
    }

    public Map getAttributes() {
        Map map = super.getAttributes();
        if (this.invert) {
            map.put("invert", "true");
        }
        if (!this.expectedResult.equalsIgnoreCase("true")) {
            map.put("value", this.expectedResult);
        }
        if (this.timeout != 10000L) {
            map.put("timeout", String.valueOf(this.timeout));
        }
        if (this.interval != 100L) {
            map.put("pollInterval", String.valueOf(this.interval));
        }
        return map;
    }

    protected void evaluateAssertion() throws Throwable {
        Object expected;
        Class<?> type = this.getMethod().getReturnType();
        boolean compareStrings = false;
        try {
            expected = ArgumentParser.eval(this.getResolver(), this.expectedResult, type);
        }
        catch (IllegalArgumentException iae) {
            expected = this.expectedResult;
            compareStrings = true;
        }
        Object actual = this.invoke();
        if (expected instanceof TreePath && actual instanceof TreePath) {
            expected = ArgumentParser.toString(((TreePath)expected).getPath());
            actual = ArgumentParser.toString(((TreePath)actual).getPath());
        }
        if (compareStrings) {
            actual = ArgumentParser.toString(actual);
        }
        if (this.invert) {
            this.assertNotEquals(this.toString(), expected, actual);
        } else {
            this.assertEquals(this.toString(), expected, actual);
        }
    }

    private void assertEquals(String message, Object expected, Object actual) {
        if (!ExtendedComparator.equals(expected, actual)) {
            String msg = Strings.get("assert.comparison_failed", new Object[]{message != null ? message + " " : "", ArgumentParser.toString(actual)});
            throw new AssertionFailedError(msg, this);
        }
    }

    private void assertNotEquals(String message, Object expected, Object actual) {
        if (ExtendedComparator.equals(expected, actual)) {
            String msg = message != null ? message : "";
            throw new AssertionFailedError(msg, this);
        }
    }

    protected void runStep() throws Throwable {
        if (this.wait) {
            long start;
            long now = System.currentTimeMillis();
            for (long remaining = this.timeout; remaining > 0L; remaining -= now - start) {
                start = now;
                try {
                    try {
                        this.evaluateAssertion();
                        return;
                    }
                    catch (AssertionFailedError exc) {
                        Log.debug((Throwable)((Object)exc));
                        Thread.sleep(this.interval);
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                now = System.currentTimeMillis();
            }
            throw new WaitTimedOutError(Strings.get("wait.timed_out", new Object[]{String.valueOf(this.timeout), this.toString()}));
        }
        this.evaluateAssertion();
    }
}

