/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.finder.BasicFinder;
import abbot.finder.ComponentFinder;
import abbot.finder.ComponentSearchException;
import abbot.finder.Matcher;
import abbot.finder.matchers.ClassMatcher;
import abbot.i18n.Strings;
import abbot.tester.ActionFailedException;
import abbot.tester.JComponentTester;
import abbot.tester.JTextComponentTester;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;

public class JFileChooserTester
extends JComponentTester {
    private JTextComponentTester tester = new JTextComponentTester();
    private ComponentFinder finder = BasicFinder.getDefault();

    private Component find(Container chooser, Matcher m) {
        try {
            return this.finder.find(chooser, m);
        }
        catch (ComponentSearchException e) {
            return null;
        }
    }

    private JButton findButton(Container chooser, final String text) {
        JButton button = (JButton)this.find(chooser, new ClassMatcher(JButton.class){

            public boolean matches(Component c) {
                return super.matches(c) && text.equals(((JButton)c).getText());
            }
        });
        return button;
    }

    public void actionSetFilename(Component c, String filename) {
        JTextField tf = (JTextField)this.find((JFileChooser)c, new ClassMatcher(JTextField.class));
        if (tf == null) {
            String msg = Strings.get("tester.JFileChooser.filename_not_found");
            throw new ActionFailedException(msg);
        }
        this.tester.actionEnterText(tf, filename);
    }

    public void actionSetDirectory(Component c, String path) {
        JFileChooser chooser = (JFileChooser)c;
        chooser.setCurrentDirectory(new File(path));
        this.waitForIdle();
    }

    public void actionApprove(Component c) {
        JButton approve;
        JFileChooser chooser = (JFileChooser)c;
        String text = chooser.getApproveButtonText();
        if (text == null) {
            text = chooser.getUI().getApproveButtonText(chooser);
        }
        if ((approve = this.findButton(chooser, text)) == null) {
            String msg = Strings.get("tester.JFileChooser.approve_not_found");
            throw new ActionFailedException(msg);
        }
        this.actionClick(approve);
    }

    public void actionCancel(Component c) {
        JFileChooser chooser = (JFileChooser)c;
        JButton cancel = this.findButton(chooser, "Cancel");
        if (cancel == null) {
            String msg = Strings.get("tester.JFileChooser.cancel_not_found");
            throw new ActionFailedException(msg);
        }
        this.actionClick(cancel);
    }
}

