/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.tester.ActionFailedException;
import abbot.tester.JComponentTester;
import abbot.tester.Robot;
import java.awt.Component;
import java.awt.Point;
import java.beans.PropertyVetoException;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;

public class JInternalFrameTester
extends JComponentTester {
    protected void maximize(final JInternalFrame frame, final boolean b) {
        if (b && !frame.isMaximizable()) {
            throw new ActionFailedException("The given JInternalFrame (" + JInternalFrameTester.toString(frame) + ") is not " + "maximizable");
        }
        if (!b && frame.isIcon()) {
            throw new ActionFailedException("The given JInternalFrame (" + JInternalFrameTester.toString(frame) + ") is " + "iconified and must be " + "deiconified before it can " + "be normalized");
        }
        JComponent clickTarget = frame;
        if (frame.isIcon()) {
            clickTarget = frame.getDesktopIcon();
        }
        Point p = this.getMaximizeLocation(clickTarget);
        this.mouseMove(clickTarget, p.x, p.y);
        if (frame.isIcon()) {
            this.iconify(frame, false);
        }
        final VetoFailure veto = new VetoFailure();
        this.invokeAndWait(new Runnable(){

            public void run() {
                try {
                    frame.setMaximum(b);
                }
                catch (PropertyVetoException e) {
                    veto.e = e;
                }
            }
        });
        if (veto.e != null) {
            throw new ActionFailedException("Maximize of " + Robot.toString(frame) + " was vetoed (" + veto.e + ")");
        }
    }

    public void actionMaximize(Component comp) {
        this.maximize((JInternalFrame)comp, true);
    }

    public void actionNormalize(Component comp) {
        this.maximize((JInternalFrame)comp, false);
    }

    protected void iconify(final JInternalFrame frame, final boolean b) {
        if (b && frame.isIcon() || !b && !frame.isIcon()) {
            return;
        }
        if (b) {
            if (!frame.isIconifiable()) {
                throw new ActionFailedException("The given JInternalFrame (" + JInternalFrameTester.toString(frame) + ") is not " + "iconifiable");
            }
            Point p = this.getIconifyLocation(frame);
            this.mouseMove(frame, p.x, p.y);
        } else {
            JInternalFrame.JDesktopIcon c = frame.getDesktopIcon();
            Point p = this.getIconifyLocation(c);
            this.mouseMove(c, p.x, p.y);
        }
        final VetoFailure veto = new VetoFailure();
        this.invokeAndWait(new Runnable(){

            public void run() {
                try {
                    frame.setIcon(b);
                }
                catch (PropertyVetoException e) {
                    veto.e = e;
                }
            }
        });
        if (veto.e != null) {
            throw new ActionFailedException("Iconify of " + Robot.toString(frame) + " was vetoed (" + veto.e + ")");
        }
    }

    public void actionIconify(Component comp) {
        this.iconify((JInternalFrame)comp, true);
    }

    public void actionDeiconify(Component comp) {
        this.iconify((JInternalFrame)comp, false);
    }

    public void actionMove(Component comp, int x, int y) {
        this.move((JInternalFrame)comp, x, y);
        this.waitForIdle();
    }

    public void actionResize(Component comp, int width, int height) {
        this.resize((JInternalFrame)comp, width, height);
        this.waitForIdle();
    }

    public void actionClose(Component comp) {
        final JInternalFrame frame = (JInternalFrame)comp;
        if (!frame.isClosable()) {
            throw new ActionFailedException("The given JInternalFrame (" + JInternalFrameTester.toString(frame) + ") is not " + "closable");
        }
        Point p = this.getCloseLocation(frame);
        this.mouseMove(frame, p.x, p.y);
        this.invokeAndWait(new Runnable(){

            public void run() {
                frame.doDefaultCloseAction();
            }
        });
    }

    private class VetoFailure {
        public PropertyVetoException e = null;

        private VetoFailure() {
        }
    }
}

