/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent3DRetained;
import javax.media.j3d.ImageComponentRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;

public class ImageComponent3D
extends ImageComponent {
    ImageComponent3D() {
    }

    public ImageComponent3D(int n, int n2, int n3, int n4) {
        ((ImageComponent3DRetained)this.retained).processParams(n, n2, n3, n4);
        ((ImageComponent3DRetained)this.retained).setDepth(n4);
    }

    public ImageComponent3D(int n, BufferedImage[] bufferedImageArray) {
        ((ImageComponent3DRetained)this.retained).processParams(n, bufferedImageArray[0].getWidth(null), bufferedImageArray[0].getHeight(null), bufferedImageArray.length);
        ((ImageComponent3DRetained)this.retained).setDepth(bufferedImageArray.length);
        for (int i = 0; i < bufferedImageArray.length; ++i) {
            ((ImageComponent3DRetained)this.retained).set(i, bufferedImageArray[i]);
        }
    }

    public ImageComponent3D(int n, RenderedImage[] renderedImageArray) {
        ((ImageComponent3DRetained)this.retained).processParams(n, renderedImageArray[0].getWidth(), renderedImageArray[0].getHeight(), renderedImageArray.length);
        ((ImageComponent3DRetained)this.retained).setDepth(renderedImageArray.length);
        for (int i = 0; i < renderedImageArray.length; ++i) {
            ((ImageComponent3DRetained)this.retained).set(i, renderedImageArray[i]);
        }
    }

    public ImageComponent3D(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        ((ImageComponentRetained)this.retained).setByReference(bl);
        ((ImageComponentRetained)this.retained).setYUp(bl2);
        ((ImageComponent3DRetained)this.retained).processParams(n, n2, n3, n4);
        ((ImageComponent3DRetained)this.retained).setDepth(n4);
    }

    public ImageComponent3D(int n, BufferedImage[] bufferedImageArray, boolean bl, boolean bl2) {
        ((ImageComponentRetained)this.retained).setByReference(bl);
        ((ImageComponentRetained)this.retained).setYUp(bl2);
        ((ImageComponent3DRetained)this.retained).processParams(n, bufferedImageArray[0].getWidth(null), bufferedImageArray[0].getHeight(null), bufferedImageArray.length);
        ((ImageComponent3DRetained)this.retained).setDepth(bufferedImageArray.length);
        for (int i = 0; i < bufferedImageArray.length; ++i) {
            ((ImageComponent3DRetained)this.retained).set(i, bufferedImageArray[i]);
        }
    }

    public ImageComponent3D(int n, RenderedImage[] renderedImageArray, boolean bl, boolean bl2) {
        ((ImageComponentRetained)this.retained).setByReference(bl);
        ((ImageComponentRetained)this.retained).setYUp(bl2);
        ((ImageComponent3DRetained)this.retained).processParams(n, renderedImageArray[0].getWidth(), renderedImageArray[0].getHeight(), renderedImageArray.length);
        ((ImageComponent3DRetained)this.retained).setDepth(renderedImageArray.length);
        for (int i = 0; i < renderedImageArray.length; ++i) {
            ((ImageComponent3DRetained)this.retained).set(i, renderedImageArray[i]);
        }
    }

    public int getDepth() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent3D0"));
        }
        return ((ImageComponent3DRetained)this.retained).getDepth();
    }

    public void set(BufferedImage[] bufferedImageArray) {
        this.checkForLiveOrCompiled();
        int n = ((ImageComponent3DRetained)this.retained).getDepth();
        if (n != bufferedImageArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent3D1"));
        }
        for (int i = 0; i < n; ++i) {
            ((ImageComponent3DRetained)this.retained).set(i, bufferedImageArray[i]);
        }
    }

    public void set(RenderedImage[] renderedImageArray) {
        this.checkForLiveOrCompiled();
        int n = ((ImageComponent3DRetained)this.retained).getDepth();
        if (n != renderedImageArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent3D1"));
        }
        for (int i = 0; i < n; ++i) {
            ((ImageComponent3DRetained)this.retained).set(i, renderedImageArray[i]);
        }
    }

    public void set(int n, BufferedImage bufferedImage) {
        this.checkForLiveOrCompiled();
        if (bufferedImage.getWidth(null) != this.getWidth()) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent3D2"));
        }
        if (bufferedImage.getHeight(null) != this.getHeight()) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent3D4"));
        }
        ((ImageComponent3DRetained)this.retained).set(n, bufferedImage);
    }

    public void set(int n, RenderedImage renderedImage) {
        this.checkForLiveOrCompiled();
        if (renderedImage.getWidth() != this.getWidth()) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent3D2"));
        }
        if (renderedImage.getHeight() != this.getHeight()) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent3D4"));
        }
        ((ImageComponent3DRetained)this.retained).set(n, renderedImage);
    }

    public BufferedImage[] getImage() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent3D3"));
        }
        return ((ImageComponent3DRetained)this.retained).getImage();
    }

    public RenderedImage[] getRenderedImage() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent3D3"));
        }
        return ((ImageComponent3DRetained)this.retained).getRenderedImage();
    }

    public BufferedImage getImage(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent3D3"));
        }
        RenderedImage renderedImage = ((ImageComponent3DRetained)this.retained).getImage(n);
        if (renderedImage != null && !(renderedImage instanceof BufferedImage)) {
            throw new IllegalStateException(J3dI18N.getString("ImageComponent3D9"));
        }
        return (BufferedImage)renderedImage;
    }

    public RenderedImage getRenderedImage(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent3D3"));
        }
        return ((ImageComponent3DRetained)this.retained).getImage(n);
    }

    public void setSubImage(int n, RenderedImage renderedImage, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent3D5"));
        }
        if (((ImageComponent3DRetained)this.retained).isByReference()) {
            throw new IllegalStateException(J3dI18N.getString("ImageComponent3D8"));
        }
        int n8 = ((ImageComponent3DRetained)this.retained).getWidth();
        int n9 = ((ImageComponent3DRetained)this.retained).getHeight();
        if (n4 < 0 || n5 < 0 || n4 + n2 > n8 || n5 + n3 > n9 || n6 < 0 || n7 < 0 || n6 + n2 > n8 || n7 + n3 > n9) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent3D7"));
        }
        ((ImageComponent3DRetained)this.retained).setSubImage(n, renderedImage, n2, n3, n4, n5, n6, n7);
    }

    public void updateData(Updater updater, int n, int n2, int n3, int n4, int n5) {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ImageComponent3D5"));
        }
        if (!((ImageComponent3DRetained)this.retained).isByReference()) {
            throw new IllegalStateException(J3dI18N.getString("ImageComponent3D6"));
        }
        int n6 = ((ImageComponent3DRetained)this.retained).getWidth();
        int n7 = ((ImageComponent3DRetained)this.retained).getHeight();
        if (n2 < 0 || n3 < 0 || n2 + n4 > n6 || n3 + n5 > n7) {
            throw new IllegalArgumentException(J3dI18N.getString("ImageComponent3D7"));
        }
        ((ImageComponent3DRetained)this.retained).updateData(updater, n, n2, n3, n4, n5);
    }

    void createRetained() {
        this.retained = new ImageComponent3DRetained();
        this.retained.setSource(this);
    }

    public NodeComponent cloneNodeComponent() {
        ImageComponent3DRetained imageComponent3DRetained = (ImageComponent3DRetained)this.retained;
        ImageComponent3D imageComponent3D = new ImageComponent3D(imageComponent3DRetained.format, imageComponent3DRetained.width, imageComponent3DRetained.height, imageComponent3DRetained.depth);
        imageComponent3D.duplicateNodeComponent(this);
        return imageComponent3D;
    }

    void duplicateAttributes(NodeComponent nodeComponent, boolean bl) {
        super.duplicateAttributes(nodeComponent, bl);
        BufferedImage[] bufferedImageArray = ((ImageComponent3DRetained)nodeComponent.retained).getImage();
        if (bufferedImageArray != null) {
            ImageComponent3DRetained imageComponent3DRetained = (ImageComponent3DRetained)this.retained;
            for (int i = imageComponent3DRetained.depth - 1; i >= 0; --i) {
                if (bufferedImageArray[i] == null) continue;
                imageComponent3DRetained.set(i, (RenderedImage)bufferedImageArray[i]);
            }
        }
    }

    public static interface Updater {
        public void updateData(ImageComponent3D var1, int var2, int var3, int var4, int var5, int var6);
    }
}

