/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;

public abstract class IndexedGeometryArray
extends GeometryArray {
    public static final int ALLOW_COORDINATE_INDEX_READ = 9;
    public static final int ALLOW_COORDINATE_INDEX_WRITE = 10;
    public static final int ALLOW_COLOR_INDEX_READ = 11;
    public static final int ALLOW_COLOR_INDEX_WRITE = 12;
    public static final int ALLOW_NORMAL_INDEX_READ = 13;
    public static final int ALLOW_NORMAL_INDEX_WRITE = 14;
    public static final int ALLOW_TEXCOORD_INDEX_READ = 15;
    public static final int ALLOW_TEXCOORD_INDEX_WRITE = 16;

    IndexedGeometryArray() {
    }

    public IndexedGeometryArray(int n, int n2, int n3) {
        super(n, n2);
        ((IndexedGeometryArrayRetained)this.retained).createIndexedGeometryArrayData(n3);
    }

    public IndexedGeometryArray(int n, int n2, int n3, int[] nArray, int n4) {
        super(n, n2, n3, nArray);
        ((IndexedGeometryArrayRetained)this.retained).createIndexedGeometryArrayData(n4);
    }

    public int getIndexCount() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray0"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getIndexCount();
    }

    public void setValidIndexCount(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray16"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setValidIndexCount(n);
    }

    public int getValidIndexCount() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray17"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getValidIndexCount();
    }

    public void setInitialIndexIndex(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray18"));
        }
        if (n < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryArray20"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setInitialIndexIndex(n);
    }

    public int getInitialIndexIndex() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray19"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getInitialIndexIndex();
    }

    public void setInitialVertexIndex(int n) {
        throw new UnsupportedOperationException();
    }

    public void setInitialCoordIndex(int n) {
        throw new UnsupportedOperationException();
    }

    public void setInitialColorIndex(int n) {
        throw new UnsupportedOperationException();
    }

    public void setInitialNormalIndex(int n) {
        throw new UnsupportedOperationException();
    }

    public void setInitialTexCoordIndex(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public void setValidVertexCount(int n) {
        throw new UnsupportedOperationException();
    }

    public void setCoordinateIndex(int n, int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray1"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setCoordinateIndex(n, n2);
    }

    public void setCoordinateIndices(int n, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray1"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setCoordinateIndices(n, nArray);
    }

    public void setColorIndex(int n, int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray3"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setColorIndex(n, n2);
    }

    public void setColorIndices(int n, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray3"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setColorIndices(n, nArray);
    }

    public void setNormalIndex(int n, int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray5"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setNormalIndex(n, n2);
    }

    public void setNormalIndices(int n, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray5"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setNormalIndices(n, nArray);
    }

    public void setTextureCoordinateIndex(int n, int n2) {
        this.setTextureCoordinateIndex(0, n, n2);
    }

    public void setTextureCoordinateIndex(int n, int n2, int n3) {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray7"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setTextureCoordinateIndex(n, n2, n3);
    }

    public void setTextureCoordinateIndices(int n, int[] nArray) {
        this.setTextureCoordinateIndices(0, n, nArray);
    }

    public void setTextureCoordinateIndices(int n, int n2, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray7"));
        }
        ((IndexedGeometryArrayRetained)this.retained).setTextureCoordinateIndices(n, n2, nArray);
    }

    public int getCoordinateIndex(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray9"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getCoordinateIndex(n);
    }

    public void getCoordinateIndices(int n, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray9"));
        }
        ((IndexedGeometryArrayRetained)this.retained).getCoordinateIndices(n, nArray);
    }

    public int getColorIndex(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray11"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getColorIndex(n);
    }

    public void getColorIndices(int n, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray11"));
        }
        ((IndexedGeometryArrayRetained)this.retained).getColorIndices(n, nArray);
    }

    public int getNormalIndex(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray13"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getNormalIndex(n);
    }

    public void getNormalIndices(int n, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray13"));
        }
        ((IndexedGeometryArrayRetained)this.retained).getNormalIndices(n, nArray);
    }

    public int getTextureCoordinateIndex(int n) {
        return this.getTextureCoordinateIndex(0, n);
    }

    public int getTextureCoordinateIndex(int n, int n2) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray15"));
        }
        return ((IndexedGeometryArrayRetained)this.retained).getTextureCoordinateIndex(n, n2);
    }

    public void getTextureCoordinateIndices(int n, int[] nArray) {
        this.getTextureCoordinateIndices(0, n, nArray);
    }

    public void getTextureCoordinateIndices(int n, int n2, int[] nArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("IndexedGeometryArray15"));
        }
        ((IndexedGeometryArrayRetained)this.retained).getTextureCoordinateIndices(n, n2, nArray);
    }

    void duplicateAttributes(NodeComponent nodeComponent, boolean bl) {
        super.duplicateAttributes(nodeComponent, bl);
        IndexedGeometryArrayRetained indexedGeometryArrayRetained = (IndexedGeometryArrayRetained)nodeComponent.retained;
        IndexedGeometryArrayRetained indexedGeometryArrayRetained2 = (IndexedGeometryArrayRetained)this.retained;
        int n = indexedGeometryArrayRetained.getVertexFormat();
        int[] nArray = new int[indexedGeometryArrayRetained.getIndexCount()];
        if ((n & 1) != 0) {
            indexedGeometryArrayRetained.getCoordinateIndices(0, nArray);
            indexedGeometryArrayRetained2.setCoordinateIndices(0, nArray);
        }
        if ((n & 2) != 0) {
            indexedGeometryArrayRetained.getNormalIndices(0, nArray);
            indexedGeometryArrayRetained2.setNormalIndices(0, nArray);
        }
        if ((n & 4) != 0) {
            indexedGeometryArrayRetained.getColorIndices(0, nArray);
            indexedGeometryArrayRetained2.setColorIndices(0, nArray);
        }
        if ((n & 0x460) != 0) {
            for (int i = 0; i < indexedGeometryArrayRetained.texCoordSetCount; ++i) {
                indexedGeometryArrayRetained.getTextureCoordinateIndices(i, 0, nArray);
                indexedGeometryArrayRetained2.setTextureCoordinateIndices(i, 0, nArray);
            }
        }
    }
}

