/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Hashtable;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.TextureRetained;
import javax.vecmath.Color4f;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;

public abstract class Texture
extends NodeComponent {
    public static final int ALLOW_ENABLE_READ = 0;
    public static final int ALLOW_ENABLE_WRITE = 1;
    public static final int ALLOW_BOUNDARY_MODE_READ = 2;
    public static final int ALLOW_FILTER_READ = 3;
    public static final int ALLOW_IMAGE_READ = 4;
    public static final int ALLOW_IMAGE_WRITE = 7;
    public static final int ALLOW_FORMAT_READ = 9;
    public static final int ALLOW_SIZE_READ = 8;
    public static final int ALLOW_MIPMAP_MODE_READ = 5;
    public static final int ALLOW_BOUNDARY_COLOR_READ = 6;
    public static final int ALLOW_LOD_RANGE_READ = 10;
    public static final int ALLOW_LOD_RANGE_WRITE = 11;
    public static final int ALLOW_ANISOTROPIC_FILTER_READ = 12;
    public static final int ALLOW_SHARPEN_TEXTURE_READ = 13;
    public static final int ALLOW_FILTER4_READ = 14;
    public static final int FASTEST = 0;
    public static final int NICEST = 1;
    public static final int BASE_LEVEL_POINT = 2;
    public static final int BASE_LEVEL_LINEAR = 3;
    public static final int MULTI_LEVEL_POINT = 4;
    public static final int MULTI_LEVEL_LINEAR = 5;
    public static final int LINEAR_SHARPEN = 9;
    public static final int LINEAR_SHARPEN_RGB = 10;
    public static final int LINEAR_SHARPEN_ALPHA = 11;
    public static final int FILTER4 = 12;
    public static final int CLAMP = 2;
    public static final int WRAP = 3;
    public static final int CLAMP_TO_EDGE = 4;
    public static final int CLAMP_TO_BOUNDARY = 5;
    public static final int BASE_LEVEL = 1;
    public static final int MULTI_LEVEL_MIPMAP = 2;
    public static final int INTENSITY = 1;
    public static final int LUMINANCE = 2;
    public static final int ALPHA = 3;
    public static final int LUMINANCE_ALPHA = 4;
    public static final int RGB = 5;
    public static final int RGBA = 6;
    public static final int ANISOTROPIC_NONE = 0;
    public static final int ANISOTROPIC_SINGLE_VALUE = 1;

    public Texture() {
    }

    public Texture(int n, int n2, int n3, int n4) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture0"));
        }
        if (n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4 && n2 != 5 && n2 != 6) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture1"));
        }
        int n5 = Texture.getPowerOf2(n3);
        if (n5 == -1) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture2"));
        }
        int n6 = Texture.getPowerOf2(n4);
        if (n6 == -1) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture3"));
        }
        ((TextureRetained)this.retained).initialize(n2, n3, n5, n4, n6, n, 0);
    }

    public Texture(int n, int n2, int n3, int n4, int n5) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture0"));
        }
        if (n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4 && n2 != 5 && n2 != 6) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture1"));
        }
        int n6 = Texture.getPowerOf2(n3);
        if (n6 == -1) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture2"));
        }
        int n7 = Texture.getPowerOf2(n4);
        if (n7 == -1) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture3"));
        }
        if (n5 < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture30"));
        }
        ((TextureRetained)this.retained).initialize(n2, n3, n6, n4, n7, n, n5);
    }

    public void setBoundaryModeS(int n) {
        this.checkForLiveOrCompiled();
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("Texture31"));
            }
        }
        ((TextureRetained)this.retained).initBoundaryModeS(n);
    }

    public int getBoundaryModeS() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture4"));
        }
        return ((TextureRetained)this.retained).getBoundaryModeS();
    }

    public void setBoundaryModeT(int n) {
        this.checkForLiveOrCompiled();
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("Texture31"));
            }
        }
        ((TextureRetained)this.retained).initBoundaryModeT(n);
    }

    public int getBoundaryModeT() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture4"));
        }
        return ((TextureRetained)this.retained).getBoundaryModeT();
    }

    public void setMinFilter(int n) {
        this.checkForLiveOrCompiled();
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: {
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("Texture28"));
            }
        }
        ((TextureRetained)this.retained).initMinFilter(n);
    }

    public int getMinFilter() {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture6"));
        }
        return ((TextureRetained)this.retained).getMinFilter();
    }

    public void setMagFilter(int n) {
        this.checkForLiveOrCompiled();
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("Texture29"));
            }
        }
        ((TextureRetained)this.retained).initMagFilter(n);
    }

    public int getMagFilter() {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture6"));
        }
        return ((TextureRetained)this.retained).getMagFilter();
    }

    public void setImage(int n, ImageComponent imageComponent) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture15"));
        }
        if (this.isLive()) {
            ((TextureRetained)this.retained).setImage(n, imageComponent);
        } else {
            ((TextureRetained)this.retained).initImage(n, imageComponent);
        }
    }

    public ImageComponent getImage(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture9"));
        }
        return ((TextureRetained)this.retained).getImage(n);
    }

    public void setImages(ImageComponent[] imageComponentArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture15"));
        }
        if (imageComponentArray == null) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture20"));
        }
        if (this.isLive()) {
            ((TextureRetained)this.retained).setImages(imageComponentArray);
        } else {
            ((TextureRetained)this.retained).initImages(imageComponentArray);
        }
    }

    public ImageComponent[] getImages() {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture9"));
        }
        return ((TextureRetained)this.retained).getImages();
    }

    public int getFormat() {
        if (this.isLiveOrCompiled() && !this.getCapability(9)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture19"));
        }
        return ((TextureRetained)this.retained).getFormat();
    }

    public int getWidth() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture16"));
        }
        return ((TextureRetained)this.retained).getWidth();
    }

    public int getHeight() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture17"));
        }
        return ((TextureRetained)this.retained).getHeight();
    }

    public int getBoundaryWidth() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture17"));
        }
        return ((TextureRetained)this.retained).getBoundaryWidth();
    }

    public int numMipMapLevels() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture18"));
        }
        return ((TextureRetained)this.retained).numMipMapLevels();
    }

    public void setMipMapMode(int n) {
        this.checkForLiveOrCompiled();
        ((TextureRetained)this.retained).initMipMapMode(n);
    }

    public int getMipMapMode() {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture10"));
        }
        return ((TextureRetained)this.retained).getMipMapMode();
    }

    public void setEnable(boolean bl) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture11"));
        }
        if (this.isLive()) {
            ((TextureRetained)this.retained).setEnable(bl);
        } else {
            ((TextureRetained)this.retained).initEnable(bl);
        }
    }

    public boolean getEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture12"));
        }
        return ((TextureRetained)this.retained).getEnable();
    }

    static int getPowerOf2(int n) {
        if (n < 1) {
            return -1;
        }
        int n2 = n;
        for (int i = 0; i < 32; ++i) {
            if ((n2 & Integer.MIN_VALUE) != 0) {
                if ((n2 & Integer.MAX_VALUE) == 0) {
                    return 31 - i;
                }
                return -1;
            }
            n2 <<= 1;
        }
        return -1;
    }

    public void setBoundaryColor(Color4f color4f) {
        this.checkForLiveOrCompiled();
        ((TextureRetained)this.retained).initBoundaryColor(color4f);
    }

    public void setBoundaryColor(float f, float f2, float f3, float f4) {
        this.checkForLiveOrCompiled();
        ((TextureRetained)this.retained).initBoundaryColor(f, f2, f3, f4);
    }

    public void getBoundaryColor(Color4f color4f) {
        if (this.isLiveOrCompiled() && !this.getCapability(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture13"));
        }
        ((TextureRetained)this.retained).getBoundaryColor(color4f);
    }

    public void setBaseLevel(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture32"));
        }
        if (this.isLive()) {
            ((TextureRetained)this.retained).setBaseLevel(n);
        } else {
            ((TextureRetained)this.retained).initBaseLevel(n);
        }
    }

    public int getBaseLevel() {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture34"));
        }
        return ((TextureRetained)this.retained).getBaseLevel();
    }

    public void setMaximumLevel(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture33"));
        }
        if (this.isLive()) {
            ((TextureRetained)this.retained).setMaximumLevel(n);
        } else {
            ((TextureRetained)this.retained).initMaximumLevel(n);
        }
    }

    public int getMaximumLevel() {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture35"));
        }
        return ((TextureRetained)this.retained).getMaximumLevel();
    }

    public void setMinimumLOD(float f) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture38"));
        }
        if (this.isLive()) {
            ((TextureRetained)this.retained).setMinimumLOD(f);
        } else {
            ((TextureRetained)this.retained).initMinimumLOD(f);
        }
    }

    public float getMinimumLOD() {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture40"));
        }
        return ((TextureRetained)this.retained).getMinimumLOD();
    }

    public void setMaximumLOD(float f) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture39"));
        }
        if (this.isLive()) {
            ((TextureRetained)this.retained).setMaximumLOD(f);
        } else {
            ((TextureRetained)this.retained).initMaximumLOD(f);
        }
    }

    public float getMaximumLOD() {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture41"));
        }
        return ((TextureRetained)this.retained).getMaximumLOD();
    }

    public void setLodOffset(float f, float f2, float f3) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture44"));
        }
        if (this.isLive()) {
            ((TextureRetained)this.retained).setLodOffset(f, f2, f3);
        } else {
            ((TextureRetained)this.retained).initLodOffset(f, f2, f3);
        }
    }

    public void setLodOffset(Tuple3f tuple3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(11)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture44"));
        }
        if (this.isLive()) {
            ((TextureRetained)this.retained).setLodOffset(tuple3f.x, tuple3f.y, tuple3f.z);
        } else {
            ((TextureRetained)this.retained).initLodOffset(tuple3f.x, tuple3f.y, tuple3f.z);
        }
    }

    public void getLodOffset(Tuple3f tuple3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(10)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture45"));
        }
        ((TextureRetained)this.retained).getLodOffset(tuple3f);
    }

    public void setAnisotropicFilterMode(int n) {
        this.checkForLiveOrCompiled();
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture25"));
        }
        ((TextureRetained)this.retained).initAnisotropicFilterMode(n);
    }

    public int getAnisotropicFilterMode() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture26"));
        }
        return ((TextureRetained)this.retained).getAnisotropicFilterMode();
    }

    public void setAnisotropicFilterDegree(float f) {
        this.checkForLiveOrCompiled();
        if ((double)f < 1.0) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture27"));
        }
        ((TextureRetained)this.retained).initAnisotropicFilterDegree(f);
    }

    public float getAnisotropicFilterDegree() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture26"));
        }
        return ((TextureRetained)this.retained).getAnisotropicFilterDegree();
    }

    public void setSharpenTextureFunc(float[] fArray, float[] fArray2) {
        this.checkForLiveOrCompiled();
        if (!(fArray != null && fArray2 != null && fArray.length == fArray2.length || fArray == null && fArray2 == null)) {
            throw new IllegalStateException(J3dI18N.getString("Texture22"));
        }
        ((TextureRetained)this.retained).initSharpenTextureFunc(fArray, fArray2);
    }

    public void setSharpenTextureFunc(Point2f[] point2fArray) {
        this.checkForLiveOrCompiled();
        ((TextureRetained)this.retained).initSharpenTextureFunc(point2fArray);
    }

    public int getSharpenTextureFuncPointsCount() {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture21"));
        }
        return ((TextureRetained)this.retained).getSharpenTextureFuncPointsCount();
    }

    public void getSharpenTextureFunc(float[] fArray, float[] fArray2) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture21"));
        }
        ((TextureRetained)this.retained).getSharpenTextureFunc(fArray, fArray2);
    }

    public void getSharpenTextureFunc(Point2f[] point2fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture21"));
        }
        ((TextureRetained)this.retained).getSharpenTextureFunc(point2fArray);
    }

    public void setFilter4Func(float[] fArray) {
        this.checkForLiveOrCompiled();
        if (fArray == null || fArray.length < 4) {
            throw new IllegalArgumentException(J3dI18N.getString("Texture24"));
        }
        ((TextureRetained)this.retained).initFilter4Func(fArray);
    }

    public int getFilter4FuncPointsCount() {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture23"));
        }
        return ((TextureRetained)this.retained).getFilter4FuncPointsCount();
    }

    public void getFilter4Func(float[] fArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture23"));
        }
        ((TextureRetained)this.retained).getFilter4Func(fArray);
    }

    void duplicateAttributes(NodeComponent nodeComponent, boolean bl) {
        super.duplicateAttributes(nodeComponent, bl);
        Hashtable hashtable = nodeComponent.nodeHashtable;
        TextureRetained textureRetained = (TextureRetained)nodeComponent.retained;
        TextureRetained textureRetained2 = (TextureRetained)this.retained;
        textureRetained2.initBoundaryModeS(textureRetained.getBoundaryModeS());
        textureRetained2.initBoundaryModeT(textureRetained.getBoundaryModeT());
        textureRetained2.initMinFilter(textureRetained.getMinFilter());
        textureRetained2.initMagFilter(textureRetained.getMagFilter());
        textureRetained2.initMipMapMode(textureRetained.getMipMapMode());
        textureRetained2.initEnable(textureRetained.getEnable());
        textureRetained2.initAnisotropicFilterMode(textureRetained.getAnisotropicFilterMode());
        textureRetained2.initAnisotropicFilterDegree(textureRetained.getAnisotropicFilterDegree());
        textureRetained2.initSharpenTextureFunc(textureRetained.getSharpenTextureFunc());
        textureRetained2.initFilter4Func(textureRetained.getFilter4Func());
        textureRetained2.initBaseLevel(textureRetained.getBaseLevel());
        textureRetained2.initMaximumLevel(textureRetained.getMaximumLevel());
        textureRetained2.initMinimumLOD(textureRetained.getMinimumLOD());
        textureRetained2.initMaximumLOD(textureRetained.getMaximumLOD());
        Point3f point3f = new Point3f();
        textureRetained.getLodOffset((Tuple3f)point3f);
        textureRetained2.initLodOffset(point3f.x, point3f.y, point3f.z);
        Color4f color4f = new Color4f();
        textureRetained.getBoundaryColor(color4f);
        textureRetained2.initBoundaryColor(color4f);
        for (int i = textureRetained.maxLevels - 1; i >= 0; --i) {
            ImageComponent imageComponent = (ImageComponent)this.getNodeComponent(textureRetained.getImage(i), bl, hashtable);
            if (imageComponent == null) continue;
            textureRetained2.initImage(i, imageComponent);
        }
    }

    boolean duplicateChild() {
        if (this.getDuplicateOnCloneTree()) {
            return true;
        }
        int n = ((TextureRetained)this.retained).maxLevels;
        TextureRetained textureRetained = (TextureRetained)this.retained;
        for (int i = 0; i < n; ++i) {
            ImageComponent imageComponent = textureRetained.getImage(i);
            if (imageComponent == null || !imageComponent.getDuplicateOnCloneTree()) continue;
            return true;
        }
        return false;
    }
}

