/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor;

import abbot.Log;
import abbot.Version;
import abbot.editor.ComponentBrowser;
import abbot.editor.CustomCheckBoxMenuItem;
import abbot.editor.EditorConstants;
import abbot.editor.LogoLabel;
import abbot.editor.LookAndFeelPreserver;
import abbot.editor.Preferences;
import abbot.editor.ScriptTable;
import abbot.editor.actions.EditorAction;
import abbot.editor.actions.EditorToggleAction;
import abbot.editor.widgets.Mnemonic;
import abbot.editor.widgets.TextField;
import abbot.editor.widgets.TextFormat;
import abbot.i18n.Strings;
import abbot.util.AWT;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

public class ScriptEditorFrame
extends JFrame
implements EditorConstants,
Version {
    private static int STEP_EDITOR_MIN_HEIGHT = 75;
    private JLabel currentTestSuiteLabel;
    private JTextField testScriptDescription;
    private JButton testSuiteSelectionButton;
    private JButton runButton;
    private JComboBox testScriptSelector;
    private JSplitPane scriptSplit;
    private JSplitPane scriptBrowserSplit;
    private ScriptTable scriptTable;
    private JTextArea statusBar;
    private JDialog statusWindow;
    private boolean statusShown;
    private JTextArea statusText;
    private ComponentBrowser componentBrowser;
    private ActionMap actionMap;
    private Preferences prefs;
    private ImageIcon logo;
    private JMenu insertMenu;
    private int INSERT_BASE_COUNT;
    private JMenu captureMenu;
    private JMenu actionMenu;
    private TwoStateEditorMenu assertMenu;
    private TwoStateEditorMenu waitMenu;
    private JDialog aboutBox;
    private JPanel lastEditor;
    private LookAndFeelPreserver preserver;
    boolean firstShow = true;

    public ScriptEditorFrame(String[][] menus, ActionMap actionMap, ActionListener listener, String title, ScriptTable scriptTable, Preferences preferences) {
        super(title);
        this.setName("ScriptEditor");
        this.prefs = preferences;
        this.scriptTable = scriptTable;
        this.actionMap = actionMap;
        URL url = this.getClass().getResource("icons/abbot.gif");
        this.logo = new ImageIcon(url);
        this.setIconImage(this.logo.getImage());
        this.setDefaultCloseOperation(0);
        this.initComponents(listener);
        this.setJMenuBar(this.createMenus(menus));
        this.preserver = new LookAndFeelPreserver(this);
    }

    private JMenuBar createMenus(String[][] menus) {
        JMenuBar menuBar = new JMenuBar();
        for (int i = 0; i < menus.length; ++i) {
            String[] keys = menus[i];
            if (keys.length <= 0) continue;
            EditorMenu menu = new EditorMenu(keys[0]);
            for (int j = 1; j < keys.length; ++j) {
                String key = keys[j];
                if (key == null) {
                    menu.add(new JSeparator());
                    continue;
                }
                Action action = this.actionMap.get(key);
                menu.add(this.createMenuItem(action));
            }
            if (i == menus.length - 1) {
                menuBar.add(Box.createHorizontalGlue());
            }
            menuBar.add(menu);
        }
        return menuBar;
    }

    public ComponentBrowser getComponentBrowser() {
        return this.componentBrowser;
    }

    public void setComponentBrowser(ComponentBrowser componentBrowser) {
        this.componentBrowser = componentBrowser;
        this.scriptBrowserSplit.setBottomComponent(componentBrowser);
    }

    public ScriptTable getScriptTable() {
        return this.scriptTable;
    }

    public String getStatus() {
        return this.statusBar.getText();
    }

    private void setInitialBounds() {
        Log.debug("bounds=" + this.getBounds());
        Dimension size = new Dimension(this.prefs.getIntegerProperty("width", this.getWidth()), this.prefs.getIntegerProperty("height", this.getHeight()));
        if (size.width < 200 || size.height < 200) {
            Log.warn("Size is rather small: " + size + ", using defaults");
        } else {
            this.setSize(size);
        }
        Rectangle screen = this.getGraphicsConfiguration().getBounds();
        int x = screen.x + (screen.width - this.getWidth()) / 2;
        int y = screen.y + (screen.height - this.getHeight()) / 2;
        Point where = new Point(this.prefs.getIntegerProperty("x", x), this.prefs.getIntegerProperty("y", y));
        this.setLocation(where);
        int split1 = this.prefs.getIntegerProperty("split.script.stepeditor", -1);
        if (split1 < 10 || split1 > this.getHeight() - 10) {
            split1 = -1;
        }
        this.scriptSplit.setDividerLocation(split1);
        int split2 = this.prefs.getIntegerProperty("split.script.browser", -1);
        if (split2 < 10 || split2 > this.getWidth() - 10) {
            split2 = -1;
        }
        this.scriptBrowserSplit.setDividerLocation(split2);
        Log.debug("post=" + this.getBounds() + " split1=" + split1 + " split2=" + split2);
    }

    public void show() {
        if (this.firstShow) {
            this.firstShow = false;
            this.setInitialBounds();
        }
        super.show();
    }

    public void hide() {
        if (this.isShowing()) {
            this.prefs.setProperty("x", String.valueOf(this.getX()));
            this.prefs.setProperty("y", String.valueOf(this.getY()));
            this.prefs.setProperty("width", String.valueOf(this.getWidth()));
            this.prefs.setProperty("height", String.valueOf(this.getHeight()));
            this.prefs.setProperty("split.script.stepeditor", String.valueOf(this.scriptSplit.getDividerLocation()));
            this.prefs.setProperty("split.script.browser", String.valueOf(this.scriptBrowserSplit.getDividerLocation()));
            this.prefs.save();
        }
        super.hide();
    }

    public void setStatus(String msg, String extended, final Color color) {
        this.statusBar.setText(msg);
        this.statusText.setText(msg + (extended != null ? "\n" + extended : ""));
        Runnable action = new Runnable(){

            public void run() {
                ScriptEditorFrame.this.statusBar.setForeground(color);
                ScriptEditorFrame.this.statusText.setForeground(color);
                if (ScriptEditorFrame.this.statusWindow.isShowing()) {
                    ScriptEditorFrame.this.resizeStatusWindow();
                }
            }
        };
        if (!color.equals(this.statusBar.getForeground())) {
            AWT.invokeAction(action);
        }
    }

    public Dimension getPreferredSize() {
        Dimension pref = super.getPreferredSize();
        Rectangle screen = this.getGraphicsConfiguration().getBounds();
        pref.width = Math.min(pref.width, screen.width);
        pref.height = Math.min(pref.height, screen.height);
        return pref;
    }

    public JLabel getCurrentTestSuiteLabel() {
        return this.currentTestSuiteLabel;
    }

    public JComboBox getTestScriptSelector() {
        return this.testScriptSelector;
    }

    public JTextField getTestScriptDescription() {
        return this.testScriptDescription;
    }

    private void initComponents(ActionListener al) {
        JPanel pane = (JPanel)this.getContentPane();
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 0));
        top.setBorder(new EmptyBorder(4, 4, 4, 4));
        JLabel suiteLabel = new JLabel(ScriptEditorFrame.getString("AbbotSuite")){

            public Dimension getMaximumSize() {
                return super.getPreferredSize();
            }
        };
        suiteLabel.setHorizontalAlignment(4);
        this.currentTestSuiteLabel = new JLabel(ScriptEditorFrame.getString("NoSuite"));
        this.currentTestSuiteLabel.setHorizontalAlignment(2);
        top.add(suiteLabel);
        top.add(Box.createHorizontalStrut(8));
        top.add(this.currentTestSuiteLabel);
        top.add(Box.createHorizontalGlue());
        top.add(Box.createHorizontalStrut(8));
        Action action = this.actionMap.get("select-testsuite");
        if (action != null) {
            this.testSuiteSelectionButton = new EditorButton(action);
            top.add(this.testSuiteSelectionButton);
            top.add(Box.createHorizontalStrut(8));
        }
        if ((action = this.actionMap.get("run")) != null) {
            this.runButton = new EditorButton(action);
            top.add(this.runButton);
        }
        JPanel center = new JPanel(new BorderLayout());
        this.testScriptSelector = new JComboBox();
        JPanel scriptPane = new JPanel(new BorderLayout());
        this.testScriptDescription = new TextField("");
        this.testScriptDescription.addActionListener(al);
        String tip = TextFormat.tooltip(Strings.get("editor.script_description.tip"));
        this.testScriptDescription.setToolTipText(tip);
        JScrollPane scroll = new JScrollPane(this.scriptTable){

            public Dimension getPreferredSize() {
                return new Dimension(250, 200);
            }

            public Dimension getMinimumSize() {
                return new Dimension(250, super.getMinimumSize().height);
            }
        };
        scroll.setBorder(null);
        scroll.getViewport().setBackground(this.scriptTable.getBackground());
        this.scriptSplit = new JSplitPane(1);
        this.scriptSplit.setResizeWeight(1.0);
        this.scriptSplit.setDividerSize(4);
        this.scriptSplit.setBorder(null);
        this.scriptSplit.setLeftComponent(scroll);
        this.scriptBrowserSplit = new JSplitPane(0);
        this.scriptBrowserSplit.setResizeWeight(1.0);
        this.scriptBrowserSplit.setDividerSize(4);
        this.scriptBrowserSplit.setBorder(null);
        this.scriptBrowserSplit.setTopComponent(this.scriptSplit);
        scriptPane.add((Component)this.testScriptDescription, "North");
        scriptPane.add((Component)this.scriptBrowserSplit, "Center");
        center.add((Component)this.testScriptSelector, "North");
        center.add((Component)scriptPane, "Center");
        this.statusText = new JTextArea("");
        this.statusText.setEditable(false);
        this.statusText.setBackground(this.getContentPane().getBackground());
        this.statusText.setColumns(80);
        this.statusText.setLineWrap(true);
        this.statusText.setWrapStyleWord(true);
        this.statusWindow = this.createStatusWindow();
        JPanel wp = (JPanel)this.statusWindow.getContentPane();
        wp.add(new JScrollPane(this.statusText));
        this.statusBar = new JTextArea(ScriptEditorFrame.getString("Initializing"));
        this.statusBar.setEditable(false);
        this.statusBar.setBackground(this.getContentPane().getBackground());
        this.statusBar.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                boolean hasMoreText = !ScriptEditorFrame.this.statusBar.getText().equals(ScriptEditorFrame.this.statusText.getText());
                boolean hasWideText = ((ScriptEditorFrame)ScriptEditorFrame.this).statusBar.getPreferredSize().width > ((ScriptEditorFrame)ScriptEditorFrame.this).statusBar.getSize().width;
                Log.debug("has more=" + hasMoreText + ", hasWide=" + hasWideText);
                if (hasMoreText || hasWideText) {
                    ScriptEditorFrame.this.resizeStatusWindow();
                    ScriptEditorFrame.this.statusWindow.setVisible(true);
                    ScriptEditorFrame.this.resizeStatusWindow();
                }
            }
        });
        this.statusBar.setToolTipText(ScriptEditorFrame.getString("Status.tip"));
        pane.setLayout(new BorderLayout());
        pane.setBorder(new EmptyBorder(4, 4, 4, 4));
        pane.add((Component)top, "North");
        pane.add((Component)center, "Center");
        pane.add((Component)this.statusBar, "South");
        this.componentBrowser = null;
    }

    private JMenuItem createMenuItem(Action action) {
        JMenuItem item = action instanceof EditorToggleAction ? new CustomCheckBoxMenuItem((EditorToggleAction)action) : new EditorMenuItem(action);
        return item;
    }

    public void showAboutBox() {
        if (this.aboutBox == null) {
            String title = Strings.get("actions.editor-about.title");
            this.aboutBox = new JDialog(this, title, true);
            JPanel pane = (JPanel)this.aboutBox.getContentPane();
            pane.setLayout(new BorderLayout());
            pane.add((Component)new LogoLabel(), "Center");
            JLabel label = new JLabel("1.0.0rc2");
            label.setHorizontalAlignment(0);
            pane.add((Component)label, "South");
            pane.setBorder(new EmptyBorder(4, 4, 4, 4));
            this.aboutBox.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent me) {
                    ScriptEditorFrame.this.aboutBox.setVisible(false);
                }
            });
            this.aboutBox.pack();
            this.aboutBox.setResizable(false);
        }
        this.aboutBox.setLocation(this.getLocation().x + this.getWidth() / 2 - this.aboutBox.getWidth() / 2, this.getLocation().y + this.getHeight() / 2 - this.aboutBox.getHeight() * 2 / 3);
        this.aboutBox.setVisible(true);
    }

    public void setAssertOptions(boolean wait, boolean invert) {
        this.getComponentBrowser().updateAssertText(wait, invert);
        this.assertMenu.setSecondary(invert);
        this.waitMenu.setSecondary(invert);
    }

    private void populateMenu(JMenu menu, ArrayList actions) {
        for (Action action : actions) {
            if (action == null) {
                menu.add(new JSeparator());
                continue;
            }
            EditorMenuItem mi = new EditorMenuItem(action);
            menu.add(mi);
        }
    }

    public void populateInsertMenu(ArrayList actions) {
        if (this.INSERT_BASE_COUNT == 0) {
            this.INSERT_BASE_COUNT = this.insertMenu.getItemCount();
        } else {
            while (this.insertMenu.getItemCount() > this.INSERT_BASE_COUNT) {
                this.insertMenu.remove(this.INSERT_BASE_COUNT);
            }
        }
        this.insertMenu.add(new JSeparator());
        this.actionMenu = new EditorMenu("menus.insert-action");
        this.insertMenu.add(this.actionMenu);
        this.assertMenu = new TwoStateEditorMenu("menus.insert-assert", "menus.insert-assert.neg");
        this.insertMenu.add(this.assertMenu);
        this.waitMenu = new TwoStateEditorMenu("menus.insert-wait", "menus.insert-wait.neg");
        this.insertMenu.add(this.waitMenu);
        Collections.sort(actions);
        this.populateMenu(this.actionMenu, actions);
    }

    public void populateAssertMenu(ArrayList actions) {
        this.assertMenu.removeAll();
        this.populateMenu(this.assertMenu, actions);
    }

    public void populateWaitMenu(ArrayList actions) {
        this.waitMenu.removeAll();
        this.populateMenu(this.waitMenu, actions);
    }

    public void populateCaptureMenu(ArrayList actions) {
        this.captureMenu.removeAll();
        this.populateMenu(this.captureMenu, actions);
    }

    public JPanel getEditor() {
        return this.lastEditor;
    }

    public void setEditor(JPanel editor) {
        if (editor != null) {
            JScrollPane scroll = new JScrollPane(editor);
            int loc = this.scriptSplit.getDividerLocation();
            scroll.getViewport().setBackground(editor.getBackground());
            Dimension minSize = editor.getMinimumSize();
            minSize.height = STEP_EDITOR_MIN_HEIGHT;
            scroll.getViewport().setMinimumSize(minSize);
            this.scriptSplit.setRightComponent(scroll);
            if (this.lastEditor != null) {
                this.scriptSplit.setDividerLocation(loc);
            }
        } else {
            this.scriptSplit.setRightComponent(null);
        }
        this.lastEditor = editor;
    }

    private static String getString(String key) {
        String value = Strings.get(key);
        if (value == null) {
            value = key;
        }
        return value;
    }

    private void resizeStatusWindow() {
        this.statusWindow.setResizable(true);
        this.statusWindow.pack();
        if (!this.statusShown) {
            Dimension size = this.statusWindow.getSize();
            Point vwhere = this.getLocationOnScreen();
            if (size.width < this.getWidth()) {
                size.width = this.getWidth();
                this.statusWindow.setSize(size);
            }
            Point where = new Point();
            where.x = vwhere.x + 10;
            where.y = vwhere.y + this.getHeight() - size.height;
            if (where.y < vwhere.y + 10) {
                where.y = vwhere.y + 10;
            }
            this.statusWindow.setLocation(where);
            this.statusShown = true;
        }
        this.statusWindow.setResizable(false);
        this.statusWindow.repaint();
    }

    private JDialog createStatusWindow() {
        JDialog dialog = new JDialog(this, Strings.get("Status.title"), false){

            public Dimension getMaximumSize() {
                Dimension max = super.getMaximumSize();
                Rectangle screen = this.getGraphicsConfiguration().getBounds();
                max.height = Math.min(Math.min(max.height, screen.height * 3 / 4), ScriptEditorFrame.this.getMaximumSize().height);
                max.width = Math.min(Math.min(max.width, screen.width * 3 / 4), ScriptEditorFrame.this.getMaximumSize().width);
                Log.debug("maximum size is " + max);
                return max;
            }

            public Dimension getMinimumSize() {
                Dimension min = super.getMinimumSize();
                min.height = Math.max(150, min.height);
                Log.debug("minimum size is " + min);
                return min;
            }

            public Dimension getPreferredSize() {
                Dimension pref = super.getPreferredSize();
                pref.width = Math.min(pref.width, ScriptEditorFrame.this.getPreferredSize().width);
                Log.debug("preferred size is " + pref);
                return pref;
            }
        };
        return dialog;
    }

    public int showConfirmation(String msg) {
        return this.showConfirmation(msg, 0);
    }

    public int showConfirmation(String msg, int opts) {
        msg = TextFormat.dialog(msg);
        return JOptionPane.showConfirmDialog(this, msg, Strings.get("Confirm"), opts);
    }

    public String showInputDialog(String title, String msg, String initial) {
        msg = TextFormat.dialog(msg);
        return (String)JOptionPane.showInputDialog(this, msg, title, -1, null, null, initial);
    }

    public void showMessage(String title, String msg) {
        msg = TextFormat.dialog(msg);
        JOptionPane.showMessageDialog(this, msg);
    }

    public void showWarning(String msg) {
        this.showWarning(Strings.get("Warning.title"), msg);
    }

    public void showWarning(String title, String msg) {
        msg = TextFormat.dialog(msg);
        JOptionPane.showMessageDialog(this, msg, title, 2);
    }

    public void showError(String msg) {
        this.showError(Strings.get("Error.title"), msg);
    }

    public void showError(String title, String msg) {
        msg = TextFormat.dialog(msg);
        JOptionPane.showMessageDialog(this, msg, title, 0);
    }

    private class EditorMenuItem
    extends JMenuItem {
        public EditorMenuItem(Action action) {
            super(action);
            this.setName((String)action.getValue("Name"));
            Integer i = (Integer)action.getValue("mnemonic-index");
            if (i != null) {
                Mnemonic.setDisplayedMnemonicIndex(this, i);
            }
            this.setAccelerator((KeyStroke)action.getValue("AcceleratorKey"));
        }
    }

    private class EditorButton
    extends JButton {
        public EditorButton(Action action) {
            super(action);
            this.setName((String)action.getValue("Name"));
            Integer i = (Integer)action.getValue("mnemonic-index");
            if (i != null) {
                Mnemonic.setDisplayedMnemonicIndex(this, i);
            }
        }
    }

    private class TwoStateEditorMenu
    extends EditorMenu {
        private String primary;
        private String secondary;

        public TwoStateEditorMenu(String primary, String secondary) {
            super(primary);
            this.primary = primary;
            this.secondary = secondary;
        }

        public void setSecondary(boolean state) {
            this.setMnemonic(state ? this.secondary : this.primary);
        }
    }

    private class EditorMenu
    extends JMenu {
        public EditorMenu(String key) {
            super(ScriptEditorFrame.getString(key));
            this.setName(key);
            if (key.equals("menus.insert")) {
                ScriptEditorFrame.this.insertMenu = this;
            } else if (key.equals("menus.capture")) {
                ScriptEditorFrame.this.captureMenu = this;
            }
            this.setMnemonic(key);
        }

        protected void setMnemonic(String key) {
            int code;
            Mnemonic mnemonic = Mnemonic.getMnemonic(Strings.get(key));
            mnemonic.setMnemonic(this);
            if (mnemonic.keycode == 0 && (code = EditorAction.getMnemonic(key)) != 0) {
                this.setMnemonic(code);
            }
        }
    }
}

