/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.editors;

import abbot.editor.editors.StepEditor;
import abbot.editor.widgets.ArrayEditor;
import abbot.i18n.Strings;
import abbot.script.Appletviewer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AppletviewerEditor
extends StepEditor {
    public static final String HELP_DESC = Strings.get("editor.applet.desc");
    private Appletviewer applet;
    private JTextField code;
    private ArrayEditor params;
    private JTextField codebase;
    private JTextField archive;
    private JTextField width;
    private JTextField height;

    public AppletviewerEditor(Appletviewer applet) {
        super(applet);
        Component c;
        this.applet = applet;
        this.code = this.addTextField(Strings.get("editor.applet.code"), applet.getCode());
        this.width = this.addTextField(Strings.get("editor.applet.width"), applet.getWidth());
        this.height = this.addTextField(Strings.get("editor.applet.height"), applet.getHeight());
        ArrayList<Component> list = new ArrayList<Component>();
        while ((c = this.getComponent(this.getComponentCount() - 1)) != this.code) {
            this.remove(c);
            list.add(c);
        }
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        for (int i = list.size() - 1; i >= 0; --i) {
            p.add((Component)list.get(i));
            if (i == 0) continue;
            p.add(Box.createHorizontalStrut(4));
        }
        this.add(p);
        this.params = this.addArrayEditor(Strings.get("editor.applet.params"), applet.getParamsAsArray());
        this.codebase = this.addTextField(Strings.get("editor.applet.codebase"), applet.getCodebase());
        this.archive = this.addTextField(Strings.get("editor.applet.archive"), applet.getArchive());
    }

    public void actionPerformed(ActionEvent ev) {
        Object src = ev.getSource();
        if (src == this.code) {
            this.applet.setCode(this.code.getText());
            this.fireStepChanged();
        } else if (src == this.params) {
            Object[] values = this.params.getValues();
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < values.length; ++i) {
                String v = (String)values[i];
                int eq = v.indexOf("=");
                if (eq == -1) continue;
                String key = v.substring(0, eq);
                String value = v.substring(eq + 1);
                map.put(key, value);
            }
            this.applet.setParams(map);
            this.fireStepChanged();
        } else if (src == this.codebase) {
            String value = this.codebase.getText();
            if ("".equals(value)) {
                value = null;
            }
            this.applet.setCodebase(value);
            this.fireStepChanged();
        } else if (src == this.archive) {
            String value = this.archive.getText();
            if ("".equals(value)) {
                value = null;
            }
            this.applet.setArchive(value);
            this.fireStepChanged();
        } else if (src == this.width) {
            String value = this.width.getText();
            if ("".equals(value)) {
                value = null;
            }
            try {
                Integer.parseInt(value);
                this.applet.setWidth(value);
                this.width.setForeground(DEFAULT_FOREGROUND);
                this.fireStepChanged();
            }
            catch (NumberFormatException e) {
                this.width.setForeground(ERROR_FOREGROUND);
            }
        } else if (src == this.height) {
            String value = this.height.getText();
            if ("".equals(value)) {
                value = null;
            }
            try {
                Integer.parseInt(value);
                this.applet.setHeight(value);
                this.width.setForeground(DEFAULT_FOREGROUND);
                this.fireStepChanged();
            }
            catch (NumberFormatException e) {
                this.width.setForeground(ERROR_FOREGROUND);
            }
        } else {
            super.actionPerformed(ev);
        }
        if (HELP_DESC.equals(this.applet.getDescription())) {
            this.applet.setDescription(null);
            this.fireStepChanged();
        }
    }
}

