/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.recorder;

import abbot.BugReport;
import abbot.Log;
import abbot.Platform;
import abbot.editor.recorder.AbstractInternalFrameWatcher;
import abbot.editor.recorder.Recorder;
import abbot.editor.recorder.RecordingFailedException;
import abbot.editor.recorder.SemanticEvents;
import abbot.editor.recorder.SemanticRecorder;
import abbot.i18n.Strings;
import abbot.script.Action;
import abbot.script.Assert;
import abbot.script.Event;
import abbot.script.Resolver;
import abbot.script.Sequence;
import abbot.script.Step;
import abbot.tester.Robot;
import abbot.util.AWT;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;

public class EventRecorder
extends Recorder
implements SemanticEvents {
    private static final String ANY_KEY = null;
    private static final int EITHER = 0;
    private static final int PRESS = 1;
    private static final int RELEASE = 2;
    private boolean captureMotion;
    private long lastStepTime;
    ArrayList steps = new ArrayList();
    private static final Class[] recorderClasses = new Class[]{AbstractButton.class, Component.class, Container.class, Dialog.class, Frame.class, JComboBox.class, JComponent.class, JInternalFrame.class, JList.class, JMenuItem.class, JTabbedPane.class, JTable.class, JTree.class, Window.class};
    private boolean pruneButtonModifier = false;
    private int lastButton = 0;
    private SemanticRecorder semanticRecorder = null;
    public static final long RECORDING_EVENT_MASK = 2813L;
    private HashMap semanticRecorders = new HashMap();

    public EventRecorder(Resolver resolver, boolean captureMotion) {
        super(resolver);
        this.captureMotion = captureMotion;
        for (int i = 0; i < recorderClasses.length; ++i) {
            this.getSemanticRecorder(recorderClasses[i]);
        }
    }

    public String toString() {
        return this.captureMotion ? Strings.get("actions.capture-all") : Strings.get("actions.capture");
    }

    public void start() {
        super.start();
        this.steps.clear();
        MessageFormat mf = new MessageFormat(Strings.get("RecordingX"));
        this.setStatus(mf.format(new Object[]{this.toString()}));
        this.lastStepTime = this.getLastEventTime();
    }

    private boolean isKey(Step step, String code, int type) {
        boolean match = false;
        if (step instanceof Event) {
            Event se = (Event)step;
            match = "KeyEvent".equals(se.getType()) && (type == 0 || type == 1 && "KEY_PRESSED".equals(se.getKind()) || type == 2 && "KEY_RELEASED".equals(se.getKind())) && (code == ANY_KEY || code.equals(se.getAttribute("keyCode")));
        }
        return match;
    }

    private boolean isKeyString(Step step) {
        return step instanceof Action && ((Action)step).getMethodName().equals("actionKeyString");
    }

    private boolean isKeyStroke(Step step, String keycode) {
        Action action;
        if (step instanceof Action && (action = (Action)step).getMethodName().equals("actionKeyStroke")) {
            String[] args = action.getArguments();
            return keycode == ANY_KEY || args.length > 1 && args[1].equals(keycode) || keycode.startsWith("VK_NUMPAD") && args[1].equals("VK_" + keycode.substring(9));
        }
        return false;
    }

    private void removeTerminalShift() {
        if (this.steps.size() > 0) {
            Step step = (Step)this.steps.get(this.steps.size() - 1);
            while (this.isKey(step, "VK_SHIFT", 1)) {
                this.steps.remove(step);
                if (this.steps.size() == 0) break;
                step = (Step)this.steps.get(this.steps.size() - 1);
            }
        }
    }

    private void removeExtraModifiers() {
        this.setStatus("Removing extra modifiers");
        for (int i = 0; i < this.steps.size(); ++i) {
            Step step = (Step)this.steps.get(i);
            if (!this.isKey(step, ANY_KEY, 1)) continue;
            Event se = (Event)step;
            String cs = se.getAttribute("keyCode");
            int code = AWT.getKeyCode(cs);
            boolean remove = false;
            boolean foundKeyStroke = false;
            if (AWT.isModifier(code)) {
                for (int j = i + 1; j < this.steps.size(); ++j) {
                    Step next = (Step)this.steps.get(j);
                    if (this.isKey(next, cs, 2)) {
                        if (!foundKeyStroke) break;
                        this.steps.remove(j);
                        remove = true;
                        break;
                    }
                    if (this.isKeyStroke(next, ANY_KEY) || this.isKeyString(next)) {
                        foundKeyStroke = true;
                        remove = true;
                        continue;
                    }
                    if (!this.isKey(next, ANY_KEY, 0)) break;
                }
            }
            if (!remove) continue;
            this.steps.remove(i--);
        }
    }

    private void coalesceKeyStrings() {
        this.setStatus("Coalescing key strings");
        block0: for (int i = 0; i < this.steps.size(); ++i) {
            Step step = (Step)this.steps.get(i);
            if (!this.isKeyString(step)) continue;
            int j = i;
            while (++j < this.steps.size()) {
                Step next = (Step)this.steps.get(j);
                if (this.isKeyString(next)) {
                    Action action = (Action)step;
                    String[] args1 = action.getArguments();
                    String[] args2 = ((Action)next).getArguments();
                    action.setArguments(new String[]{args1[0], args1[1] + args2[1]});
                    this.setStatus("Joining '" + args1[1] + "' and '" + args2[1] + "'");
                    this.steps.remove(j--);
                    continue;
                }
                this.setStatus("Next step is not a key string: " + next);
                continue block0;
            }
        }
    }

    private void coalesceKeyEvents() {
        this.setStatus("Coalescing key events");
        for (int i = 0; i < this.steps.size(); ++i) {
            boolean isOSXOption;
            Step step = (Step)this.steps.get(i);
            if (!this.isKey(step, ANY_KEY, 1)) continue;
            Event se = (Event)step;
            String cs = se.getAttribute("keyCode");
            int code = AWT.getKeyCode(cs);
            boolean bl = isOSXOption = Platform.isOSX() && code == 18;
            if (AWT.isModifier(code) && !isOSXOption) continue;
            boolean foundKeyStroke = false;
            boolean foundRelease = false;
            for (int j = i + 1; j < this.steps.size(); ++j) {
                Step next = (Step)this.steps.get(j);
                if (this.isKey(next, cs, 2)) {
                    foundRelease = true;
                    String target = ((Event)next).getComponentID();
                    this.steps.remove(j);
                    this.steps.remove(i);
                    if (!foundKeyStroke && !isOSXOption) {
                        String[] stringArray;
                        String mods = se.getAttribute("modifiers");
                        if (mods == null || "0".equals(mods)) {
                            String[] stringArray2 = new String[2];
                            stringArray2[0] = target;
                            stringArray = stringArray2;
                            stringArray2[1] = cs;
                        } else {
                            String[] stringArray3 = new String[3];
                            stringArray3[0] = target;
                            stringArray3[1] = cs;
                            stringArray = stringArray3;
                            stringArray3[2] = mods;
                        }
                        String[] args = stringArray;
                        Action typed = new Action(this.getResolver(), null, "actionKeyStroke", args);
                        this.steps.add(i, typed);
                        this.setStatus("Insert artifical " + typed);
                        break;
                    }
                    this.setStatus("Removed redundant key events (" + cs + ")");
                    --i;
                    break;
                }
                if (!this.isKeyStroke(next, ANY_KEY) && !this.isKeyString(next)) continue;
                foundKeyStroke = true;
                if (!cs.startsWith("VK_NUMPAD")) continue;
                foundKeyStroke = false;
                this.steps.remove(j--);
            }
            if (foundRelease) continue;
            this.setStatus("Removed extraneous key press (" + cs + ")");
            this.steps.remove(i--);
        }
    }

    private boolean pruneClickModifiers(AWTEvent event) {
        this.lastButton = 0;
        boolean ignoreEvent = false;
        if (event.getID() == 501) {
            MouseEvent me = (MouseEvent)event;
            int buttons = me.getModifiers() & 0xC;
            this.pruneButtonModifier = buttons != 0;
            this.lastButton = buttons;
        } else if (event.getID() == 402 && this.pruneButtonModifier) {
            this.pruneButtonModifier = false;
            KeyEvent ke = (KeyEvent)event;
            int code = ke.getKeyCode();
            if ((code == 17 || code == 18 && (this.lastButton & 8) != 0 || code == 157 && (this.lastButton & 4) != 0) && this.steps.size() > 1) {
                Step step = (Step)this.steps.get(this.steps.size() - 2);
                if (code == 17 && this.isKey(step, "VK_CONTROL", 1) || code == 18 && this.isKey(step, "VK_ALT", 1) || code == 157 && this.isKey(step, "VK_META", 1)) {
                    this.steps.remove(this.steps.size() - 2);
                    this.pruneButtonModifier = true;
                    ignoreEvent = true;
                }
            }
        }
        return ignoreEvent;
    }

    private void removeTrailingKeyPresses() {
        while (this.steps.size() > 0 && this.isKey((Step)this.steps.get(this.steps.size() - 1), ANY_KEY, 1)) {
            this.steps.remove(this.steps.size() - 1);
        }
    }

    private void removeShortcutModifierKeyPresses() {
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        String modifier = AWT.getKeyCode(AWT.maskToKeyCode(mask));
        block0: for (int current = 0; current < this.steps.size(); ++current) {
            Step step = (Step)this.steps.get(current);
            if (!this.isKey(step, modifier, 1)) continue;
            Log.debug("Found possible extraneous modifier");
            int keyDown = current;
            Action action = null;
            while (++current < this.steps.size()) {
                step = (Step)this.steps.get(current);
                if (step instanceof Action) {
                    if (!"actionActionMap".equals(((Action)step).getMethodName())) continue block0;
                    action = (Action)step;
                    continue;
                }
                if (!this.isKey(step, modifier, 2) || action == null) continue block0;
                Log.debug("Removing extraneous shortcut modifier");
                this.steps.remove(current);
                this.steps.remove(keyDown);
                current = keyDown - 1;
                continue block0;
            }
        }
    }

    public void insertStep(Step step) {
        this.steps.add(step);
        if (step instanceof Assert && ((Assert)step).getMethodName().equals("assertFrameShowing")) {
            long timeout = ((Assert)step).getTimeout();
            long delta = System.currentTimeMillis() - this.lastStepTime;
            if (delta > timeout) {
                timeout += delta;
            }
            ((Assert)step).setTimeout(timeout);
        }
        this.lastStepTime = this.getLastEventTime();
    }

    protected Step createStep() {
        this.removeTerminalShift();
        this.coalesceKeyEvents();
        this.removeExtraModifiers();
        this.coalesceKeyStrings();
        this.removeShortcutModifierKeyPresses();
        this.removeTrailingKeyPresses();
        return new Sequence(this.getResolver(), null, this.steps);
    }

    private boolean saveSemanticEvent() throws RecordingFailedException {
        Log.log("Storing event from current semantic recorder");
        try {
            Step step = this.semanticRecorder.getStep();
            if (step != null) {
                this.insertStep(step);
                this.setStatus("Added " + step);
            } else {
                this.setStatus("No semantic event found, events skipped");
            }
            this.semanticRecorder = null;
            return step != null;
        }
        catch (BugReport bug) {
            throw new RecordingFailedException(bug);
        }
        catch (Exception e) {
            Log.log("Recording failed when saving action: " + e);
            String msg = Strings.get("editor.recording.exception");
            throw new RecordingFailedException(new BugReport(msg, e));
        }
    }

    public void terminate() throws RecordingFailedException {
        Log.log("EventRecorder terminated");
        if (this.semanticRecorder != null) {
            this.saveSemanticEvent();
        }
    }

    protected void recordEvent(AWTEvent event) throws RecordingFailedException {
        if (this.steps.size() == 0 && event.getID() == 402) {
            Log.log("Ignoring initial release event");
            return;
        }
        SemanticRecorder newRecorder = null;
        if (Platform.isMacintosh() && this.semanticRecorder == null && this.pruneClickModifiers(event)) {
            return;
        }
        if (this.semanticRecorder == null) {
            SemanticRecorder sr;
            SemanticRecorder semanticRecorder = sr = event.getSource() instanceof Component ? this.getSemanticRecorder((Component)event.getSource()) : this.getSemanticRecorder(Component.class);
            if (sr.accept(event)) {
                this.semanticRecorder = newRecorder = sr;
                this.setStatus("Recording semantic event with " + sr);
                if (event.getSource() instanceof JInternalFrame) {
                    JInternalFrame f = (JInternalFrame)event.getSource();
                    new InternalFrameWatcher(f);
                }
            }
        }
        if (this.semanticRecorder != null) {
            boolean consumed = this.semanticRecorder.record(event);
            boolean finished = this.semanticRecorder.isFinished();
            if (finished) {
                Log.debug("Semantic recorder is finished");
                this.saveSemanticEvent();
            }
            if (!consumed && newRecorder == null) {
                Log.debug("Event was not consumed, parse it again");
                this.recordEvent(event);
            }
        } else {
            this.captureRawEvent(event);
        }
    }

    private void captureRawEvent(AWTEvent event) {
        int id = event.getID();
        boolean capture = false;
        switch (id) {
            case 501: 
            case 502: {
                capture = true;
                break;
            }
            case 401: 
            case 402: {
                KeyEvent e = (KeyEvent)event;
                boolean bl = capture = e.getKeyCode() != 0;
                if (capture) break;
                Log.warn("VM bug: no valid keycode on key " + (id == 401 ? "press" : "release"));
                break;
            }
            case 503: 
            case 504: 
            case 505: 
            case 506: {
                capture = this.captureMotion;
                break;
            }
        }
        if (capture) {
            Event step = new Event(this.getResolver(), null, event);
            this.insertStep(step);
            this.setStatus("Added event " + step);
        }
    }

    public long getEventMask() {
        return 2813L;
    }

    private SemanticRecorder getSemanticRecorder(Component comp) {
        if (comp instanceof JButton && comp.getParent() instanceof JComboBox) {
            comp = comp.getParent();
        } else if (AWT.isInternalFrameDecoration(comp)) {
            while (!(comp instanceof JInternalFrame)) {
                comp = comp.getParent();
            }
        }
        return this.getSemanticRecorder(comp.getClass());
    }

    private SemanticRecorder getSemanticRecorder(Class cls) {
        if (!Component.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("Class must derive from Component");
        }
        SemanticRecorder sr = (SemanticRecorder)this.semanticRecorders.get(cls);
        if (sr == null) {
            Class ccls = Robot.getCanonicalClass(cls);
            if (ccls != cls) {
                sr = this.getSemanticRecorder(ccls);
                this.semanticRecorders.put(cls, sr);
                return sr;
            }
            String cname = Robot.simpleClassName(cls);
            try {
                cname = "abbot.editor.recorder." + cname + "Recorder";
                Class<?> recorderClass = Class.forName(cname);
                Constructor<?> ctor = recorderClass.getConstructor(Resolver.class);
                sr = (SemanticRecorder)ctor.newInstance(this.getResolver());
                sr.addActionListener(this.getListener());
            }
            catch (InvocationTargetException e) {
                Log.warn(e);
            }
            catch (NoSuchMethodException e) {
                sr = this.getSemanticRecorder(cls.getSuperclass());
            }
            catch (InstantiationException e) {
                sr = this.getSemanticRecorder(cls.getSuperclass());
            }
            catch (IllegalAccessException iae) {
                sr = this.getSemanticRecorder(cls.getSuperclass());
            }
            catch (ClassNotFoundException cnf) {
                sr = this.getSemanticRecorder(cls.getSuperclass());
            }
            this.semanticRecorders.put(cls, sr);
        }
        return sr;
    }

    private class InternalFrameWatcher
    extends AbstractInternalFrameWatcher {
        public InternalFrameWatcher(JInternalFrame f) {
            super(f);
        }

        protected void dispatch(AWTEvent e) {
            EventRecorder.this.record(e);
        }
    }
}

