/*
 * Decompiled with CFR 0.152.
 */
package abbot.editor.recorder;

import abbot.editor.recorder.ContainerRecorder;
import abbot.script.Action;
import abbot.script.ComponentReference;
import abbot.script.Resolver;
import abbot.script.Step;
import abbot.tester.WindowTracker;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;

public class WindowRecorder
extends ContainerRecorder {
    private Window window;
    private Point where;
    private Dimension size;

    public WindowRecorder(Resolver resolver) {
        super(resolver);
    }

    protected void init(int recordingType) {
        super.init(recordingType);
        this.window = null;
        this.where = null;
        this.size = null;
    }

    protected boolean isWindowEvent(AWTEvent event) {
        return event.getSource() instanceof Window && ((Window)event.getSource()).isShowing() && WindowTracker.getTracker().isWindowReady((Window)event.getSource()) && (event.getID() == 100 || event.getID() == 101) || event.getID() == 201 || super.isWindowEvent(event);
    }

    protected boolean parseWindowEvent(AWTEvent event) {
        int id = event.getID();
        boolean consumed = true;
        if (id == 100) {
            this.window = (Window)event.getSource();
            this.where = this.window.getLocationOnScreen();
            this.setFinished(true);
        } else if (id == 101) {
            this.window = (Window)event.getSource();
            this.size = this.window.getSize();
            this.setFinished(true);
        } else if (id == 201) {
            this.window = (Window)event.getSource();
            this.setFinished(true);
        } else {
            consumed = super.parseWindowEvent(event);
        }
        return consumed;
    }

    protected Step createStep() {
        Step step = this.getRecordingType() == 1 && this.window != null ? (this.where != null ? this.createMove(this.window, this.where) : (this.size != null ? this.createResize(this.window, this.size) : this.createClose(this.window))) : super.createStep();
        return step;
    }

    protected Step createClose(Window window) {
        ComponentReference ref = this.getResolver().addComponent(window);
        return new Action(this.getResolver(), null, "actionClose", new String[]{ref.getID()}, Window.class);
    }

    protected Step createMove(Window window, Point where) {
        if (!WindowTracker.getTracker().isWindowReady(window)) {
            return null;
        }
        ComponentReference ref = this.getResolver().addComponent(window);
        return new Action(this.getResolver(), null, "actionMove", new String[]{ref.getID(), String.valueOf(where.x), String.valueOf(where.y)}, Window.class);
    }

    protected Step createResize(Window window, Dimension size) {
        if (!window.isShowing()) {
            return null;
        }
        ComponentReference ref = this.getResolver().addComponent(window);
        return new Action(this.getResolver(), null, "actionResize", new String[]{ref.getID(), String.valueOf(size.width), String.valueOf(size.height)}, Window.class);
    }
}

