/*
 * Decompiled with CFR 0.152.
 */
package abbot.script;

import abbot.Log;
import abbot.i18n.Strings;
import abbot.script.ArgumentParser;
import abbot.script.InvalidScriptException;
import abbot.script.Resolver;
import abbot.script.Step;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;

public class Call
extends Step {
    private String targetClassName = null;
    private String methodName;
    private String[] args;
    private static final String USAGE = "<call class=\"...\" method=\"...\" args=\"...\" [property=\"...\"]/>";

    public Call(Resolver resolver, Map attributes) {
        super(resolver, attributes);
        String argList;
        this.methodName = (String)attributes.get("method");
        if (this.methodName == null) {
            this.usage(Strings.get("call.method_missing"));
        }
        this.targetClassName = (String)attributes.get("class");
        if (this.targetClassName == null) {
            this.usage(Strings.get("call.class_missing"));
        }
        if ((argList = (String)attributes.get("args")) == null) {
            argList = "";
        }
        this.args = ArgumentParser.parseArgumentList(argList);
    }

    public Call(Resolver resolver, String description, String className, String methodName, String[] args) {
        super(resolver, description);
        this.targetClassName = className;
        this.methodName = methodName;
        this.args = args != null ? args : new String[]{};
    }

    public String getDefaultDescription() {
        return this.getMethodName() + this.getArgumentsDescription();
    }

    public String getUsage() {
        return USAGE;
    }

    public String getXMLTag() {
        return "call";
    }

    public String getEncodedArguments() {
        return ArgumentParser.encodeArguments(this.args);
    }

    protected String getArgumentsDescription() {
        return "(" + ArgumentParser.replace(this.getEncodedArguments(), "%2c", ",") + ")";
    }

    public void setArguments(String[] args) {
        if (args == null) {
            args = new String[]{};
        }
        this.args = args;
    }

    public void setArguments(String encodedArgs) {
        this.args = encodedArgs == null ? new String[0] : ArgumentParser.parseArgumentList(encodedArgs);
    }

    public void setMethodName(String mn) {
        if (mn == null) {
            throw new NullPointerException("Method name may not be null");
        }
        this.methodName = mn;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getTargetClassName() {
        return this.targetClassName;
    }

    public void setTargetClassName(String cn) {
        if (cn == null) {
            this.usage(Strings.get("call.class_missing"));
        }
        this.targetClassName = cn;
    }

    public Map getAttributes() {
        Map map = super.getAttributes();
        map.put("class", this.getTargetClassName());
        map.put("method", this.getMethodName());
        if (this.args.length != 0) {
            map.put("args", this.getEncodedArguments());
        }
        return map;
    }

    public String[] getArgs() {
        return this.getArguments();
    }

    public String[] getArguments() {
        return this.args;
    }

    protected void runStep() throws Throwable {
        try {
            this.invoke();
        }
        catch (Exception e) {
            Log.debug(e);
            throw e;
        }
    }

    protected Object evaluateParameter(Method m, String param, Class type) throws Exception {
        return ArgumentParser.eval(this.getResolver(), param, type);
    }

    protected Object[] evaluateParameters(Method m, String[] params) throws Exception {
        Object[] args = new Object[params.length];
        Class<?>[] types = m.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.evaluateParameter(m, params[i], types[i]);
        }
        return args;
    }

    protected Object invoke() throws Throwable {
        boolean retried = false;
        Method[] m = this.getMethods();
        for (int i = 0; i < m.length; ++i) {
            try {
                Object[] params = this.evaluateParameters(m[i], this.args);
                try {
                    Object target = this.getTarget(m[i]);
                    Log.debug("Invoking " + m[i] + " on " + target + this.getEncodedArguments() + "'");
                    if (target != null && !m[i].getDeclaringClass().isAssignableFrom(target.getClass())) {
                        if (retried) {
                            String msg = "Class loader mismatch? target " + target.getClass().getClassLoader() + " vs. method " + m[i].getDeclaringClass().getClassLoader();
                            throw new IllegalArgumentException(msg);
                        }
                    } else {
                        if ((m[i].getModifiers() & 1) == 0 || (m[i].getDeclaringClass().getModifiers() & 1) == 0) {
                            Log.debug("Bypassing compiler access restrictions on method " + m[i]);
                            m[i].setAccessible(true);
                        }
                        return m[i].invoke(this.getTarget(m[i]), params);
                    }
                    retried = true;
                    m = this.resolveMethods(m[i].getName(), target.getClass(), null);
                    i = -1;
                    continue;
                }
                catch (InvocationTargetException ite) {
                    throw ite.getTargetException();
                }
            }
            catch (IllegalArgumentException e) {
                if (i != m.length - 1) continue;
                throw e;
            }
        }
        throw new IllegalArgumentException("Can't invoke method " + m[0].getName());
    }

    public Method getMethod() throws ClassNotFoundException, NoSuchMethodException {
        return this.resolveMethod(this.getMethodName(), this.getTargetClass(), null);
    }

    protected Method[] getMethods() throws ClassNotFoundException, NoSuchMethodException {
        return this.resolveMethods(this.getMethodName(), this.getTargetClass(), null);
    }

    public Class getTargetClass() throws ClassNotFoundException {
        return this.resolveClass(this.getTargetClassName());
    }

    protected Object getTarget(Method m) throws Throwable {
        if ((m.getModifiers() & 8) == 0) {
            try {
                return this.getTargetClass().newInstance();
            }
            catch (Exception e) {
                this.setScriptError(new InvalidScriptException("Can't create an object instance of class " + this.getTargetClassName() + " for non-static method " + m.getName()));
            }
        }
        return null;
    }

    protected Method[] resolveMethods(String name, Class cls, Class returnType) throws NoSuchMethodException {
        Log.debug("Resolving methods on " + cls);
        Method[] mlist = cls.getMethods();
        ArrayList<Method> found = new ArrayList<Method>();
        for (int i = 0; i < mlist.length; ++i) {
            Method m = mlist[i];
            Class<?>[] params = m.getParameterTypes();
            if (!m.getName().equals(name) || params.length != this.args.length || returnType != null && !m.getReturnType().equals(returnType)) continue;
            found.add(m);
        }
        if (found.size() == 0) {
            throw new NoSuchMethodException(Strings.get("call.no_matching_method", new Object[]{name, returnType == null ? "*" : returnType.toString(), String.valueOf(this.args.length), cls}));
        }
        Method[] list = found.toArray(new Method[found.size()]);
        return list;
    }

    protected Method resolveMethod(String name, Class cls, Class returnType) throws NoSuchMethodException {
        Method[] methods = this.resolveMethods(name, cls, returnType);
        if (methods.length != 1) {
            return this.disambiguateMethod(methods);
        }
        return methods[0];
    }

    protected Method disambiguateMethod(Method[] methods) {
        String msg = Strings.get("call.multiple_methods", new Object[]{methods[0].getName(), methods[0].getDeclaringClass()});
        throw new IllegalArgumentException(msg);
    }
}

