/*
 * Decompiled with CFR 0.152.
 */
package abbot.script;

import abbot.script.PropertyCall;
import abbot.script.Resolver;
import java.util.Map;

public class Sample
extends PropertyCall {
    private static final String USAGE = "<sample property=... component=... method=.../>\n<sample property=... method=... [class=...]/>";
    private String propertyName = null;

    public Sample(Resolver resolver, Map attributes) {
        super(resolver, attributes);
        this.propertyName = (String)attributes.get("property");
    }

    public Sample(Resolver resolver, String description, String methodName, String id, String propName) {
        super(resolver, description, methodName, id);
        this.propertyName = propName;
    }

    public Sample(Resolver resolver, String description, String className, String methodName, String[] args, String propName) {
        super(resolver, description, className, methodName, args);
        this.propertyName = propName;
    }

    public Map getAttributes() {
        Map map = super.getAttributes();
        if (this.propertyName != null) {
            map.put("property", this.propertyName);
        }
        return map;
    }

    public String getDefaultDescription() {
        return this.getPropertyName() + "=" + super.getDefaultDescription();
    }

    public String getUsage() {
        return USAGE;
    }

    public String getXMLTag() {
        return "sample";
    }

    public void setPropertyName(String name) {
        this.propertyName = name;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    protected Object invoke() throws Throwable {
        Object obj = super.invoke();
        if (this.propertyName != null) {
            this.getResolver().setProperty(this.propertyName, obj);
        }
        return obj;
    }
}

