/*
 * Decompiled with CFR 0.152.
 */
package abbot.tester;

import abbot.Log;
import abbot.Platform;
import abbot.tester.ActionFailedException;
import abbot.tester.DialogTester;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.util.EmptyStackException;

public class FileDialogTester
extends DialogTester {
    public void actionSetFile(Component comp, final String file) {
        if (null == file || "".equals(file)) {
            throw new IllegalArgumentException("File name in FileDialog should be non-null and non-empty");
        }
        final FileDialog dialog = (FileDialog)comp;
        this.invokeAndWait(new Runnable(){

            public void run() {
                dialog.setFile(file);
            }
        });
    }

    public void actionSetDirectory(Component comp, final String dir) {
        if (null == dir || "".equals(dir)) {
            throw new IllegalArgumentException("File name in FileDialog should be non-null and non-empty");
        }
        final FileDialog dialog = (FileDialog)comp;
        this.invokeAndWait(new Runnable(){

            public void run() {
                dialog.setDirectory(dir);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionAccept(Component comp) {
        Log.debug("accept");
        final FileDialog fd = (FileDialog)comp;
        String file = fd.getFile();
        if (file == null) {
            throw new ActionFailedException("No file selected");
        }
        FileDialogQueue queue = new FileDialogQueue();
        try {
            fd.getToolkit().getSystemEventQueue().push(queue);
            if (Platform.isOSX()) {
                this.actionKeyStroke(27);
            }
            this.invokeAndWait(new Runnable(){

                public void run() {
                    fd.setVisible(false);
                }
            });
            this.waitForIdle();
            fd.setFile(file);
        }
        finally {
            queue.dispose();
        }
    }

    public void actionCancel(Component comp) {
        final FileDialog fd = (FileDialog)comp;
        if (Platform.isOSX()) {
            this.actionKeyStroke(27);
        } else {
            fd.setFile(null);
            this.invokeAndWait(new Runnable(){

                public void run() {
                    fd.setVisible(false);
                }
            });
        }
    }

    private class FileDialogQueue
    extends EventQueue {
        private boolean disposed = false;
        private boolean installed = false;

        private FileDialogQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            boolean remove = false;
            FileDialogQueue fileDialogQueue = this;
            synchronized (fileDialogQueue) {
                if (!this.disposed) {
                    this.disposed = true;
                    remove = true;
                }
            }
            if (remove) {
                try {
                    this.pop();
                }
                catch (EmptyStackException e) {
                    Log.warn(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void dispatchEvent(AWTEvent e) {
            FileDialogQueue fileDialogQueue = this;
            synchronized (fileDialogQueue) {
                if (!this.installed) {
                    this.installed = true;
                    String name = Thread.currentThread().getName();
                    Thread.currentThread().setName(name + " (abbot FileDialogTester)");
                }
            }
            if (e.paramString().indexOf("FileDialogPeer") != -1) {
                Log.debug("ignoring peer event: " + e);
                this.dispose();
            } else {
                super.dispatchEvent(e);
            }
        }
    }
}

