/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BadTransformException;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.FreeListManager;
import javax.media.j3d.Group;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.VirtualUniverse;

public class TransformGroup
extends Group {
    public static final int ALLOW_TRANSFORM_READ = 17;
    public static final int ALLOW_TRANSFORM_WRITE = 18;

    public TransformGroup() {
    }

    public TransformGroup(Transform3D transform3D) {
        if (!transform3D.isAffine()) {
            throw new BadTransformException(J3dI18N.getString("TransformGroup0"));
        }
        ((TransformGroupRetained)this.retained).setTransform(transform3D);
    }

    void createRetained() {
        this.retained = new TransformGroupRetained();
        this.retained.setSource(this);
    }

    public void setTransform(Transform3D transform3D) {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TransformGroup1"));
        }
        if (!transform3D.isAffine()) {
            throw new BadTransformException(J3dI18N.getString("TransformGroup0"));
        }
        ((TransformGroupRetained)this.retained).setTransform(transform3D);
    }

    public void getTransform(Transform3D transform3D) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TransformGroup2"));
        }
        ((TransformGroupRetained)this.retained).getTransform(transform3D);
    }

    public Node cloneNode(boolean bl) {
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.duplicateNode(this, bl);
        return transformGroup;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        Transform3D transform3D = VirtualUniverse.mc.getTransform3D(null);
        ((TransformGroupRetained)node.retained).getTransform(transform3D);
        ((TransformGroupRetained)this.retained).setTransform(transform3D);
        FreeListManager.freeObject(2, transform3D);
    }
}

