/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class UtilMemoryFreelist {
    ArrayList elementData = null;
    int size = 0;
    int currBlockSize = 10;
    Object[] currBlock = null;
    int currBlockIndex = 0;
    int spaceUsed = 0;
    int numBlocks = 0;
    int capacity = 0;
    int minBlockSize = 0;
    boolean justShrunk = false;
    int initcap = 10;
    int minSize = 0;
    Class c = null;

    public UtilMemoryFreelist(String string) {
        this(string, 10);
    }

    public UtilMemoryFreelist(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        try {
            this.c = Class.forName(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initcap = n;
        this.minBlockSize = this.currBlockSize = n;
        this.elementData = new ArrayList();
        this.currBlock = new Object[this.currBlockSize];
        this.elementData.add(this.currBlock);
        ++this.numBlocks;
        this.capacity += this.currBlockSize;
    }

    public UtilMemoryFreelist(String string, Collection collection) {
        try {
            this.c = Class.forName(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initcap = this.size = collection.size();
        this.minBlockSize = this.currBlockSize = this.size;
        this.elementData = new ArrayList();
        this.currBlock = new Object[this.currBlockSize];
        collection.toArray(this.currBlock);
        this.elementData.add(this.currBlock);
        ++this.numBlocks;
        this.capacity += this.currBlockSize;
        this.spaceUsed = this.size;
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized boolean add(Object object) {
        if (this.justShrunk) {
            if (this.currBlockSize / 2 < this.spaceUsed) {
                this.size -= this.spaceUsed - this.currBlockSize / 2;
                this.spaceUsed = this.currBlockSize / 2;
                Arrays.fill(this.currBlock, this.spaceUsed, this.currBlockSize - 1, null);
            }
            this.justShrunk = false;
            return false;
        }
        this.ensureCapacity(this.size + 1);
        if (this.currBlockIndex == -1 || this.spaceUsed >= this.currBlockSize) {
            ++this.currBlockIndex;
            this.currBlock = (Object[])this.elementData.get(this.currBlockIndex);
            this.currBlockSize = this.currBlock.length;
            this.spaceUsed = 0;
        }
        int n = this.spaceUsed++;
        this.currBlock[n] = object;
        ++this.size;
        return true;
    }

    private synchronized Object removeLastElement() {
        int n = --this.spaceUsed;
        Object object = this.currBlock[n];
        this.currBlock[n] = null;
        --this.size;
        if (this.spaceUsed == 0) {
            --this.currBlockIndex;
            if (this.currBlockIndex < 0) {
                this.currBlock = null;
                this.currBlockSize = 0;
            } else {
                this.currBlock = (Object[])this.elementData.get(this.currBlockIndex);
                this.currBlockSize = this.currBlock.length;
            }
            this.spaceUsed = this.currBlockSize;
        }
        return object;
    }

    public synchronized void shrink() {
        if (this.minSize > this.minBlockSize && this.numBlocks > 1) {
            this.justShrunk = true;
            Object[] objectArray = (Object[])this.elementData.remove(this.numBlocks - 1);
            --this.numBlocks;
            this.capacity -= objectArray.length;
            if (this.numBlocks == this.currBlockIndex) {
                this.size -= this.spaceUsed;
                this.currBlockIndex = this.numBlocks - 1;
                this.currBlock = (Object[])this.elementData.get(this.currBlockIndex);
                this.spaceUsed = this.currBlockSize = this.currBlock.length;
            }
        } else {
            this.justShrunk = false;
        }
        this.minSize = this.size;
    }

    public synchronized void ensureCapacity(int n) {
        if (n > this.capacity) {
            int n2 = ((Object[])this.elementData.get(this.numBlocks - 1)).length;
            int n3 = 0;
            if (this.numBlocks > 1) {
                n3 = ((Object[])this.elementData.get(this.numBlocks - 2)).length;
            }
            this.currBlockSize = n2 + n3;
            this.currBlock = new Object[this.currBlockSize];
            this.elementData.add(this.currBlock);
            ++this.numBlocks;
            ++this.currBlockIndex;
            this.capacity += this.currBlockSize;
            this.spaceUsed = 0;
        }
    }

    synchronized void rangeCheck(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
    }

    public synchronized void clear() {
        this.elementData.clear();
        this.minBlockSize = this.currBlockSize = this.initcap;
        this.currBlock = new Object[this.currBlockSize];
        this.elementData.add(this.currBlock);
        this.numBlocks = 1;
        this.capacity = this.currBlockSize;
        this.spaceUsed = 0;
        this.size = 0;
        this.currBlockIndex = 0;
        this.justShrunk = false;
    }

    public synchronized Object getObject() {
        if (this.size > 0) {
            return this.removeLastElement();
        }
        try {
            return this.c.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

