// JavaScript Document
window.onload=testerNavigateur;
//-----------------------------
function testerNavigateur() {   
	objetXHR = creationXHR();
	if(objetXHR==null) {
		document.getElementById("button").disabled= true;
		var erreurNavigateur="Erreur Navigateur : Création d'objet XHR impossible";
		remplacerContenu("info", erreurNavigateur);
	    document.getElementById("info").style.visibility="visible";
	}
	document.getElementById("nom").onkeyup=verifierNom;
}
//##############################MOTEUR AJAX 1############################################

function jouer() {   
	 //création d'un objet XHR multi-navigateurs
	 objetXHR = creationXHR();
	 var temps = new Date().getTime();//création d'une variable temps pour l'anti-cache
	 //construction de la chaine des parametres
	 var parametres = "nom="+ codeContenu("nom") + "&ID="+ nouveauResultat +
	                  "&anticache="+temps ;
	 //Config. objet XHR
     objetXHR.open("get","gainAleatoire.php?"+parametres, true); 
	 objetXHR.onreadystatechange = actualiserPage;//désignation de la fonction de rappel
	 //gestion du bouton et du chargeur
	 document.getElementById("button").disabled= true;
	 document.getElementById("charge").style.visibility="visible";
     objetXHR.send(null);//envoi de la requete
	 /*---------------------------------------- */
  }
  function actualiserPage() {
	if (objetXHR.readyState == 4) {//test si le résultat est disponible
	 if (objetXHR.status == 200) {
	   var nouveauResultat = objetXHR.responseText.split(":");//recup du résulat > tableau 
	   if(nouveauResultat[2]==1) {
		   demandeGains();
		   var elementInfo = document.getElementById("info");
	       elementInfo.innerHTML='Bravo, M <span id="gagnant"></span>&nbsp;vous avez gagné <span id="resultat"></span>&nbsp;Euros';
		   elementInfo.style.color="black";
		   //actualisation du résultat
		   remplacerContenu("resultat", decodeURI(nouveauResultat[1]));
		   //actualisation du nom
		   remplacerContenu("gagnant", decodeURI(nouveauResultat[0]));
		   //affiche la zone info
	   }else{
		   	var elementInfo = document.getElementById("info");
	        elementInfo.innerHTML="Problème technique : gains non enregistrés" ;
			elementInfo.style.color="red";
	      }
	   document.getElementById("info").style.visibility="visible";
	   //gestion du bouton et du chargeur
	   document.getElementById("button").disabled= false;
	   document.getElementById("charge").style.visibility="hidden";
	 }else{
	   //message d'erreur serveur
	   var erreurServeur="Erreur serveur : "+objetXHR.status+" – "+ objetXHR.statusText;
	   remplacerContenu("info", erreurServeur);
	   document.getElementById("info").style.visibility="visible";
	   //gestion du bouton et du chargeur
	   document.getElementById("button").disabled= false;
	   document.getElementById("charge").style.visibility="hidden";
	   //annule la requete en cours
	   objetXHR.abort();
	   objetXHR=null;
	   }
	 }
  }
//##############################MOTEUR AJAX 2############################################
function verifierNom() {   
 //création d'un objet XHR multi-navigateurs
 objetXHR2 = creationXHR();
 var temps = new Date().getTime();//création d'une variable temps pour l'anti-cache
 //construction de la chaine des parametres
 var parametres2= "nom="+ codeContenu("nom") +
	                  "&anticache="+temps ;
 //Config. objet XHR
 objetXHR2.open("get","nomVerification.php?"+parametres2, true); 
 objetXHR2.onreadystatechange = afficherReponse;//désignation de la fonction de rappel
 //gestion du bouton et du chargeur
 document.getElementById("button").disabled= true;
 objetXHR2.send(null);//envoi de la requete
 //setTimeout("verifierNom()",1000);//timer de 1 s
 }

function afficherReponse() {
	if (objetXHR2.readyState == 4) {//test si le résultat est disponible
	 if (objetXHR2.status == 200) {
	   nouveauResultat = objetXHR2.responseText;//recup du résulat > tableau 
	   //test de la réponse
		   if(nouveauResultat!=0) {
			  demandeGains();
			  //affiche la zone message
			  document.getElementById("message").style.visibility="visible";
			  //affichage du message "joueur identifié"
			  remplacerContenu("message", "Joueur identifié");
			  document.getElementById("message").style.color="green";
			  //gestion du bouton 
			  document.getElementById("button").disabled= false;
		   }else{
			  //affiche la zone message
			  document.getElementById("message").style.visibility="visible";
			  //affichage du message "joueur inconnu"
			  remplacerContenu("message", "Joueur inconnu");
			  document.getElementById("message").style.color="red";
			  //gestion du bouton 
			  document.getElementById("button").disabled= true;
		    }
	 }else{
	   //message d'erreur serveur
	   var erreurServeur="Erreur serveur : "+objetXHR2.status+" – "+ objetXHR2.statusText;
	   remplacerContenu("info", erreurServeur);
	   document.getElementById("info").style.visibility="visible";
	   //gestion du bouton et du chargeur
	   document.getElementById("button").disabled= false;
	   //annule la requete en cours
	   objetXHR2.abort();
	   objetXHR2=null;
	   }
	 }
  }
//##############################MOTEUR AJAX 3############################################
function demandeGains() {   
 //création d'un objet XHR multi-navigateurs
 objetXHR3 = creationXHR();
 var temps = new Date().getTime();//création d'une variable temps pour l'anti-cache
 //construction de la chaine des parametres
 var parametres3 = "ID="+ nouveauResultat +
	                  "&anticache="+temps ;
 //Config. objet XHR
 objetXHR3.open("get","gainListe.php?"+parametres3, true); 
 objetXHR3.onreadystatechange = afficheGains;//désignation de la fonction de rappel
 objetXHR3.send(null);//envoi de la requete
 }

function afficheGains() {
	if (objetXHR3.readyState == 4) {//test si le résultat est disponible
	 if (objetXHR3.status == 200) {
	   listeJSON = objetXHR3.responseText;//recup du résulat > objet JSON
	   objetJSON3=listeJSON.parseJSON();
	   //créa des nouvelles lignes
	   var tableListe=document.getElementById("tableListe");
	   supprimerContenu(tableListe);
	   for(i=0;i<objetJSON3.gains.length;i++){
		 var montant=objetJSON3.gains[i].montant;
		 var date=objetJSON3.gains[i].date;
	     nouvelleLigne(tableListe,date,montant);
	   }
	 }else{
	   //message d'erreur serveur
	   var erreurServeur="Erreur serveur : "+objetXHR3.status+" – "+ objetXHR3.statusText;
	   remplacerContenu("info", erreurServeur);
	   document.getElementById("info").style.visibility="visible";
	   //gestion du bouton et du chargeur
	   document.getElementById("button").disabled= false;
	   //annule la requete en cours
	   objetXHR3.abort();
	   objetXHR3=null;
	   }
	 }
  }
  //-----------------------------------------
function nouvelleLigne(tab,text1,text2) { 
	   var nouveauTR=document.createElement('tr');
	   //-----------------------------------------
	   var nouveauTD1=document.createElement('td');
	   var nouveauTXT1=document.createTextNode(text1);
	   nouveauTD1.appendChild(nouveauTXT1);
	   var nouveauTD2=document.createElement('td');
	   var nouveauTXT2=document.createTextNode(text2);
	   nouveauTD2.appendChild(nouveauTXT2);
	   //------------------------------------------
	   nouveauTR.appendChild(nouveauTD1);
	   nouveauTR.appendChild(nouveauTD2);
	   //------------------------------------------
	   tab.appendChild(nouveauTR);
}