/***********************
* Actions de compositions pour Adobe Edge Animate
*
* Modifier ce fichier avec précaution, en veillant à conserver 
* les signatures et les commentaires de fonction commençant par « Edge » pour maintenir la 
* possibilité d’interagir avec ces actions depuis Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // alias pour les classes Edge couramment utilisées

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      
      
      
      
      
      
      

      

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         sym.$("pion").draggable();
         sym.$("pion2").draggable ({containment:sym.$("zone")})
         sym.$("pion3").draggable({grid: [ 63, 63 ]}) 

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_pion}", "mousemove", function(sym, e) {
         sym.$("affichage").text(Math.round(sym.$("pion").position().left/63));

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

})(jQuery, AdobeEdge, "EDGE-10291250");