/***********************
* Actions de compositions pour Adobe Edge Animate
*
* Modifier ce fichier avec précaution, en veillant à conserver 
* les signatures et les commentaires de fonction commençant par « Edge » pour maintenir la 
* possibilité d’interagir avec ces actions depuis Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // alias pour les classes Edge couramment utilisées

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "${_balleHaut}", "click", function(sym, e) {
         sym.$(e.currentTarget).css({backgroundColor:"#888888",borderWidth:10,borderColor:"#ffea6C",borderStyle:"solid"});
      
      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         
         
         // insérer le code à exécuter lorsque le chargement de la composition est terminé
         $(".rondGris").mouseover(survolBouton);
         $(".rondGris").mouseout(sortieBouton);
         
         function survolBouton () {
         	$(this).css({borderStyle:"solid",borderWidth:2,borderColor:"#ffea6C"});
         }
         function sortieBouton () {
         	$(this).css({borderStyle:"none"});
         }

      });
      //Edge binding end

      

   })("stage");
   //Edge symbol end:'stage'

})(jQuery, AdobeEdge, "EDGE-146938919");