/***********************
* Actions de compositions pour Adobe Edge Animate
*
* Modifier ce fichier avec précaution, en veillant à conserver 
* les signatures et les commentaires de fonction commençant par « Edge » pour maintenir la 
* possibilité d’interagir avec ces actions depuis Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // alias pour les classes Edge couramment utilisées

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      var niveaux =["Facile","Normal","Élevé"];
      var villes=["Paris","Madrid","Londres","Milan","Bruxelles"];
      var voitures = ["2 chevaux","Diane 6","104","Traction avant"];
      var indexNiveau=1;
      var indexVille=0;
      var numeroAleatoire;
      
      
      Symbol.bindElementAction(compId, symbolName, "${_boutonRandom}", "click", function(sym, e) {
         numeroAleatoire = Math.floor(Math.random()*voitures.length);
         sym.$("affichage").text(voitures[numeroAleatoire]);
      
      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "${_niveauSup}", "click", function(sym, e) {
         indexNiveau = indexNiveau<niveaux.length-1 ? indexNiveau=indexNiveau+1:0;
         sym.$("niveauJeu").text(niveaux[indexNiveau]);
      
      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "${_niveauInf}", "click", function(sym, e) {
         indexNiveau = indexNiveau>0 ? indexNiveau=indexNiveau-1 : niveaux.length-1;
         sym.$("niveauJeu").text(niveaux[indexNiveau]);
      
      });
      //Edge binding end
      Symbol.bindElementAction(compId, symbolName, "${_villeSup}", "click", function(sym, e) {
         indexVille = indexVille<villes.length-1 ? indexVille=indexVille+1:0;
         sym.$("nomVille").text(villes[indexVille]);
      
      });
      //Edge binding end
      Symbol.bindElementAction(compId, symbolName, "${_villeInf}", "click", function(sym, e) {
         indexVille = indexVille>0 ? indexVille=indexVille-1 : villes.length-1;
         sym.$("nomVille").text(villes[indexVille]);
      
      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         sym.$("affichage").css({backgroundColor:"white"});
      
      });
      //Edge binding end
      
      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'BoutonNav'
   (function(symbolName) {   
   
   })("BoutonNav");
   //Edge symbol end:'BoutonNav'

})(jQuery, AdobeEdge, "EDGE-475923112");