/***********************
* Actions de compositions pour Adobe Edge Animate
*
* Modifier ce fichier avec précaution, en veillant à conserver 
* les signatures et les commentaires de fonction commençant par « Edge » pour maintenir la 
* possibilité d’interagir avec ces actions depuis Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // alias pour les classes Edge couramment utilisées

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      Symbol.bindElementAction(compId, symbolName, "document", "keydown", function(sym, e) {
         // insérer le code à exécuter lorsque vous appuyez sur une touche.
         // La variable “e.which” indique le code associé à la touche sur laquelle vous avez appuyé, par exemple 32 = espace
         if (e.which == 32) {
         	sym.$("lapin").hide();
      
         }
      
      });
      
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "document", "keyup", function(sym, e) {
         // insérer le code à exécuter lorsque vous cessez d'appuyer sur une touche.
         // La variable “e.which” indique le code associé à la touche sur laquelle vous avez appuyé, par exemple 13 = entrée
         if (e.which == 32) {
         	sym.$("lapin").show();
         }
      
      });
      //Edge binding end
      
      //Edge binding end
      
      

      Symbol.bindElementAction(compId, symbolName, "window", "resize", function(sym, e) {
         sym.$("affichage").text(sym.$(window).width());
         
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

})(jQuery, AdobeEdge, "EDGE-37061632");