/***********************
* Actions de compositions pour Adobe Edge Animate
*
* Modifier ce fichier avec précaution, en veillant à conserver 
* les signatures et les commentaires de fonction commençant par « Edge » pour maintenir la 
* possibilité d’interagir avec ces actions depuis Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // alias pour les classes Edge couramment utilisées

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "${_Group}", "click", function(sym, e) {
         //sym.$("balle4a").animate({left:450},2000,"easeInBack");
         //sym.$("balle4b").animate({left:450},2000,"easeOutBack");
         //sym.$("balle4c").animate({left:450},2000,"easeInOutBack");
         
         TweenMax.to(sym.$("balle4a"), 2, {x:300,ease:Back.easeIn});
         TweenMax.to(sym.$("balle4b"), 2, {x:300,ease:Back.easeOut});
         TweenMax.to(sym.$("balle4c"), 2, {x:300,ease:Back.easeInOut});

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_balle}", "click", function(sym, e) {
         //sym.$(e.currentTarget).animate({left:450});
         TweenMax.to(sym.$("balle"), 1, {left:450});

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_balle2}", "click", function(sym, e) {
         //sym.$(e.currentTarget).animate({left:450},2000);
         TweenMax.to(sym.$("balle2"), 2, {left:450});

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_balle3}", "click", function(sym, e) {
         //sym.$(e.currentTarget).delay(1000).animate({left:450},2000);
         TweenMax.to(sym.$("balle3"), 1, {left:450,delay:1});

      });
      //Edge binding end

      

      Symbol.bindElementAction(compId, symbolName, "${_balle4}", "click", function(sym, e) {
         //sym.$(e.currentTarget).delay(1000).animate({left:450},2000);
         TweenMax.to(sym.$("balle4"), 1, {left:450,onComplete:finAnimation});
         
         function finAnimation() {
         	sym.$("balle4").css({opacity:0.5});
         }

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

})(jQuery, AdobeEdge, "EDGE-8553783");