/***********************
* Actions de compositions pour Adobe Edge Animate
*
* Modifier ce fichier avec précaution, en veillant à conserver 
* les signatures et les commentaires de fonction commençant par « Edge » pour maintenir la 
* possibilité d’interagir avec ces actions depuis Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // alias pour les classes Edge couramment utilisées

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      var rond1;
      var rond2;
      var rond3;
      var rond4;
      
      Symbol.bindElementAction(compId, symbolName, "${_titre}", "click", function(sym, e) {
         TweenMax.to(sym.$("titre"), 2, {backgroundColor:"black",color:"red"});
      
      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "${_titre2}", "click", function(sym, e) {
         TweenMax.to(sym.$("titre2"), 1, {css:{"font-size":60}});
      
      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "${_titre3}", "click", function(sym, e) {
         TweenMax.to(sym.$("titre3"), 0.5, {css:{top:350}, repeat:3, yoyo:true, repeatDelay:.5});
      
      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "${_r1}", "click", function(sym, e) {
         TweenMax.staggerTo([rond1,rond2,rond3,rond4],1, {scale:1.5, x:200,opacity:0.3,ease:Elastic.easeOut}, 0.5);
      
      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "${_barre}", "click", function(sym, e) {
         TweenMax.to(sym.$(e.currentTarget), 2, {rotation:90});
      
      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         rond1 = sym.$("r1");
      	rond2 = sym.$("r2");
      	rond3 = sym.$("r3");
      	rond4 = sym.$("r4");
      
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

})(jQuery, AdobeEdge, "EDGE-27252780");