/***********************
* Actions de compositions pour Adobe Edge Animate
*
* Modifier ce fichier avec précaution, en veillant à conserver 
* les signatures et les commentaires de fonction commençant par « Edge » pour maintenir la 
* possibilité d’interagir avec ces actions depuis Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // alias pour les classes Edge couramment utilisées

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      Symbol.bindElementAction(compId, symbolName, "${_boutonLecturePause}", "click", function(sym, e) {
               // insérer le code du clic de souris ici
               // Lire une piste audio 
               if(sym.getSymbol("boutonLecturePause").getPosition()==0) {
                  	sym.getSymbol("boutonLecturePause").stop(250);
                  	sym.$("pisteAudio")[0].play();
                  } else {
                  	sym.getSymbol("boutonLecturePause").stop(0.);
                  	sym.$("pisteAudio")[0].pause();
                  }
      
            });
            //Edge binding end
      
            Symbol.bindElementAction(compId, symbolName, "${_boutonSon}", "click", function(sym, e) {
               if(sym.getSymbol("boutonSon").getPosition()==0) {
               	sym.getSymbol("boutonSon").stop(250);
               	sym.$("pisteAudio")[0].muted = true;
               } else {
               	sym.getSymbol("boutonSon").stop(0.);
               	sym.$("pisteAudio")[0].muted = false;
               }
      
            });
            //Edge binding end
      
            Symbol.bindElementAction(compId, symbolName, "${_pisteAudio}", "timeupdate", function(sym, e) {
      
               // Attention, les variables de ce script d'évènement ont été déclatée sur Stage (à gauche de cette fenêtre).
               positionTete = sym.$("pisteAudio")[0].currentTime;
      
               sym.$("affichage").text(sym.$("pisteAudio")[0].currentTime);
               //ou aussi
               //sym.$("affichage").text(positionTete);
      
      
               minutes=Math.floor(sym.$("pisteAudio")[0].currentTime/60%60);
               secondes=Math.floor(sym.$("pisteAudio")[0].currentTime%60);
      
               minutes=minutes<10 ? "0"+minutes : minutes;
               secondes=secondes<10 ? "0"+secondes : secondes;
      
               sym.$("affichage2").text(minutes+":"+secondes);
      
               sym.$("jauge").css({width:(320*(sym.$("pisteAudio")[0].currentTime/sym.$("pisteAudio")[0].duration))});
      
            });
            //Edge binding end
      
            Symbol.bindElementAction(compId, symbolName, "${_Son1}", "click", function(sym, e) {
               
               codecFichier = sym.$("pisteAudio")[0].src.substr(sym.$("pisteAudio")[0].src.length-3,3)
               if(codecFichier=="mp3") {
               	sym.$("pisteAudio")[0].src="media/son1.mp3";
               } else {
               	sym.$("pisteAudio")[0].src="media/son1.ogg";
               }

            });
            //Edge binding end
      
            Symbol.bindElementAction(compId, symbolName, "${_Son2}", "click", function(sym, e) {
               
               codecFichier = sym.$("pisteAudio")[0].src.substr(sym.$("pisteAudio")[0].src.length-3,3)
               if(codecFichier=="mp3") {
               	sym.$("pisteAudio")[0].src="media/son2.mp3";
               } else {
               	sym.$("pisteAudio")[0].src="media/son2.ogg";
               }

            });
            //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "${_boutonRetour}", "click", function(sym, e) {
         sym.$("pisteAudio")[0].currentTime=0;
      
      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "${_pisteAudio}", "ended", function(sym, e) {
      
              sym.getSymbol("boutonLecturePause").stop(0);
      
      });
            //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'BoutonLecturePause'
   (function(symbolName) {   
   
   })("BoutonLecturePause");
   //Edge symbol end:'BoutonLecturePause'

   //=========================================================
   
   //Edge symbol: 'BoutonsSonOnOff'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("BoutonsSonOnOff");
   //Edge symbol end:'BoutonsSonOnOff'

})(jQuery, AdobeEdge, "EDGE-348123979");