/***********************
* Actions de compositions pour Adobe Edge Animate
*
* Modifier ce fichier avec précaution, en veillant à conserver 
* les signatures et les commentaires de fonction commençant par « Edge » pour maintenir la 
* possibilité d’interagir avec ces actions depuis Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // alias pour les classes Edge couramment utilisées

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         
         sym.$("perso1").data({nom:"Tardiveau",prenom:"David",age:"44",temps:0});
         sym.$("perso2").data({nom:"Louis",prenom:"Serge",age:"43",temps:1000});
         sym.$("perso3").data({nom:"Tibeau",prenom:"Luna",age:"8",temps:2000});
         
         sym.$("affichage").text("");
         
         sym.$(".perso").mouseover(survol);
         
         function survol(e) {
         	sym.$("affichage").html("Bonjour,<br><br>Je m'appelle "+sym.$(e.currentTarget).data("prenom")+" "+sym.$(e.currentTarget).data("nom")+".<br><br>J'ai "+sym.$(e.currentTarget).data("age")+" ans.");
         	sym.getSymbol("pointeBulle").stop(sym.$(e.currentTarget).data("temps"));
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Bulle'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("Bulle");
   //Edge symbol end:'Bulle'

})(jQuery, AdobeEdge, "EDGE-376633981");