/***********************
* Actions de compositions pour Adobe Edge Animate
*
* Modifier ce fichier avec précaution, en veillant à conserver 
* les signatures et les commentaires de fonction commençant par « Edge » pour maintenir la 
* possibilité d’interagir avec ces actions depuis Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // alias pour les classes Edge couramment utilisées

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      var minutes;
      var secondes;
      var positionTete;
      var codecFichier;
      
      Symbol.bindElementAction(compId, symbolName, "${_ecran}", "timeupdate", function(sym, e) {
      
         // Attention, les variables de ce script d'évènement ont été déclatée sur Stage (à gauche de cette fenêtre).
         positionTete = sym.$("ecran")[0].currentTime;
      
         sym.$("affichage").text(sym.$("ecran")[0].currentTime);
         //ou aussi
         //sym.$("affichage").text(positionTete);
      
      
         minutes=Math.floor(sym.$("ecran")[0].currentTime/60%60);
         secondes=Math.floor(sym.$("ecran")[0].currentTime%60);
      
         minutes=minutes<10 ? "0"+minutes : minutes;
         secondes=secondes<10 ? "0"+secondes : secondes;
      
         sym.$("affichage2").text(minutes+":"+secondes);
      
         sym.$("jauge").css({width:(320*(sym.$("ecran")[0].currentTime/sym.$("ecran")[0].duration))});
      
      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "${_ecran}", "ended", function(sym, e) {
      
         sym.getSymbol("boutonLecturePause").stop(0);
      
      });
      //Edge binding end
      
      
      
      
      
      
      
      
      Symbol.bindElementAction(compId, symbolName, "${_boutonLecturePause}", "click", function(sym, e) {
         if(sym.getSymbol("boutonLecturePause").getPosition()==0) {
         	sym.getSymbol("boutonLecturePause").stop(250);
         	sym.$("ecran")[0].play();
         } else {
         	sym.getSymbol("boutonLecturePause").stop(0.);
         	sym.$("ecran")[0].pause();
         }
      
      });
      //Edge binding end
      
      
      Symbol.bindElementAction(compId, symbolName, "${_boutonSon}", "click", function(sym, e) {
         if(sym.getSymbol("boutonSon").getPosition()==0) {
         	sym.getSymbol("boutonSon").stop(250);
         	sym.$("ecran")[0].muted = true;
         } else {
         	sym.getSymbol("boutonSon").stop(0.);
         	sym.$("ecran")[0].muted = false;
         }
      
      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "${_boutonRetour}", "click", function(sym, e) {
         sym.$("ecran")[0].currentTime=0;
      
      
      });
      //Edge binding end
      
      
      
      Symbol.bindElementAction(compId, symbolName, "${_Film1}", "click", function(sym, e) {
      
         codecFichier = sym.$("ecran")[0].src.substr(sym.$("ecran")[0].src.length-3,3)
      
      
         if(codecFichier=="mp4") {
         	sym.$("ecran")[0].src="media/video1.mp4";
         } else {
         	sym.$("ecran")[0].src="media/webm/video1.webm";
         }
      
      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "${_Film2}", "click", function(sym, e) {
      
         codecFichier = sym.$("ecran")[0].src.substr(sym.$("ecran")[0].src.length-3,3);
         
         if(codecFichier=="mp4") {
         	sym.$("ecran")[0].src="media/video2.mp4";
         } else {
         	sym.$("ecran")[0].src="media/webm/video2.webm";
         }
      
      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "${_Film3}", "click", function(sym, e) {
      
         codecFichier = sym.$("ecran")[0].src.substr(sym.$("ecran")[0].src.length-3,3);
         
         if(codecFichier=="mp4") {
         	sym.$("ecran")[0].src="media/video3.mp4";
         } else {
         	sym.$("ecran")[0].src="media/webm/video3.webm";
         }
      
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'BoutonsSonOnOff_symbol_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("BoutonsSonOnOff");
   //Edge symbol end:'BoutonsSonOnOff'

   //=========================================================
   
   //Edge symbol: 'BoutonLecturePause_symbol_1'
   (function(symbolName) {   
   
      

   })("BoutonLecturePause");
   //Edge symbol end:'BoutonLecturePause'

})(jQuery, AdobeEdge, "EDGE-294049531");