/***********************
* Actions de compositions pour Adobe Edge Animate
*
* Modifier ce fichier avec précaution, en veillant à conserver 
* les signatures et les commentaires de fonction commençant par « Edge » pour maintenir la 
* possibilité d’interagir avec ces actions depuis Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // alias pour les classes Edge couramment utilisées

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      
      Symbol.bindElementAction(compId, symbolName, "${_Bouton1}", "click", function(sym, e) {
         sym.$("affichage").text("Message N°1");
      
      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "${_Bouton2}", "click", function(sym, e) {
         sym.$("affichage").text(35*45);
      
      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "${_Bouton3}", "click", function(sym, e) {
         var uneVariable = 12;
         sym.$("affichage").text("Résultat : "+uneVariable);
      
      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "${_Bouton4}", "click", function(sym, e) {
         var laDate = new Date();
         sym.$("affichage").text(laDate.getHours()+":"+laDate.getMinutes());
      
      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         sym.getSymbol("boutonPerso").$("zoneTexte").text("Cliquez");
      
      
         sym.$("boutonPerso").click(afficherMessage);
         function afficherMessage() {
         	alert("Texte de ce bouton modifié à l'aide de cette lign d'instruction : sym.$('boutonPerso').$('zoneTexte').text('Cliquez')");
         }
      
      });
      //Edge binding end
      
      Symbol.bindElementAction(compId, symbolName, "${_Bouton5}", "click", function(sym, e) {
         sym.$("affichage").html("Site <a href='http://www.voxpedao.com'>VOXPedago.com</a>");
      
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'BoutonType'
   (function(symbolName) {   
   
      Symbol.bindElementAction(compId, symbolName, "${_Bouton4Copy}", "click", function(sym, e) {
         var laDate = new Date();
         sym.$("affichage").text(laDate.getHours()+":"+laDate.getMinutes());

      });
      //Edge binding end

   })("BoutonType");
   //Edge symbol end:'BoutonType'

})(jQuery, AdobeEdge, "EDGE-93709553");