/***********************
* Actions de compositions pour Adobe Edge Animate
*
* Modifier ce fichier avec précaution, en veillant à conserver 
* les signatures et les commentaires de fonction commençant par « Edge » pour maintenir la 
* possibilité d’interagir avec ces actions depuis Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // alias pour les classes Edge couramment utilisées

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      

      

      Symbol.bindElementAction(compId, symbolName, "${_lapin}", "click", function(sym, e) {
         sym.getSymbol("lapin").play(0);

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_rideau}", "click", function(sym, e) {
         sym.getSymbol("rideau").play(0);

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_Ellipse}", "click", function(sym, e) {
         sym.getSymbol("expressionPersonnage").stop("une");

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_EllipseCopy}", "click", function(sym, e) {
         sym.getSymbol("expressionPersonnage").stop("deux");

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_EllipseCopy2}", "click", function(sym, e) {
         sym.getSymbol("expressionPersonnage").stop("trois");

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'RideauAnim'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.stop(0);

      });
      //Edge binding end

   })("RideauAnim");
   //Edge symbol end:'RideauAnim'

   //=========================================================
   
   //Edge symbol: 'Lapin'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.stop(0);

      });
      //Edge binding end

   })("Lapin");
   //Edge symbol end:'Lapin'

   //=========================================================
   
   //Edge symbol: 'AnimationControleSymbole_symbol_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("AnimationControleSymbole_symbol_1");
   //Edge symbol end:'AnimationControleSymbole_symbol_1'

})(jQuery, AdobeEdge, "EDGE-37061632");