
// ANALYZE

ANALYZE NO_WRITE_TO_BINLOG TABLE 
        Adherent,Pratique,Sport;

CREATE TEMPORARY TABLE IF NOT EXISTS Adherent_sans_tel
    AS SELECT adhid,nom,prenom,civilite,date_nais FROM Adherent;

ANALYZE NO_WRITE_TO_BINLOG TABLE 
        Adherent_sans_tel;

SHOW INDEX FROM Adherent;

SHOW INDEX FROM Adherent_sans_tel;

//PROCEDURE ANALYZE

SELECT adhid,nom,prenom,civilite,date_nais,tel
      FROM Adherent 
      PROCEDURE ANALYSE(10);

// EXPLAIN

EXPLAIN 
SELECT  a.adhid, a.prenom, a.nom 
  FROM  Adherent a, Pratique p, Sport s
  WHERE EXTRACT(YEAR FROM a.date_nais) = 1995
  AND   a.adhid   = p.adhid
  AND   s.spid    = p.spid 
  AND s.splibelle = 'Hand-ball' 
  ORDER BY nom;


EXPLAIN EXTENDED
SELECT  adhid, prenom, nom 
  FROM  Adherent 
  WHERE EXTRACT(YEAR FROM date_nais) = 1995
  UNION
SELECT  adhid, prenom, nom 
  FROM  Adherent
  WHERE EXTRACT(YEAR FROM date_nais) = 2005;
SHOW WARNINGS;

EXPLAIN EXTENDED
SELECT  adhid, prenom, nom 
  FROM  Adherent
  WHERE adhid IN 
  (SELECT adhid FROM Pratique
          WHERE  spid IN (SELECT spid FROM Sport WHERE splibelle = 'Hand-ball'))
  AND EXTRACT(YEAR FROM date_nais) = 1995
  ORDER BY nom;
SHOW WARNINGS;

EXPLAIN EXTENDED
SELECT  a.adhid, a.prenom, a.nom 
  FROM  Adherent a, Pratique p, Sport s
  WHERE EXTRACT(YEAR FROM date_nais) = 1995
  AND   a.adhid   = p.adhid
  AND   s.spid    = p.spid 
  AND   s.splibelle = 'Hand-ball' 
  ORDER BY nom;

EXPLAIN
SELECT  spid,splibelle
  FROM  Sport 
  WHERE NOT (splibelle = 'Hand-ball');

EXPLAIN
SELECT  spid,splibelle
  FROM  Sport 
  WHERE splibelle <> 'Hand-ball';

EXPLAIN
SELECT  spid,splibelle
  FROM  Sport 
  WHERE splibelle <=> 'Hand-ball';
