/* Jointures */

/*  sans index sur Sport, Adherent et Pratique */

/* collecte des stats */

ANALYZE NO_WRITE_TO_BINLOG TABLE 
        Adherent,Pratique,Sport;

/* enlever les lignes incorrectes dans Pratique */

DELETE FROM Pratique
  WHERE adhid NOT IN (SELECT adhid FROM Adherent)
  OR spid     NOT IN (SELECT spid FROM Sport);

/*  essai join rel, proc et SQL92 */

EXPLAIN
SELECT    a.adhid, a.nom, a.tel
    FROM  Adherent a, Sport s, Pratique p
    WHERE s.splibelle  IN ('Escrime','Ping-pong')
    AND   a.adhid = p.adhid
    AND   s.spid  = p.spid;

EXPLAIN
SELECT  a.adhid, a.nom, a.tel FROM Adherent a 
  INNER JOIN Pratique p ON p.adhid = a.adhid
    INNER JOIN Sport s ON s.spid = p.spid 
       WHERE s.splibelle IN ('Escrime','Ping-pong');

EXPLAIN
SELECT  adhid, nom, tel
  FROM Adherent 
  WHERE adhid IN 
    (SELECT adhid
       FROM  Pratique
       WHERE spid IN 
	(SELECT spid FROM Sport WHERE splibelle IN ('Escrime','Ping-pong')));

/* 
  sans index jointure procdurale fait planter...
  avec index mme perfos sauf pour la jointure procdurale
*/