
use bdutil;

CREATE TABLE SGBD
	(a INTEGER(4) PRIMARY KEY, b CHAR(6));
INSERT INTO SGBD (a, b) VALUES (1995, 'Oracle');
INSERT INTO SGBD (a, b) VALUES (1995, 'MySQL')
       ON DUPLICATE KEY UPDATE a = a + 15;
SELECT a,b FROM SGBD;
DROP TABLE SGBD;

CREATE TABLE Compagnie
(comp VARCHAR(4), nrue INTEGER(3),
 rue VARCHAR(20), ville VARCHAR(15) DEFAULT 'Paris' COMMENT 'Par defaut : Paris',
 nomComp VARCHAR(15) NOT NULL,
 CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

CREATE TABLE Pilote
(brevet VARCHAR(6), nom VARCHAR(15) NOT NULL, pseudo VARCHAR(8),
 nbHVol DECIMAL(7,2), compa VARCHAR(4),
 CONSTRAINT pk_Pilote PRIMARY KEY(brevet),
 CONSTRAINT ck_nbHVol CHECK (nbHVol BETWEEN 0 AND 20000),
 CONSTRAINT un_nom UNIQUE (nom),
 CONSTRAINT fk_Pil_compa_Comp FOREIGN KEY (compa) REFERENCES Compagnie(comp));

INSERT INTO Compagnie
   VALUES ('SING', 7, 'Camparols', 'Singapour', 'Singapore AL');

INSERT INTO Compagnie
	VALUES ('AF', 10, 'Gambetta', DEFAULT, 'Air France');

INSERT INTO Compagnie
	VALUES ('AN1', NULL, 'Hoche', 'Blagnac', 'Air Nul1');

INSERT INTO Compagnie(comp, nrue, rue, nomComp)
	VALUES ('AC', 8, 'Champs Elyses', 'Castanet Air');

INSERT INTO Compagnie(comp, rue, ville, nomComp)
	VALUES ('AN2', 'Foch', 'Blagnac', 'Air Nul2');

/* renseignez les colonnes */

INSERT INTO Pilote (brevet,pseudo,nom,nbHVol,compa)
 VALUES ('BE456','willy','Blanchet', 8700, 'SING');

INSERT INTO Pilote
 VALUES ('BE410','Castel','mulos', 3400, 'AF');

INSERT INTO Pilote (brevet,nom,pseudo,nbHVol,compa)
 VALUES ('PL-1', 'Ente', 'loulou', 450, 'AF');
INSERT INTO Pilote (brevet,nom,pseudo,nbHVol,compa)
 VALUES ('PL-2', 'Ferrage', 'jpf', 900, 'AF');
INSERT INTO Pilote (brevet,nom,pseudo,nbHVol,compa)
 VALUES ('PL-3', 'Soutou','polo', 1000, 'SING');

INSERT INTO Compagnie VALUES
 ('LUFT',9,'Salas','Munich','Luftansa'),
 ('QUAN',1,'Kangouroo','Sydney','Quantas'),
 ('SNCM',3,'P. Paoli','Bastia','Corse Air');

SELECT * FROM Compagnie;

INSERT INTO Pilote (brevet,nom,pseudo,nbHVol,compa)
VALUES ('PL-1', 'Diffis', 'gege', 900, 'AF');
INSERT INTO Pilote (brevet,nom,pseudo,nbHVol,compa)
VALUES ('PL-4', 'Ente', 'juju', 1050, 'AF');
INSERT INTO Pilote (brevet,nom,pseudo,nbHVol,compa)
 VALUES ('PL-5', 'Lacombe', 'pizza', 5000, 'LUH');

INSERT INTO Pilote (brevet,nom,pseudo,nbHVol,compa)
VALUES ('PL-6', NULL, 'neant', 1540, 'AF');

INSERT INTO Pilote (brevet,nom,pseudo,nbHVol,compa)
VALUES ('PL-88', 'Benech', 'roma', 20000.01, 'AF');


SELECT * FROM Pilote;
SELECT * FROM Compagnie;

/* insertions multiples */

DROP TABLE IF EXISTS Compagnie_Bis;
CREATE TABLE Compagnie_Bis
(comp VARCHAR(4), nrue INTEGER(3),
 rue VARCHAR(20), ville VARCHAR(15), 
 nomComp VARCHAR(15), budget DECIMAL (8,2) DEFAULT 0,
 CONSTRAINT pk_Compagnie_Bis PRIMARY KEY(comp));

INSERT INTO Compagnie_Bis 
 (comp, nrue, rue, ville, nomComp)
  SELECT comp, nrue, rue, ville, nomComp
    FROM Compagnie 
    WHERE nrue IS NOT NULL
    AND rue IS NOT NULL
    AND ville IS NOT NULL
    AND NOT(ville = 'Paris');

SELECT * FROM Compagnie_Bis;

DROP TABLE IF EXISTS Compagnie_Bis;
DROP TABLE Pilote;
DROP TABLE Compagnie;

/* Bit */

CREATE TABLE Registres (nom CHAR(5),numero BIT(2),adresse BIT(16));
INSERT INTO Registres VALUES ('COM2', b'10', b'0000010011110111');
SELECT * FROM Registres;
DROP TABLE Registres;

/* enumrations */ 

/* ENUM */ 

CREATE TABLE UnCursus 
	(num CHAR(4), nom VARCHAR(15), 
	diplome ENUM ('BTS','DUT','Licence','INSA') NULL,
	CONSTRAINT pk_UnCursus PRIMARY KEY(num));

INSERT INTO UnCursus (num,nom,diplome) 
VALUES ('E1', 'Brouard', ('BTS'));
INSERT INTO UnCursus (num,nom,diplome)  
VALUES ('E2', 'Diffis', 'Licence');
INSERT INTO UnCursus (num,nom,diplome)  
VALUES ('E3', 'Bug', 'MathSup');
INSERT INTO UnCursus (num,nom,diplome)  
VALUES ('E4', 'Trop!', ('Licence','BTS'));
INSERT INTO UnCursus (num,nom,diplome)  
VALUES ('E5', 'Vide','');
INSERT INTO UnCursus (num,nom) 
VALUES ('E6','Puntis');

SELECT num,nom,diplome,diplome+0 FROM UnCursus;

ALTER TABLE UnCursus
	MODIFY diplome SET ('IUP','BTS','DUT','Licence','INSA');

INSERT INTO UnCursus (num,nom,diplome) VALUES ('E7','I. IUP', 'IUP');
INSERT INTO UnCursus (num,nom,diplome) VALUES ('E8','I. INSA', ('INSA'));

SELECT num,nom,diplome,diplome+0 FROM UnCursus;

ALTER TABLE UnCursus
	MODIFY diplome SET ('IUP','INSA');

DELETE FROM UnCursus WHERE num IN ('E1','E2','E6');

ALTER TABLE UnCursus
	MODIFY diplome SET ('IUP','INSA');

SELECT num,nom,diplome,diplome+0 FROM UnCursus;

DROP TABLE UnCursus;

/* SET */

CREATE TABLE Cursus 
	(num CHAR(4), nom VARCHAR(15), 
	diplomes SET ('BTS','DUT','Licence','INSA') NULL,
	CONSTRAINT pk_Cursus PRIMARY KEY(num));

INSERT INTO Cursus (num,nom,diplomes) 
 VALUES ('E1', 'Brouard', ('BTS,Licence'));
INSERT INTO Cursus (num,nom,diplomes) 
 VALUES ('E2', 'Lenquette', 'Licence,INSA,DUT');
INSERT INTO Cursus (num,nom,diplomes)
 VALUES ('E4', 'Alquie', ('BTS,BTS'));
INSERT INTO Cursus (num,nom,diplomes)
 VALUES ('E5', 'Roux', ('Licence,BTS,INSA,BTS,INSA,INSA,DUT'));
INSERT INTO Cursus (num,nom) 
 VALUES ('E6', 'Puntis');

INSERT INTO Cursus (num,nom,diplomes) 
 VALUES ('E3', 'Bug', ('BTS,INSA,ENAC'));

ALTER TABLE Cursus 
	MODIFY diplomes SET ('IUP','BTS','DUT','Licence','INSA');

SELECT num,nom,diplomes FROM Cursus;

DELETE FROM Cursus;

ALTER TABLE Cursus 
	MODIFY diplomes SET ('IUP','M2');

SELECT num,nom,diplomes FROM Cursus;

DROP TABLE Cursus;
	