
/* UPDATE */

use bdutil;

CREATE TABLE Compagnie
(comp varchar(4), nrue INTEGER(3),
 rue varchar(20), ville varchar(15) DEFAULT 'Paris',
 nomComp varchar(15) NOT NULL,
 CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

INSERT INTO Compagnie(comp,nrue,rue,ville,nomComp) 
 VALUES ('SING', 7, 'Camparols', 'Singapour', 'Singapore AL');
INSERT INTO Compagnie(comp,nrue,rue,ville,nomComp) 	
 VALUES ('AF', 10, 'Gambetta', DEFAULT, 'Air France');
INSERT INTO Compagnie(comp,nrue,rue,ville,nomComp) 
 VALUES ('AN1', NULL, 'Hoche', 'Blagnac', 'Air Nul1');
INSERT INTO Compagnie(comp,nrue,rue,nomComp) 
 VALUES ('AC', 8, 'Champs Elyses', 'Castanet Air');
INSERT INTO Compagnie(comp,rue,ville,nomComp) 
 VALUES ('AN2', 'Foch', 'Blagnac', 'Air Nul2');

SELECT * FROM Compagnie;

UPDATE  Compagnie
	SET nrue = 50
	WHERE comp = 'AN1';
UPDATE  Compagnie
	SET nrue = 14, ville = DEFAULT
	WHERE comp = 'AN2';
SELECT * FROM Compagnie;

/*  2 premires Comp */ 

UPDATE Compagnie 
	SET ville = 'Toulouse'
	LIMIT 2;
SELECT * FROM Compagnie ORDER BY 1;

/* ne pas respecter les contraintes */

CREATE TABLE Pilote
(brevet varchar(6), nom varchar(15) NOT NULL,
 nbHVol DECIMAL(7,2), compa varchar(4),
 CONSTRAINT pk_Pilote PRIMARY KEY(brevet),
 CONSTRAINT ck_nbHVol CHECK (nbHVol BETWEEN 0 AND 20000),
 CONSTRAINT un_nom UNIQUE (nom),
 CONSTRAINT fk_Pil_compa_Comp FOREIGN KEY (compa) REFERENCES Compagnie(comp));


INSERT INTO Pilote
 VALUES ('PL-1', 'Ferrage', 450, 'AF');
INSERT INTO Pilote
 VALUES ('PL-2', 'Guilbaud', 900, 'AF');
INSERT INTO Pilote VALUES 
 ('PL-3', 'Lacombe', 1000, 'SING');

SELECT * FROM Compagnie;
SELECT * FROM Pilote;

/* pk */
UPDATE Pilote SET brevet = 'PL-2' WHERE brevet = 'PL-1';

/* nn, passe si  SET SQL_MODE='ALLOW_INVALID_DATES';  */
UPDATE Pilote SET nom = NULL WHERE brevet = 'PL-1';

/* un */
UPDATE Pilote SET nom= 'Lacombe' WHERE brevet = 'PL-1';

/* fk */
UPDATE Pilote SET compa = 'rien' WHERE brevet = 'PL-1';

SELECT * FROM Pilote;

UPDATE Pilote SET compa = 'SING' WHERE brevet = 'PL-2';
UPDATE Pilote SET brevet = 'PL3bis' WHERE brevet = 'PL-3';
/* ck inoprente */
UPDATE Pilote SET nbHVol= 30000 WHERE brevet = 'PL-1';

SELECT * FROM Pilote;

/* maj pk du pre pas possible */
UPDATE Compagnie SET comp = 'SIN2' WHERE comp = 'SING';

/* restriction */

SELECT nbHVol/2 FROM Pilote WHERE brevet='PL-1';

UPDATE Pilote 
  SET nbHVol= (SELECT nbHVol/2 FROM Pilote WHERE brevet='PL-1')  WHERE brevet='PL-2';

DROP TABLE Pilote;
DROP TABLE Compagnie;

