
-- http://sqlpro.developpez.com/cours/divrelationnelle/

/***********************/
/* CRATION DES TABLES */
/***********************/

/* table des rayons */


CREATE TABLE T_RAYON
(RAYON_RYN  CHAR(16));

/* tables des entrepts */
CREATE TABLE T_ENTREPOT
(VILLE_ETP  CHAR(16),
 RAYON_ETP  CHAR(16));

/***************************/
/* ALIMENTATION DES TABLES */
/***************************/

/* alimentation de la table des rayons */

INSERT INTO T_RAYON 
   (RAYON_RYN) VALUES ('frais');
INSERT INTO T_RAYON
   (RAYON_RYN) VALUES ('boisson');
INSERT INTO T_RAYON
   (RAYON_RYN) VALUES ('conserve');
INSERT INTO T_RAYON
   (RAYON_RYN) VALUES ('droguerie');

/* alimentation de la table des entrepots */

INSERT INTO T_ENTREPOT
   (VILLE_ETP, RAYON_ETP) VALUES ('PARIS', 'boisson');
INSERT INTO T_ENTREPOT
   (VILLE_ETP, RAYON_ETP) VALUES ('PARIS', 'frais');
INSERT INTO T_ENTREPOT
   (VILLE_ETP, RAYON_ETP) VALUES ('PARIS', 'conserve');
INSERT INTO T_ENTREPOT
   (VILLE_ETP, RAYON_ETP) VALUES ('LYON', 'boisson');
INSERT INTO T_ENTREPOT
   (VILLE_ETP, RAYON_ETP) VALUES ('LYON', 'conserve');
INSERT INTO T_ENTREPOT
   (VILLE_ETP, RAYON_ETP) VALUES ('LYON', 'droguerie');
INSERT INTO T_ENTREPOT
   (VILLE_ETP, RAYON_ETP) VALUES ('MARSEILLE', 'boisson');
INSERT INTO T_ENTREPOT
   (VILLE_ETP, RAYON_ETP) VALUES ('MARSEILLE', 'frais');
INSERT INTO T_ENTREPOT
   (VILLE_ETP, RAYON_ETP) VALUES ('MARSEILLE', 'conserve');
INSERT INTO T_ENTREPOT
   (VILLE_ETP, RAYON_ETP) VALUES ('MARSEILLE', 'droguerie');
INSERT INTO T_ENTREPOT
   (VILLE_ETP, RAYON_ETP) VALUES ('ANGER', 'boisson');
INSERT INTO T_ENTREPOT
   (VILLE_ETP, RAYON_ETP) VALUES ('ANGER', 'frais');
INSERT INTO T_ENTREPOT
   (VILLE_ETP, RAYON_ETP) VALUES ('ANGER', 'droguerie');
INSERT INTO T_ENTREPOT
   (VILLE_ETP, RAYON_ETP) VALUES ('TOULOUSE', 'boisson');
INSERT INTO T_ENTREPOT
   (VILLE_ETP, RAYON_ETP) VALUES ('TOULOUSE', 'frais');
INSERT INTO T_ENTREPOT
   (VILLE_ETP, RAYON_ETP) VALUES ('TOULOUSE', 'conserve');
INSERT INTO T_ENTREPOT
   (VILLE_ETP, RAYON_ETP) VALUES ('TOULOUSE', 'droguerie');

SELECT DISTINCT te.VILLE_ETP
FROM   T_ENTREPOT te
	WHERE NOT EXISTS
	(SELECT RAYON_RYN FROM T_RAYON
         WHERE  RAYON_RYN NOT IN 
		(SELECT RAYON_ETP FROM T_ENTREPOT 
                 WHERE  VILLE_ETP = te.VILLE_ETP ))
	AND NOT EXISTS
	(SELECT RAYON_ETP FROM T_ENTREPOT 
         WHERE  VILLE_ETP = te.VILLE_ETP
         AND   RAYON_ETP NOT IN 
               (SELECT RAYON_RYN FROM T_RAYON));


DROP TABLE T_RAYON;

DROP TABLE T_ENTREPOT; 

--

CREATE TABLE Compagnie
(comp CHAR(4), nomComp CHAR(15), pays CHAR(4));
INSERT INTO Compagnie   VALUES ('SING', 'Singapore AL', 'SG');
INSERT INTO Compagnie	VALUES ('AF','Air France', 'F');
INSERT INTO Compagnie	VALUES ('ALIB','Air Lib', 'F');

CREATE TABLE Affretements(immat CHAR(5), typeAv CHAR(8),compa CHAR(4), dateAFF DATE);

INSERT INTO Affretements VALUES ('A1', 'A320', 'SING', '1995-05-13');
INSERT INTO Affretements VALUES ('A2', 'A340', 'AF', '1968-06-22');
INSERT INTO Affretements VALUES ('A3', 'Mercure', 'AF', '1965-02-05');
INSERT INTO Affretements VALUES ('A4', 'A330', 'ALIB', '1965-01-16');
INSERT INTO Affretements VALUES ('A3', 'Mercure', 'ALIB', '1942-03-05');
INSERT INTO Affretements VALUES ('A3', 'Mercure', 'SING', '1987-03-01');


/* Division inexacte */

SELECT DISTINCT immat, typeAv FROM Affretements aliasAff
	WHERE NOT EXISTS
	(SELECT DISTINCT comp FROM Compagnie WHERE pays = 'F'
	 AND comp NOT IN 
		(SELECT compa FROM Affretements WHERE immat = aliasAff.immat));

DELETE FROM Affretements WHERE immat='A3' AND compa='SING';

/* Division exacte */

SELECT DISTINCT immat, typeAv FROM Affretements aliasAff
	WHERE NOT EXISTS
	(SELECT comp FROM Compagnie WHERE pays = 'F'
	AND comp NOT IN 
		(SELECT compa FROM Affretements WHERE immat = aliasAff.immat))
	AND NOT EXISTS
	(SELECT compa FROM Affretements WHERE immat = aliasAff.immat
	AND compa NOT IN 
		(SELECT comp FROM Compagnie WHERE pays = 'F'));