/*
WITH arbre_graphe [ () ] AS 
( requete_inititalisation_du_parcours 
UNION ALL 
 requete_jointure_avec_arbre_graphe )
SELECT  FROM arbre_graphe [WHERE   ]
*/

---WITH rcursif

use bdutil;


DROP TABLE Aeroport;
CREATE TABLE Aeroport
(OACI VARCHAR(10), nom_aero VARCHAR(30), OACI_resp VARCHAR(10));

INSERT INTO Aeroport VALUES ('LFPG', 'Paris Charles de Gaule', NULL);
INSERT INTO Aeroport VALUES ('LFPO', 'Paris Orly', 'LFPG');
INSERT INTO Aeroport VALUES ('LFBO', 'Toulouse Blagnac', 'LFBD');
INSERT INTO Aeroport VALUES ('LFBD', 'Bordeaux Merignac', 'LFPO');
INSERT INTO Aeroport VALUES ('LFCI', 'ALbi', 'LFBO');
INSERT INTO Aeroport VALUES ('LFCK', 'Castres', 'LFBO');
INSERT INTO Aeroport VALUES ('LFMW', 'Castelnaudary', 'LFBO');
INSERT INTO Aeroport VALUES ('LFMT', 'Montpellier Fregorgues', 'LFMM');
INSERT INTO Aeroport VALUES ('LFMM', 'Marseille Marignane', 'LFPO');

SELECT OACI,nom_aero,OACI_resp FROM Aeroport;
/*
            LFPG
			|
			LFPO
			|
	 +-------+
	LFMM	LFBD    
	 |		 |
	LFMT 	LFBO
			 |
		+----+--------+
		LFCI  LFCK   LFMW
*/	

-- hierarchie en dessous de Paris
-- LPAD(str,len,padstr)

WITH RECURSIVE sous_Paris_Orly (OACI, OACI_resp, niveau) AS
  (SELECT OACI, OACI_resp, 0 AS niveau
          FROM Aeroport WHERE OACI = 'LFPO'
   UNION ALL
   SELECT a.OACI, a.OACI_resp, niveau+1
          FROM  sous_Paris_Orly sp INNER JOIN
				Aeroport a ON sp.OACI = a.OACI_resp)
SELECT   OACI_resp, LPAD(OACI,4*niveau,' ') AS descendants, niveau
FROM     sous_Paris_Orly 
WHERE    niveau > 0
ORDER BY niveau, OACI;

-- ascendants

WITH RECURSIVE sous_Paris_Orly 
 (OACI, OACI_resp, niveau, aero_liste) AS
  (SELECT OACI, OACI_resp, 0 AS niveau, 
          CAST(OACI_resp AS CHAR(30))
          FROM Aeroport WHERE OACI = 'LFPO'
   UNION ALL
   SELECT a.OACI, a.OACI_resp, niveau+1,
          CAST(CONCAT(aero_liste,',',a.OACI_resp) AS CHAR(30))
          FROM  sous_Paris_Orly sp INNER JOIN
				Aeroport a ON sp.OACI = a.OACI_resp)
SELECT   OACI, niveau, aero_liste
FROM     sous_Paris_Orly
WHERE    niveau > 0 
ORDER BY niveau, OACI;

-- graphe orient

CREATE TABLE Autoroutes
(ville_de VARCHAR(16),ville_vers VARCHAR(16), km DECIMAL(4,1));

INSERT INTO Autoroutes VALUES ('PARIS', 'NANTES', 385);
INSERT INTO Autoroutes VALUES ('PARIS', 'CLERMONT-FERRAND', 420);
INSERT INTO Autoroutes VALUES ('PARIS', 'LYON', 470);
INSERT INTO Autoroutes VALUES ('CLERMONT-FERRAND', 'MONTPELLIER', 335);
INSERT INTO Autoroutes VALUES ('CLERMONT-FERRAND', 'TOULOUSE', 375);
INSERT INTO Autoroutes VALUES ('LYON', 'MONTPELLIER', 305);
INSERT INTO Autoroutes VALUES ('LYON', 'MARSEILLE', 320);
INSERT INTO Autoroutes VALUES ('MONTPELLIER', 'TOULOUSE', 240);
INSERT INTO Autoroutes VALUES ('MARSEILLE', 'NICE', 205);

SELECT ville_de, ville_vers, km FROM Autoroutes;

--nombre d'tapes des diffrents trajets, entre Paris et la ville rose
--nombre de km pour chacun de ces trajets
--dtail des trajets

WITH RECURSIVE graphe_oriente (ville_vers, etape, distance, trajet) AS
   (SELECT DISTINCT ville_de, 0, 0,
           CAST('PARIS' AS CHAR(50))
           FROM Autoroutes WHERE ville_de = 'PARIS'
    UNION  ALL
    SELECT a.ville_vers, g.etape + 1, g.distance+a.km,
	       CAST(CONCAT(g.trajet,',',a.ville_vers) AS CHAR(50))
           FROM Autoroutes a INNER JOIN graphe_oriente g
           ON   g.ville_vers  = a.ville_de)
SELECT trajet, etape AS etapes, distance
FROM   graphe_oriente 
WHERE  ville_vers = 'TOULOUSE'
ORDER BY distance;

--graphe orient

--insertion des routes inverses

INSERT INTO Autoroutes SELECT ville_vers,ville_de, km FROM Autoroutes;

SELECT ville_de, ville_vers, km 
FROM    Autoroutes 
ORDER BY ville_de, ville_vers;

--

WITH RECURSIVE graphe_oriente (ville_vers, etape, distance, trajet) AS
   (SELECT DISTINCT ville_de, 0, 0,
           CAST('PARIS' AS CHAR(50))
           FROM Autoroutes WHERE ville_de = 'PARIS'
    UNION  ALL
    SELECT a.ville_vers, g.etape + 1, g.distance+a.km,
	       CAST(CONCAT(g.trajet,',',a.ville_vers) AS CHAR(50))
           FROM Autoroutes a INNER JOIN graphe_oriente g
           ON    g.ville_vers  = a.ville_de
		   WHERE INSTR(g.trajet,a.ville_vers) = 0
		   AND   g.etape < 10 )
SELECT trajet, etape AS etapes, distance
FROM   graphe_oriente 
WHERE  ville_vers = 'TOULOUSE'
ORDER BY distance;

DROP TABLE Aeroport;
DROP TABLE Autoroutes;