
/* modes SQL */

SELECT @@GLOBAL.sql_mode "Global", @@SESSION.sql_mode "Session";

SET SESSION sql_mode='STRICT_TRANS_TABLES';

DROP TABLE IF EXISTS Vols;
CREATE TABLE Vols
(num_vol CHAR(6), date_vol DATE, num_client INT, date_resa TIMESTAMP);

INSERT INTO Vols
 (num_vol,date_vol,num_client) VALUES ('AF6143','2010-05-02',5);
INSERT INTO Vols
 (num_vol,date_vol,num_client) VALUES ('AF6143','0000-04-10',4);
INSERT INTO Vols
 (num_vol,date_vol,num_client) VALUES ('AF6143','2011-04-31',170);


SET SESSION sql_mode='STRICT_TRANS_TABLES,NO_ZERO_DATE';
INSERT INTO Vols
 (num_vol,date_vol,num_client) VALUES ('AF6143','0000-00-00',0);

SET SESSION sql_mode='STRICT_TRANS_TABLES,NO_ZERO_DATE,NO_ZERO_IN_DATE';
INSERT INTO Vols
 (num_vol,date_vol,num_client) VALUES ('AF6143','2011-04-00',70);
INSERT INTO Vols
 (num_vol,date_vol,num_client) VALUES ('AF6143','2011-00-10',165);
INSERT INTO Vols
 (num_vol,date_vol,num_client) VALUES ('AF6143','2011-00-00',1);

SELECT * FROM Vols;

SET SESSION sql_mode='STRICT_TRANS_TABLES,ALLOW_INVALID_DATES';
INSERT INTO Vols (num_vol,date_vol,num_client) 
  VALUES ('AF6143','2011-04-31',170);

SELECT * FROM Vols;

SET SESSION sql_mode='';
INSERT INTO Vols (num_vol,date_vol,num_client) 
  VALUES ('AF6143','2012-04-31',367);
SHOW WARNINGS;

SELECT * FROM Vols;


/* squences */

CREATE TABLE Affreter
 (numAff SMALLINT AUTO_INCREMENT,
  comp CHAR(4),immat CHAR(6),dateAff DATE,nbPax SMALLINT(3),
  CONSTRAINT pk_Affreter PRIMARY KEY (numAff));

SET SESSION sql_mode='';
INSERT INTO Affreter (comp,immat,dateAff,nbPax)
       VALUES ('AF', 'F-WTSS', '2012-05-13', 85);
INSERT INTO Affreter (numAff,comp,immat,dateAff,nbPax)
       VALUES (NULL, 'EJ','N-23DS', '2012-09-11', 90);
INSERT INTO Affreter (numAff,comp,immat,dateAff,nbPax)
       VALUES (0, 'AF','F-FPJY', '2012-09-11', 95);

SELECT * FROM Affreter ;

SET SESSION sql_mode='NO_AUTO_VALUE_ON_ZERO';

INSERT INTO Affreter (numAff,comp,immat,dateAff,nbPax)
       VALUES (NULL, 'AF','F-FRSS', '2012-09-11', 127);
INSERT INTO Affreter (numAff,comp,immat,dateAff,nbPax)
       VALUES (0, 'AF','F-GLFS', '2012-09-11', 75);

SELECT * FROM Affreter ;

INSERT INTO Affreter 
       VALUES (0, 'AF','F-GLFS', '2012-09-15', 87);
SELECT LAST_INSERT_ID();

/* CHAR */

DROP TABLE IF EXISTS Passager;

CREATE TABLE Passager
 (num_pax SMALLINT AUTO_INCREMENT PRIMARY KEY,
  prenom CHAR(20), nom CHAR(20), mail VARCHAR(30));

SET sql_mode = '';

INSERT INTO Passager (prenom,nom,mail)
       VALUES ('Fred','Brouard', 'sqlpro@sqlspot.com');

SELECT CONCAT(prenom,LENGTH(prenom)) "Prenom",
       CONCAT(nom,LENGTH(nom)) "Nom",
        CONCAT(mail,LENGTH(mail)) "Mail"
FROM Passager;

SET sql_mode = 'PAD_CHAR_TO_FULL_LENGTH';

INSERT INTO Passager (prenom,nom,mail)
       VALUES ('Chris','Codd', 'coddy@dbms.com');

SELECT CONCAT(prenom,LENGTH(prenom)) "Prenom",
       CONCAT(nom,LENGTH(nom)) "Nom",
        CONCAT(mail,LENGTH(mail)) "Mail"
FROM Passager;

/* IGNORE_SPACE */

SET sql_mode = '';

SELECT MAX(nom) FROM Passager;
SELECT MIN (nom) FROM Passager;

CREATE TABLE SELECT(i INT);
CREATE TABLE SELECT (i INT);
CREATE TABLE `SELECT`(i INT);
CREATE TABLE `INSERT` (i INT);

SET sql_mode = 'IGNORE_SPACE';

SELECT MAX(nom),MIN (nom) FROM Passager;

DROP TABLE IF EXISTS `SELECT`;
DROP TABLE IF EXISTS `INSERT`;

/* Moteurs */

DROP TABLE IF EXISTS Clients;
SET sql_mode = '';
CREATE TABLE Clients
 (num_cli SMALLINT AUTO_INCREMENT PRIMARY KEY,
  prenom CHAR(20), nom CHAR(20))
 ENGINE=FEDERATED;

SET sql_mode = 'NO_ENGINE_SUBSTITUTION';

CREATE TABLE Avions
 (immat VARCHAR(8) PRIMARY KEY,
  typeav CHAR(20), mise_service DATE)
 ENGINE=FEDERATED;


/* portabilit */

CREATE INDEX idx_nomcli 
    USING BTREE 
    ON Clients (nom DESC) 
    COMMENT 'plus rapide pour les recherches nominatives';

SET sql_mode = '';
SHOW CREATE TABLE Clients;

SET sql_mode = 'NO_KEY_OPTIONS,NO_TABLE_OPTIONS';
SHOW CREATE TABLE Clients;


/* 
  enumrations ENUM
  avec SET SESSION sql_mode = 'ANSI'; 
  ('E3', 'Bug', ('MathSup'));
   passe mais diplome n'est pas valu en base '' indice 0
*/

#

DROP INDEX IF EXISTS idx_nomcli ;
DROP TABLE IF EXISTS Clients;
DROP TABLE IF EXISTS Vols;
DROP TABLE IF EXISTS Passager;
DROP TABLE IF EXISTS Affreter;
