
/* SQL dynamique */

delimiter ;

DROP TABLE IF EXISTS Avion;
CREATE TABLE Avion
(immat VARCHAR(6), typeAv CHAR(8), nbHVol DECIMAL(7,2), comp VARCHAR(4));

DELETE FROM Avion;
INSERT INTO Avion VALUES ('F-GLFS', 'A320', 1000, 'AF');
INSERT INTO Avion VALUES ('F-WOWW', 'A380', 1500, 'AF');

/* DELETE */
 
delimiter $

SET @vs_nbhVol  = 1000 $
CREATE PROCEDURE bdsoutou.sousProg()
BEGIN
 PREPARE etat1 FROM 'DELETE FROM Avion WHERE nbHVol > ?';
 EXECUTE etat1 USING @vs_nbhVol  ;
 DROP PREPARE etat1 ;
END;
$
CALL bdsoutou.sousProg()$
SELECT * FROM Avion$

/* SELECT */


SET @vs_chaine3 = 'SELECT * FROM Avion WHERE nbHVol = ?' $
SET @vs_nbhVol  = 1000 $

DROP PROCEDURE IF EXISTS bdsoutou.sousProg$
CREATE PROCEDURE bdsoutou.sousProg()
BEGIN
 PREPARE etat3 FROM @vs_chaine3 ;
 EXECUTE etat3 USING @vs_nbhVol;
 DROP PREPARE etat3 ;
END;
$

CALL bdsoutou.sousProg()$

/* UPDATE 1 */

SET @vs_chaine4 = 'UPDATE Avion SET nbHVol=nbHVol*? WHERE immat = ''F-GLFS'''$
SET @vs_pourcent   = 1.1$

DROP PROCEDURE IF EXISTS bdsoutou.sousProg$
CREATE PROCEDURE bdsoutou.sousProg()
BEGIN
 PREPARE etat4 FROM @vs_chaine4;
 EXECUTE etat4 USING @vs_pourcent;
 DROP PREPARE etat4 ;
END;
$

SELECT @vs_chaine4$
SELECT * FROM Avion$
CALL bdsoutou.sousProg()$
SELECT * FROM Avion$

/* UPDATE 2 */

SET @vs_chaine5 = 'UPDATE Avion SET nbHVol=nbHVol*? WHERE immat = ?'$
SET @vs_immat   = 'F-GLFS'$
SET @vs_pourcent = 1.1$

DROP PROCEDURE IF EXISTS bdsoutou.sousProg$
CREATE PROCEDURE bdsoutou.sousProg()
BEGIN
 PREPARE etat5 FROM @vs_chaine5;
 EXECUTE etat5 USING @vs_pourcent,@vs_immat; 
 DEALLOCATE PREPARE etat5;
END;
$

SELECT @vs_chaine5$
SELECT * FROM Avion$
CALL bdsoutou.sousProg()$
SELECT * FROM Avion$

/* INSERT */

SET @vs_chaine = 'INSERT INTO Avion VALUES(?,?,?,?)'$
SET @vs_immat   = 'F-JUMB'$
SET @vs_typa =  'B747'$
SET @vs_heure = 900.50$
SET @vs_comp = 'SING'$

DROP PROCEDURE IF EXISTS bdsoutou.sousProg$
CREATE PROCEDURE bdsoutou.sousProg()
BEGIN
 PREPARE etat FROM @vs_chaine;
 EXECUTE etat USING @vs_immat,@vs_typa ,@vs_heure ,@vs_comp; 
 DEALLOCATE PREPARE etat;
END;
$

SELECT @vs_chaine$
SELECT * FROM Avion$
CALL bdsoutou.sousProg()$
SELECT * FROM Avion$


/* SIGNAL limitation */


DROP PROCEDURE  IF EXISTS bdsoutou.sousProg$
CREATE PROCEDURE bdsoutou.sousProg()
BEGIN
 PREPARE etat FROM 'SIGNAL SQLSTATE "45000" 
      SET MESSAGE_TEXT="Pilote trop peu experimente.",
          MYSQL_ERRNO = 9001';
 EXECUTE etat; 
 DEALLOCATE PREPARE etat;
END;
$

CALL bdsoutou.sousProg()$

/* INSERT2 limite nom de table */

SET @vs_chaine = 'INSERT INTO ? VALUES(''F-FRTY'',?,?,?)'$

SET @vs_table =  'Avion'$
SET @vs_typa  =  'B747'$
SET @vs_heure = 900.50$
SET @vs_comp  = 'SING'$

DROP PROCEDURE  IF EXISTS bdsoutou.sousProg$
CREATE PROCEDURE bdsoutou.sousProg()
BEGIN
 PREPARE etat FROM @vs_chaine;
 EXECUTE etat USING @vs_table,@vs_typa ,@vs_heure ,@vs_comp; 
 DEALLOCATE PREPARE etat;
END;
$

SELECT @vs_chaine$
SELECT * FROM Avion$
CALL bdsoutou.sousProg()$

/* 
ERROR 1064 (42000): You have an error in your SQL syntax; check the manual that
corresponds to your MySQL server version for the right syntax to use near '? VAL
UES('F-FRTY',?,?,?)' at line 1 
*/

/* limite nom de table */

SET @vs_chaine4 = 'SELECT ''?'' FROM Avion WHERE nbHVol = ?' $
SET @vs_col  = 'immat' $
SET @vs_nbhVol  = 1000 $

DROP PROCEDURE  IF EXISTS bdsoutou.sousProg$
CREATE PROCEDURE bdsoutou.sousProg()
BEGIN
 PREPARE etat4 FROM @vs_chaine4 ;
 EXECUTE etat4 USING @vs_col,@vs_nbhVol;
 DROP PREPARE etat4 ;
END;
$

CALL bdsoutou.sousProg()$
/* ERROR 1210 (HY000): Incorrect arguments to EXECUTE */

/* CREATE TABLE avec CONCAT */

DROP PROCEDURE IF EXISTS  bdsoutou.sousProg$
CREATE PROCEDURE bdsoutou.sousProg(IN v_param1 VARCHAR(10), IN v_param2 VARCHAR(10))
BEGIN
  SET @vs_chaine := CONCAT('CREATE TABLE IF NOT EXISTS bdsoutou.',
               v_param1,' (immat CHAR(4), ', v_param2, ' INT)');
SELECT @vs_chaine;
   PREPARE etat FROM @vs_chaine;
   EXECUTE etat;
   DEALLOCATE PREPARE etat;
END;
$

CALL bdsoutou.sousProg('Helico','turbine')$
DESCRIBE bdsoutou.Helico $

/* -SELECT  avec CONCAT et ? */

DROP PROCEDURE  IF EXISTS bdsoutou.sousProg$
CREATE PROCEDURE bdsoutou.sousProg
(IN v_param1 CHAR(6), IN v_param2 CHAR(6),
 IN v_param3 CHAR(5), IN v_param4 CHAR(5))
BEGIN
  SET @vs_immat  := 'F-GLFS';
  SET @vs_chaine := CONCAT('SELECT ',v_param1,',',v_param2,
                   ' FROM bdsoutou.',v_param3,' WHERE ',v_param4,'=?');
SELECT @vs_chaine;
   PREPARE etat FROM @vs_chaine;
   EXECUTE etat USING @vs_immat;
   DEALLOCATE PREPARE etat;
END;
$

CALL bdsoutou.sousProg('typeAv','nbHVol','Avion','immat')$

/* parametres de retour : prix avion : fct du nbh vol d'un avion : */

CREATE PROCEDURE proc_prix_avion
 (IN    v_immat VARCHAR(6),
  INOUT v_prix  DECIMAL(8,2),
  OUT   v_typa  CHAR(8))
BEGIN
  DECLARE v_nbh DECIMAL(7,2);
  SELECT nbHVol,typeAv INTO v_nbh, v_typa
         FROM Avion WHERE immat=v_immat;
  # Set value of OUT parameter
  IF (v_typa='B747') THEN 
   SET v_prix=v_prix+v_nbh*10.5;
  ELSE
   SET v_prix=(v_prix*0.9)+v_nbh*15;
  END IF;
END;
$

SET @prixbase = 1000$
SET @immat    = 'F-JUMB'$
SET @type_av  = ''$
PREPARE etat FROM 'CALL proc_prix_avion(?,?,?)'$
EXECUTE etat USING @immat,@prixbase,@type_av$  
SELECT @type_av,@prixbase$

/* avant 5.5.3 */

SET @prixbase = 1000$
SET @immat    = 'F-JUMB'$
SET @type_av  = ''$
PREPARE etat  FROM 'CALL proc_prix_avion(@immat,@prixbase,@type_av)'$
EXECUTE etat $
SELECT @type_av,@prixbase$

delimiter ;