/*  XML */

/* pas de prologue ni de namespace */

SET @var_xml = 
 '<compagnie>
  <comp>AB</comp>
  <pilotes>
    <pilote brevet="PL-1">
      <nom>C. Sigaudes</nom>
      <salaire>4000</salaire>
  </pilote>
    <pilote brevet="PL-2">
      <nom>P. Filloux</nom>
      <salaire>5000</salaire>
    </pilote>
  </pilotes>
  <nomComp>Air Blagnac</nomComp>
</compagnie>';

/* ExtractValue  */

SELECT ExtractValue(@var_xml, '/compagnie/comp');

SELECT ExtractValue(@var_xml, '/compagnie/pilotes/pilote[1]/nom');

SET @i =1, @j = 2, @k = 3;

SELECT ExtractValue(@var_xml,'/compagnie/pilotes/pilote[$@j]/@brevet');

SELECT ExtractValue(@var_xml,'/compagnie/pilotes/pilote[1]/nom | /compagnie/pilotes/pilote[2]/nom');

SELECT ExtractValue(@var_xml,'/compagnie/pilotes/pilote[nom=''P. Filloux'']/salaire');

SELECT ExtractValue(@var_xml,'/compagnie/pilotes/pilote[salaire<4500]/nom');

SELECT ExtractValue(@var_xml,'sum(/compagnie/pilotes/pilote/salaire)');

SELECT ExtractValue(@var_xml,'sum(/compagnie/pilotes/pilote/salaire) div count(/compagnie/pilotes/pilote)');

SELECT ExtractValue(@var_xml,'/compagnie/pilotes/pilote[salaire>4800 and contains(nom,''P.'')]/nom');

/* Dans une procdure */

DELIMITER $

DROP PROCEDURE proc_XML_test $
CREATE PROCEDURE proc_XML_test ()
BEGIN
DECLARE i INT DEFAULT 1;
DECLARE xml VARCHAR(500) DEFAULT 
'<compagnie>
  <comp>AB</comp>
  <pilotes>
    <pilote brevet="PL-1">
      <nom>C. Sigaudes</nom>
      <salaire>4000</salaire>
  </pilote>
    <pilote brevet="PL-2">
      <nom>P. Filloux</nom>
      <salaire>5000</salaire>
    </pilote>
  </pilotes>
  <nomComp>Air Blagnac</nomComp>
</compagnie>';
WHILE i < 2 DO
  SELECT ExtractValue(xml,'/compagnie/pilotes/pilote/nom[$i]');
  SET i = i+1;
END WHILE;
END $

DELIMITER ;
CALL proc_XML_test;

/* UpdateXML */

SELECT UpdateXML(@var_xml, 
    '/compagnie', 
    '<resultat>C\'est la crise...</resultat>') AS xml_1;

SELECT UpdateXML(@var_xml, 
    '/compagnie/pilotes/pilote[1]/nom', 
    '<remplace_par>D. Daurat</remplace_par>') AS xml_2;

SELECT UpdateXML(@var_xml, 
    '/compagnie/pilotes/pilote[1]', 
    '<remplace_par>D. Daurat</remplace_par>') AS xml_3;

SELECT UpdateXML(@var_xml, 
    '/compagnie/nomComp', 
    '<nomComp>JJ-Mercier Airlines</nomComp>') AS xml_4;

/* RAZ */

SET @var_xml = 
 '<compagnie>
  <comp>AB</comp>
  <pilotes>
    <pilote brevet="PL-1">
      <nom>C. Sigaudes</nom>
      <salaire>4000</salaire>
  </pilote>
    <pilote brevet="PL-2">
      <nom>P. Filloux</nom>
      <salaire>5000</salaire>
    </pilote>
  </pilotes>
  <nomComp>Air Blagnac</nomComp>
</compagnie>';

/* rcrire tout un noeud pour en ajouter un... */

/* pas possible de travailler avec un bloc anonyme : proc */

DELIMITER $

DROP PROCEDURE proc_XML_test $

CREATE PROCEDURE proc_XML_test ()
BEGIN
 SELECT UpdateXML(@var_xml, 
  '/compagnie/pilotes/pilote[2]', 
  '<pilote brevet="PL-2">
    <nom>P. Filloux</nom>
    <salaire>5000</salaire>
   </pilote>
   <pilote brevet="PL-3">
     <nom>A. Rami</nom>
     <salaire>5400</salaire>
   </pilote>') 
  INTO @var_xml;
 SELECT @var_xml;
END $

DELIMITER ;
CALL proc_XML_test;

/* modifier le 2eme pilote */
/* rcrire tout le noeud pour modif un champ... */

DELIMITER $

DROP PROCEDURE proc_XML_test $
CREATE PROCEDURE proc_XML_test ()
BEGIN
 SELECT UpdateXML(@var_xml, 
  '/compagnie/pilotes/pilote[2]', 
  '<pilote brevet="PL-2new">
      <nom>P. Filloux</nom>
      <salaire>5000</salaire>
   </pilote>') 
  INTO @var_xml;
 SELECT @var_xml;
END $

DELIMITER ;
CALL proc_XML_test;

/* rcrire le fichier */

SELECT @var_xml 
  INTO OUTFILE 'C:\\Donnees\\dev\\xml-mysql\\sortie.xml';

/* suppression du 2eme pilote */

DELIMITER $

DROP PROCEDURE proc_XML_test $
CREATE PROCEDURE proc_XML_test ()
BEGIN
 SELECT UpdateXML(@var_xml,
        '/compagnie/pilotes/pilote[2]','')
  INTO @var_xml;
 SELECT @var_xml;
END $

DELIMITER ;
CALL proc_XML_test;


/* mauvais chemins */

SELECT UpdateXML(@var_xml, 
'/pilotes/pilote', 
'<resultat>D. Daurat</resultat>') AS xml_7;

SELECT UpdateXML(@var_xml, 
'/compagnie/pilote', 
'<resultat>D. Daurat</resultat>') AS xml_8;

SELECT UpdateXML(@var_xml, 
'/compagnie/pilotes/pilote[4]', 
'<resultat>D. Daurat</resultat>') AS xml_9;

SELECT UpdateXML(@var_xml, 
'//pilote', 
'<resultat>D. Daurat</resultat>') AS xml_10;

SELECT UpdateXML(@var_xml, 
'//nom', 
'<resultat>D. Daurat</resultat>') AS xml_11;

SELECT UpdateXML(@var_xml, 
'//@brevet', 
'<resultat>D. Daurat</resultat>') AS xml_11;


/* Erreurs */

SELECT ExtractValue(
 '<pilote">
      <nom>C. Sigaudes</nom>
      <salaire>4000</salaire>
  </pilote>','/&brevet');

SELECT UpdateXML(
'<pilote">
      <nom>C. Sigaudes</nom>
      <salaire>4000</salaire>
  </pilote>', 
  '/&brevet', 
  '<resultat>D. Daurat</resultat>');

/* warnings */

SELECT ExtractValue(
 '<pilote>
      <nom>C. Sigaudes</nom>
  </pilote></fin>','//nom');
SHOW WARNINGS;

SELECT UpdateXML(
'<pilote>
      <nom>C. Sigaudes</nom>
  </pilote></fin>', 
  '/pilote/nom', 
  '<resultat>D. Daurat</resultat>');
SHOW WARNINGS;


SELECT UpdateXML(
'<pilote>
      <nom>C. Sigaudes</nom>
  </pilote>', 
  '/pilote/nom', 
  '<resultat>D. Daurat</resultat></fin>');
SHOW WARNINGS;


/* Limitations */

SELECT ExtractValue(
'<compagnie>
  <pilotes>les noms suivent
   <pilote>C. Sigaudes</pilote>
   <pilote>P. Filloux</pilote>
  </pilotes>
 </compagnie>'
,'/compagnie/pilotes') AS contenu_pilotes;

SELECT ExtractValue(
'<compagnie>
  <pilotes>les noms suivent
   <pilote>C. Sigaudes</pilote>
   <pilote>P. Filloux</pilote>
   <pilote><nom>B. Meleton</nom></pilote>
  </pilotes>
 </compagnie>'
,'//pilote') AS contenu_pilote;

/* Dans une procdure */

DELIMITER $

DROP PROCEDURE proc_XML_test $
CREATE PROCEDURE proc_XML_test ()
BEGIN
DECLARE i INT DEFAULT 1;
DECLARE var_xml VARCHAR(500) DEFAULT 
'<compagnie>
  <pilotes>les noms suivent
   <pilote>C. Sigaudes</pilote>
   <pilote>P. Filloux</pilote>
   <pilote><nom>B. Meleton</nom></pilote>
  </pilotes>
 </compagnie>';
WHILE i < 3 DO
  SELECT ExtractValue(var_xml,'/compagnie/pilotes/pilote[$i]');
  SET i = i+1;
END WHILE;
END $

DELIMITER ;
CALL proc_XML_test;

/* aucun fragment ne convient */

SELECT ExtractValue(
 '<compagnie>
     <pilotes></pilotes>
  </compagnie>'
 ,'/compagnie/pilotes/pilote');

/* sans count */

SELECT ExtractValue(
'<compagnie>
   <pilotes>
     <pilote/>
     <pilote/>
   </pilotes>
 </compagnie>'
,'/compagnie/pilotes/pilote');

/* avec count */

SELECT ExtractValue(
'<compagnie>
  <pilotes>
     <pilote/>
     <pilote/>
  </pilotes>
 </compagnie>'
,'count(/compagnie/pilotes/pilote)');

/* pas de verif en sortie */

/* RAZ */

SET @var_xml = 
 '<compagnie>
  <comp>AB</comp>
  <pilotes>
    <pilote brevet="PL-1">
      <nom>C. Sigaudes</nom>
      <salaire>4000</salaire>
  </pilote>
    <pilote brevet="PL-2">
      <nom>P. Filloux</nom>
      <salaire>5000</salaire>
    </pilote>
  </pilotes>
  <nomComp>Air Blagnac</nomComp>
</compagnie>';

SELECT UpdateXML(@var_xml,
  '/compagnie', 
  '<racine>
      <nimporte>hein?</quoi>') AS xml_pb;

SELECT UpdateXML(@var_xml,
  'compagnie+rien', 
  '<racine>
      <nimporte>hein?</quoi>') AS xml_pb;

/* pilotes de noms distincts */

SELECT ExtractValue(@var_xml,
 '/compagnie/pilotes/pilote[not(nom=preceding-sibling::pilote/nom)]/nom');

/* entits */

SELECT UpdateXML(@var_xml, '/compagnie', '<racine>C &apos; est la crise...</racine>') AS xml_1;

/* */
SELECT ExtractValue(@var_xml,
'/compagnie/pilotes/pilote/salaire[number()<4500]');

/*  fait arrter le service SGBD 5.1.41 et 5.5. beta ... */

/* LOAD XML */

CREATE TABLE tab_avions_xml 
   (immat    CHAR(6) NOT NULL PRIMARY KEY,
    cap      SMALLINT NOT NULL,
    typeav   VARCHAR(20) NOT NULL,
    creation TIMESTAMP);

LOAD XML LOCAL INFILE 'C:\\Donnees\\dev\\xml-mysql\\avions.xml'
      REPLACE INTO TABLE tab_avions_xml
      ROWS IDENTIFIED BY '<avi>';

SELECT * FROM tab_avions_xml;

/* 2 eme format */

DELETE FROM tab_avions_xml ;

LOAD XML LOCAL INFILE 'C:\\Donnees\\dev\\xml-mysql\\avions2.xml'
      REPLACE INTO TABLE tab_avions_xml
      ROWS IDENTIFIED BY '<avi>';

SELECT * FROM tab_avions_xml;

/* 3 eme format */

DELETE FROM tab_avions_xml ;

LOAD XML LOCAL INFILE 'C:\\Donnees\\dev\\xml-mysql\\avions3.xml'
      REPLACE INTO TABLE tab_avions_xml
      ROWS IDENTIFIED BY '<avi>';

SELECT * FROM tab_avions_xml;


/* LOAD XML */

CREATE TABLE tab_avions_xml 
   (immat    CHAR(6) NOT NULL PRIMARY KEY,
    cap      SMALLINT NOT NULL,
    typeav   VARCHAR(20) NOT NULL,
    creation TIMESTAMP);

LOAD XML LOCAL INFILE 'C:\\Donnees\\dev\\xml-mysql\\avions.xml'
      REPLACE INTO TABLE tab_avions_xml
      ROWS IDENTIFIED BY '<avi>';

SELECT * FROM tab_avions_xml;


/* variables */

CREATE TABLE tab_avions_xml_2
   (typeav VARCHAR(20) NOT NULL,
    immat  CHAR(6) NOT NULL PRIMARY KEY,
    cap    SMALLINT NOT NULL);

LOAD XML LOCAL INFILE 'C:\\Donnees\\dev\\xml-mysql\\avions.xml'
      REPLACE INTO TABLE tab_avions_xml_2
      ROWS IDENTIFIED BY '<avi>'
      (typeav, immat, cap);

SELECT * FROM tab_avions_xml_2;

CREATE TABLE tab_avions_xml_3
   (immat    CHAR(6) NOT NULL PRIMARY KEY,
    cap      DECIMAL,
    typeav   VARCHAR(20) NOT NULL,
    jour   DATE);

LOAD XML LOCAL 
      INFILE 'C:\\Donnees\\dev\\xml-mysql\\avions.xml'
      REPLACE INTO TABLE tab_avions_xml_3
      ROWS IDENTIFIED BY '<avi>'
      (immat, cap, typeav)
      SET jour=SYSDATE(), cap=cap*1.2;

SELECT * FROM tab_avions_xml_3;

LOAD XML LOCAL 
      INFILE 'C:\\Donnees\\dev\\xml-mysql\\avions.xml'
      REPLACE INTO TABLE tab_avions_xml_2
      ROWS IDENTIFIED BY '<avi>'
      SET cap = (SELECT MAX(cap) 
                FROM tab_avions_xml WHERE typeav='A320');

SELECT * FROM tab_avions_xml_2;

LOAD XML LOCAL 
      INFILE 'C:\\Donnees\\dev\\xml-mysql\\avions.xml'
      REPLACE INTO TABLE tab_avions_xml_3
      ROWS IDENTIFIED BY '<avi>'
      (immat, @var_cap, typeav, @var_date);

SELECT * FROM tab_avions_xml_3;

CREATE TABLE tab_avions_xml_4
   (immat    CHAR(6) NOT NULL PRIMARY KEY,
    typeav   VARCHAR(20) NOT NULL,
    couleur  VARCHAR(30),
    nbHVol   DECIMAL,
    jour     DATE);

LOAD XML LOCAL 
      INFILE 'C:\\Donnees\\dev\\xml-mysql\\avions.xml'
      REPLACE INTO TABLE tab_avions_xml_4
      ROWS IDENTIFIED BY '<avi>';

SELECT * FROM tab_avions_xml_4;

/* sous l'OS */

quit;

/* -e Execute the statement and quit : obligatoire */

mysql --user=soutou --host=localhost --password=soutou --database=bdsoutou --xml -e "SELECT immat,typeav,creation,cap FROM tab_avions_xml WHERE cap>100" > C:\Donnees\dev\xml-mysql\avions-dump.xml

mysql --user=soutou --host=localhost --password=soutou --database=bdsoutou --xml -e "SELECT immat,typeav,creation,cap FROM tab_avions_xml WHERE cap>100" > C:\Donnees\dev\xml-mysql\avions-dump2.xml

mysql --user=soutou --host=localhost --password=soutou --database=bdsoutou

DROP TABLE tab_avions_xml_4;
DROP TABLE tab_avions_xml_3;
DROP TABLE tab_avions_xml_2;
DROP TABLE tab_avions_xml;


/* LOAD XML pas autoris dans les sp, eror 1314 */
/*
DELIMITER $
SET @var_cap=10$
SET @var_date=SYSDATE()$
DROP PROCEDURE charg_xml$
CREATE PROCEDURE charg_xml()
BEGIN
LOAD XML LOCAL 
      INFILE 'C:\\Donnees\\dev\\xml-mysql\\avions.xml'
      REPLACE INTO TABLE tab_avions_xml_3
      ROWS IDENTIFIED BY '<avi>'
      (immat, @var_cap, typeav, @var_date);
END;
$
DELIMITER ;
CALL charg_xml();
SELECT * FROM tab_avions_xml_3;
*/
