
DROP   DATABASE bd_json;
CREATE DATABASE bd_json;

-- collection  part

CREATE TABLE bd_json.tab_vol_json
  (_id    VARCHAR(32) GENERATED ALWAYS AS 
                     (JSON_UNQUOTE(JSON_EXTRACT(doc, '$._id'))) 
          STORED PRIMARY KEY,
   doc    JSON)
ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- dans mysqlsh
-- connexion root sur la base bd_json

-- cd C:\Program Files\MySQL\MySQL Server X.X\bin

mysqlsh --uri=root@localhost --schema=bd_json

db.getTables()
db.getCollections()

// mthodes CRUD

db.tab_vol_json.add(
 {  "_id" : "FE345_90",
    "num_vol" :"AF6143",
    "date_vol" :"2016-07-19",
   "desc_vol" :
   {"porte" : "20A",
    "plan_vol" : {
     "depart" : "21:45",
     "parking" : "3R2",
     "SID" : "AGN-2W",
     "STAR" : "TOU-5T",
     "arrivee" : null},
   "sieges" : 
    [{"prenom" : "Guy",
      "nom" :    "Blanchet",
      "siege" :  "15A"},
     {"prenom" : "Gerard",
      "nom" :    "Diffis",
      "siege" :  "15B"},
     {"prenom" : "Victor",
      "nom" :    "Ferrage",
      "siege" :  "15C"}]
     }
  } )

db.tab_vol_json.add(
 {  "_id" : "FE345_92",
    "num_vol" :"AF6146",
    "date_vol" :"2016-07-19",
   "desc_vol" :
   {"porte" : "20A",
    "plan_vol" : {
     "depart" : "21:55",
     "parking" : "3R6",
     "SID" : "AGN-2W",
     "STAR" : "TOU-5T",
     "arrivee" : null},
   "sieges" : 
    [{"prenom" : "Guy",
      "nom" :    "Blanchet",
      "siege" :  "2A"},
     {"prenom" : "Gerard",
      "nom" :    "Diffis",
      "siege" :  "3B"},
     {"prenom" : "Victor",
      "nom" :    "Ferrage",
      "siege" :  "4C"}]
     }
  } )

// UUID gnr si _id absent

db.tab_vol_json.add(
 {  "num_vol" :"AF6143",
    "date_vol" :"2016-07-20",
   "desc_vol" :   {"porte" : "20B",
    "plan_vol" : {
     "depart" : "21:40",
     "parking" : "3R5",
     "SID" : "AGN-2T",
     "STAR" : "TOU-5L",
     "arrivee" : null},
   "sieges" : 
    [{"prenom" : "Guy",
      "nom" :    "Blanchet",
      "siege" :  "1A"},
     {"prenom" : "Gerard",
      "nom" :    "Diffis",
      "siege" :  "1B"},
     {"prenom" : "Victor",
      "nom" :    "Ferrage",
      "siege" :  "1C"}]  }   
  } )

// liste de documents

db.tab_vol_json.add(
 [ { "num_vol" :"AF6143",
    "date_vol" :"2016-07-21",
    "desc_vol" : null } 
 , 
  { "num_vol" :"AF6143",
    "date_vol" :"2016-07-22",
    "desc_vol" : null } 
 ])

// remove

-- un en particulier
db.tab_vol_json.remove("_id = 'FE345_90'")
-- un sur un autre test 
db.tab_vol_json.remove("num_vol = 'AF6143'")
--
db.tab_vol_json.remove().sort(["num_vol ASC"]).limit(3)
--tout
db.tab_vol_json.remove()

// modify

db.tab_vol_json.modify("_id = 'FE345_90'").
               set("num_vol", "AF6147" )
-- notation pointe pour se ballader
db.tab_vol_json.modify("_id = 'FE345_90'").
               set("desc_vol.porte", "20G" )
-- pas possible avec null
db.tab_vol_json.modify("_id = 'FE345_90'").
               set("desc_vol.plan_vol.parking", null)
--
db.tab_vol_json.modify("_id = 'FE345_90'").
               set("desc_vol.plan_vol", 
                   {"depart" : "21:55",
                    "parking" : "3R2",
                    "SID" : "AGN-2W",
                    "STAR" : "TOU-5T",
                    "arrivee" : "23:05"} )

// unset pour supprimer un champ
db.tab_vol_json.modify("_id = 'FE345_90'").
               unset("desc_vol.plan_vol.parking")

// array
db.tab_vol_json.modify("_id = 'FE345_90'").
                arrayAppend("$.desc_vol.sieges", 
                           {"prenom" : "Henri",
                            "nom"    : "Fayat",
                            "siege"  : "15D"})
--
db.tab_vol_json.modify("_id = 'FE345_90'").
                arrayDelete("$.desc_vol.sieges[0]")
--
db.tab_vol_json.modify("_id = 'FE345_90'").
                arrayInsert("$.desc_vol.sieges[0]",
                           {"prenom" : "Guy",
                            "nom"    : "Blanchet",
                           "siege"  : "15A"})

// find

-- un id
db.tab_vol_json.find("_id = 'FE345_90'")
-- autre prdicat 
db.tab_vol_json.find("num_vol = 'AF6143' AND date_vol = '2016-07-19'")
-- notation pointe
db.tab_vol_json.find("num_vol = 'AF6143' AND desc_vol.porte='20B'")
-- avec bind
db.tab_vol_json.find("date_vol = :dvol").bind("dvol", "2016-07-19")

-- fiels pour extraire des champs (conseill pour viter l'injection de code)
db.tab_vol_json.find("date_vol = :dvol").
                fields(["desc_vol.porte","desc_vol.plan_vol.depart"]).
                bind("dvol", "2016-07-19")
-- fields pour un lment du tableau
db.tab_vol_json.find("date_vol = :dvol").
                fields(["desc_vol.sieges[0].prenom","desc_vol.sieges[0].nom"]).
                bind("dvol", "2016-07-19")
-- tout le tableau
db.tab_vol_json.find("date_vol = :dvol").
                fields(["desc_vol.sieges"]).
                bind("dvol", "2016-07-19")

// tri
db.tab_vol_json.find("num_vol = 'AF6143'").
                fields(["date_vol", "desc_vol.porte","desc_vol.plan_vol.depart"]).
                sort(["date_vol ASC"]).limit(2)

// indexation
db.tab_vol_json.dropIndex("idx_porte").execute()
db.tab_vol_json.dropIndex("idx_porte").execute()
db.tab_vol_json.createIndex("idx_porte").
                field("desc_vol.porte", "TEXT(3)", false).execute()

// unique
var mysqlx=require('mysqlx');
db.tab_vol_json.createIndex("idx_numvol", mysqlx.IndexType.UNIQUE).
                field("num_vol", "TEXT(6)", false).execute()
/*
TypeError: Cannot read property 'UNIQUE' of undefined at (shell):1:58
in db.tab_vol_json.createIndex("idx_numvol", mysqlx.IndexType.UNIQUE).
*/

// METHODES POUR LES DOC JSON

-- dans mysql >

DROP TABLE bd_json.tab_vol_json2;

CREATE TABLE bd_json.tab_vol_json2
(id_vol INTEGER AUTO_INCREMENT PRIMARY KEY,
 doc    JSON, 
 modif  DATETIME
 ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

 
-- dans mysqlh
 
// insertions
-- tout le JSON doit tre sur 1 ligne pas de CR !
db.tab_vol_json2.insert( "doc","modif" ).
  values(
   '{"num_vol":"AF6143","date_vol":"2016-09-09","desc_vol":{"porte":"20A","plan_vol":{"depart": "21:45","parking": "13R","SID": "AGN-2S","STAR":"TOU-5T","arrivee": null},"sieges":[{"prenom": "Guy","nom":"Blanchet","siege":"10A"},{"prenom":"Gerard","nom":"Diffis","siege":"10B"}, {"prenom":"Victor","nom":"Ferrage","siege":"10C"}]}}',
    '2016-09-09 19:30:00')
db.tab_vol_json2.insert( "doc","modif" ).
  values(
   '{"num_vol":"AF6144","date_vol":"2016-09-09","desc_vol":{"porte":"20B","plan_vol":{"depart": "22:15","parking": "13R","SID": "AGN-2S","STAR":"TOU-5T","arrivee": null},"sieges":null}}',
    '2016-09-09 19:50:00')
db.tab_vol_json2.insert( "doc","modif" ).
  values(
   '{"num_vol":"AF6148","date_vol":"2016-09-09","desc_vol":null,"sieges":null}',
    '2016-09-09 20:00:00')
/*
pas de fonction SQL 
      ...ReferenceError: SYSDATE is not defined at (shell):4:4in     SYSDATE())
*/

-- quivalent command line
INSERT INTO bd_json.tab_vol_json2(doc,modif)
VALUES(
   '{"num_vol":"AF6143","date_vol":"2016-08-25",
     "desc_vol":{"porte":"20A",
          "plan_vol":{"depart": "21:45","parking": "13R",
              "SID": "AGN-2S","STAR":"TOU-5T","arrivee": null},
     "sieges":[{"prenom": "Guy","nom":"Blanchet","siege":"10A"},
               {"prenom":"Gerard","nom":"Diffis","siege":"10B"},
               {"prenom":"Victor","nom":"Ferrage","siege":"10C"}]}}',
    SYSDATE());

// update
db.tab_vol_json2.update().
        set("doc", "null").
        where("id_vol=3")
db.tab_vol_json2.update().
        set("modif", "2016-09-09 19:35:00").
        where("id_vol=1")

// modif d'un json en entier pas d'accs  un lt
db.tab_vol_json2.update().
        set("doc", '{"num_vol":"AF6148","date_vol":"2016-09-10","desc_vol":null}').
        where("id_vol=3")

// avec bind ?
db.tab_vol_json2.update().
        set("modif" ,":dvol").
        where("id_vol=3").
         bind("dvol", "2016-09-09 19:35:00")
/*
LogicError: TableUpdate.bind: Unable to bind value for unexisting placeholder: dvol at (shell):4:9
in          bind("dvol", "2016-09-09 19:35:00")
*/

-- 
// select
//tout
db.tab_vol_json2.select()
// colonnes
db.tab_vol_json2.select(["id_vol","modif"])
// json dans son intgralit
db.tab_vol_json2.select(["doc"]).
                 where("id_vol = :idvol AND modif = :dvol").
                 bind("idvol",1).bind("dvol","2016-09-09 19:35:00")
// notation pointe pas possible de rentrer dans un doc json
db.tab_vol_json2.select(["doc.date_vol", "doc.num_vol"])
// "num_vol = 'AF6143' AND desc_vol.porte='20B'" pas possible

// tri
db.tab_vol_json2.select(["id_vol","modif"]).
                 orderBy(["modif desc"]).limit(2)

SELECT id_vol,modif
FROM   bd_json.tab_vol_json2;

// delete
db.tab_vol_json2.delete().
        where("id_vol = 1 AND modif = '2016-09-09 19:35:00'")

-- erreur 3140, json mal form
INSERT INTO bd_json.tab_vol_json (details_vol) VALUES
 ('{"date_vol":"AF6143",
    "num_vol":"2016-07-19",
   "desc_vol":');

-- FONCTIONS SQL POUR JSON
-- dans mysql>


DROP TABLE bd_json.tab_vol_json3;

CREATE TABLE bd_json.tab_vol_json3
(id   SMALLINT AUTO_INCREMENT PRIMARY KEY,
 utilisateur VARCHAR(30),
 doc         JSON, 
 doc_chaine  VARCHAR(500),
 modif       DATETIME
 ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO bd_json.tab_vol_json3 
(utilisateur, doc, modif) VALUES
 ('Brouard', '{"date_vol":"2016-07-18","num_vol":AF6140"}', SYSDATE());

INSERT INTO bd_json.tab_vol_json3 
(utilisateur, doc_chaine, modif) VALUES
 ('Brouard', '{"date_vol":"2016-07-18","num_vol":AF6140"}', SYSDATE());
  
INSERT INTO bd_json.tab_vol_json3 
(utilisateur, doc, modif) VALUES
 ('Brouard','{"date_vol":"2016-07-18","num_vol":"AF6141"}', SYSDATE());
  
INSERT INTO bd_json.tab_vol_json3 
(utilisateur, doc, modif) VALUES
 ('Salais',
  '{"_id" : "FE345_90","num_vol" : "AF6143", "date_vol" : "2016-07-19", "sequence" : 345,
   "desc_vol" :
   {"porte" : "20A",
    "plan_vol" : {
     "depart" : "21:45",
     "parking" : "3R2"},
   "sieges" : 
    [{"prenom" : "Guy",
      "nom" :    "Blanchet",
      "siege" :  "15A"},
     {"prenom" : "Gerard",
      "nom" :    "Diffis",
      "siege" :  "15B"},
     {"prenom" : "Victor",
      "nom" :    "Ferrage",
      "siege" :  "15C"},
     {"prenom" : "Henri",
      "nom" :    "Alquie",
      "siege" :  "13C"}]
     } 
   }', DATE_ADD(SYSDATE(),INTERVAL 1 DAY));

INSERT INTO bd_json.tab_vol_json3 
(utilisateur, doc, modif) VALUES
 ('Bizoi',
  '{
   "_id" : "FE345_92",
    "num_vol" :"AF6146",
    "date_vol" :"2016-07-19",
    "sequence" : 346,
   "desc_vol" :
   {"porte" : "20A",
    "plan_vol" : {
     "depart" : "21:55",
     "parking" : "3R6"},
   "sieges" : 
    [{"prenom" : "Guy",
      "nom" :    "Blanchet",
      "siege" :  "2A"},
     {"prenom" : "Gerard",
      "nom" :    "Diffis",
      "siege" :  "3B"}]
     }
  }', DATE_ADD(SYSDATE(),INTERVAL 1 DAY));
  
INSERT INTO bd_json.tab_vol_json3 
(utilisateur, doc, modif) VALUES
 ('Salais',
  '{"num_vol" :"AF6143",
    "date_vol" :"2016-07-20",
	"sequence" : 347,
   "desc_vol" :   
   {"porte" : "20B",
    "plan_vol" : {
     "depart" : "21:40",
     "parking" : null},
   "sieges" : 
    [{"prenom" : "Guy",
      "nom" :    "Blanchet",
      "siege" :  "1A"},
     {"prenom" : "Gerard",
      "nom" :    "Diffis",
      "siege" :  "1B"},
     {"prenom" : "Victor",
      "nom" :    "Ferrage",
      "siege" :  "1C"}]}}', 
	  DATE_ADD(SYSDATE(),INTERVAL 2 DAY));

SELECT id,doc,doc_chaine FROM bd_json.tab_vol_json3;	  
	  
 -- gnrer du contenu

SELECT JSON_ARRAY(id, utilisateur, modif)
FROM   bd_json.tab_vol_json3 
WHERE  id BETWEEN 2 AND 4;

SELECT JSON_OBJECT('num_v', id, 'compte', 
                    utilisateur, 'jour', DATE(modif))
FROM   bd_json.tab_vol_json3 
WHERE  utilisateur <> 'Brouard';

SELECT id, JSON_QUOTE(utilisateur) 
FROM   bd_json.tab_vol_json3 
WHERE  id IN (1,3,4);

SELECT JSON_CONTAINS(doc, '"AF6143"' ,'$.num_vol') AS contains_AF6143,
       JSON_CONTAINS(doc, '348' ,'$.sequence') AS contains_sequence_348
FROM   bd_json.tab_vol_json3 
WHERE  utilisateur = 'Salais'
AND    id = 3;

SELECT JSON_CONTAINS(doc, '"20B"' ,'$.desc_vol.porte')
FROM   bd_json.tab_vol_json3 
WHERE  utilisateur = 'Bizoi';

SELECT id, utilisateur, DATE(modif)
FROM   bd_json.tab_vol_json3 
WHERE  JSON_CONTAINS(doc, '"20A"' ,'$.desc_vol.porte') = 1
OR     JSON_CONTAINS(doc, 'null' ,'$.desc_vol.plan_vol.parking')=1
ORDER BY id;

SELECT id, utilisateur, DATE(modif)
FROM   bd_json.tab_vol_json3 
WHERE  JSON_CONTAINS_PATH(doc, 'one' ,'$.desc_vol')=0;

SELECT id, utilisateur, DATE(modif)
FROM   bd_json.tab_vol_json3 
WHERE  JSON_CONTAINS_PATH(doc, 'all' ,'$.desc_vol.porte',
                                      '$.desc_vol.sieges[3].siege')=1;
SELECT 
       JSON_EXTRACT(doc,'$.num_vol','$.date_vol') AS elements_vol,
       JSON_EXTRACT(doc,'$.desc_vol.sieges[*].siege') AS passagers
FROM   bd_json.tab_vol_json3 
WHERE  utilisateur = 'Salais';

SELECT id,
       CONCAT(doc->'$.num_vol',doc->'$.date_vol') AS elt_vol,
	   doc->'$.desc_vol.porte' AS porte
FROM   bd_json.tab_vol_json3 
WHERE  utilisateur = 'Salais' ;

SELECT id,
       JSON_KEYS(doc) AS sous_doc,  
	   JSON_KEYS(doc,'$.desc_vol.plan_vol') AS sous_plan_vol
FROM   bd_json.tab_vol_json3 
WHERE  id IN (1,2,4);

-- MODIFIER DU CONTENU

SELECT id,
       JSON_UNQUOTE(doc->'$.num_vol') AS num_vol,
       JSON_UNQUOTE(doc->'$.date_vol') AS date_vol,
	   JSON_UNQUOTE(doc->'$.desc_vol.sieges[0].siege') AS siege_0
FROM   bd_json.tab_vol_json3 
WHERE  utilisateur = 'Salais';

SELECT id,
       CAST(JSON_UNQUOTE(doc->'$.num_vol') AS CHAR(6)) AS num_vol,
       CAST(JSON_UNQUOTE(doc->'$.date_vol') AS DATE) AS date_vol,
	   CAST(JSON_UNQUOTE(doc->'$.sequence') AS UNSIGNED INTEGER) AS sequence
FROM   bd_json.tab_vol_json3 
WHERE  utilisateur = 'Salais';

-- V8 ->>

SELECT id,
       CAST(doc->>'$.num_vol' AS CHAR(6)) AS num_vol,
       CAST(doc->>'$.date_vol' AS DATE) AS date_vol,
	   CAST(doc->>'$.sequence' AS UNSIGNED INTEGER) AS sequence
FROM   bd_json.tab_vol_json3 
WHERE  utilisateur = 'Salais';

SELECT JSON_INSERT(doc, 
          '$.sequence',344, 
		  '$.desc_vol','{"porte":"14K","plan_vol":{"depart":null,"parking":"3R4"}}')
FROM   bd_json.tab_vol_json3 
WHERE  id = 2;

SELECT id,doc FROM bd_json.tab_vol_json3 WHERE id=2;	

SELECT JSON_INSERT(doc, 
          '$.sequence',344, 
		  '$.desc_vol',JSON_OBJECT('porte','14K',
		                          'plan_vol',JSON_OBJECT('depart',null,
								                         'parking','3R4')))
FROM   bd_json.tab_vol_json3 
WHERE  id = 2;

SELECT id,
       JSON_EXTRACT(doc,'$.desc_vol.sieges') 
FROM bd_json.tab_vol_json3 ;

SELECT JSON_ARRAY_APPEND(
         JSON_EXTRACT(doc,'$.desc_vol.sieges'), 
		 '$',
		 '{"prenom":"Antoine","nom":"Derouin","siege":"5A"}')
FROM   bd_json.tab_vol_json3 
WHERE  id  = 3;

SELECT id,JSON_EXTRACT(doc,'$.desc_vol.sieges[*]')
 FROM bd_json.tab_vol_json3 WHERE id=3;	    
	  
SELECT JSON_ARRAY_APPEND(
         JSON_EXTRACT(doc,'$.desc_vol.sieges'), 
		 '$',
		 JSON_OBJECT('prenom','Antoine','nom','Derouin','siege', '5A'))
FROM   bd_json.tab_vol_json3 
WHERE  id  = 3;

SELECT JSON_ARRAY_INSERT(
         JSON_EXTRACT(doc,'$.desc_vol.sieges'), 
		 '$[0]',
		 JSON_OBJECT('prenom','Antoine','nom','Derouin','siege', '5A'))
FROM   bd_json.tab_vol_json3 
WHERE  id  = 3;

SELECT JSON_MERGE(
			(JSON_OBJECT('num_v', id)), 
			doc) AS merge
FROM   bd_json.tab_vol_json3 
WHERE  id = 2;

SELECT JSON_REMOVE(doc, '$.sieges')
FROM   bd_json.tab_vol_json3 
WHERE  utilisateur = 'Bizoi';

SELECT JSON_REMOVE(doc, '$.sieges','$.desc_vol')
FROM   bd_json.tab_vol_json3 
WHERE  id  = 2;

SELECT JSON_REMOVE(JSON_REMOVE(doc, '$.sieges'),'$.desc_vol')
FROM   bd_json.tab_vol_json3 
WHERE  utilisateur = 'Bizoi';

SELECT id,doc FROM bd_json.tab_vol_json3 WHERE id=2;

SELECT JSON_SET(doc,'$._id', 'FG00_02',  
                    '$.date_vol' , '2016-07-23',
					'$.num_vol' , 'AF5661'
				)
FROM   bd_json.tab_vol_json3 
WHERE  id = 2;

SELECT JSON_REPLACE(doc, '$._id', 'FG450_92',  
                         '$.desc_vol.porte' , '20F',
						 '$.desc_vol.sieges[0].siege' , '12G'
						  )
FROM   bd_json.tab_vol_json3 
WHERE  utilisateur = 'Bizoi';

-- MySQL 8.0.1. JSON_ARRAYAGG() 

SELECT JSON_ARRAYAGG(numvol) 
FROM    bd_json.tab_vol_json3 
WHERE  utilisateur = 'Bizoi';

SELECT JSON_DEPTH('[10, 20, 3, 4]');

SELECT JSON_DEPTH('{ "a":"10"}');

SELECT id,utilisateur,
       JSON_DEPTH(doc) AS profondeur_maxi
FROM   bd_json.tab_vol_json3 
WHERE  utilisateur IN ('Bizoi', 'Brouard')
ORDER BY JSON_DEPTH(doc) DESC;

SELECT id,
       JSON_LENGTH(doc) AS taille,
	   JSON_LENGTH(doc, '$.desc_vol.sieges') AS taille_sieges
FROM   bd_json.tab_vol_json3 
WHERE  id IN (1,2,3);

SELECT id,
       JSON_TYPE(doc) AS type_doc,
	   JSON_TYPE(JSON_EXTRACT(doc, '$.sequence')) AS type_sequence,
	   JSON_TYPE(JSON_EXTRACT(doc, '$.desc_vol')) AS type_desc_vol,
	   JSON_TYPE(JSON_EXTRACT(doc, '$.desc_vol.sieges')) AS type_sieges,
	   JSON_TYPE(JSON_EXTRACT(doc, '$.desc_vol.sieges[0].siege')) AS type_siege
FROM   bd_json.tab_vol_json3 
WHERE  id IN (1,4);

SELECT id, utilisateur,
       JSON_VALID(doc)        AS doc_valide,
	   JSON_VALID(doc_chaine) AS chaine_valide
FROM   bd_json.tab_vol_json3 
WHERE id < 4
ORDER BY id;

-- UPDATE

UPDATE bd_json.tab_vol_json3 
SET doc = 
 (SELECT JSON_REPLACE(doc,  
	'$.desc_vol.sieges',
	JSON_ARRAY_APPEND(
		JSON_EXTRACT(doc,'$.desc_vol.sieges'),
			'$',
			JSON_OBJECT('prenom','Antoine','nom','Derouin','siege','5A')
					)
				)
	),
	doc = (SELECT JSON_REPLACE(doc,'$.date_vol','2016-07-24'))
WHERE  id = 3;

SELECT id,
       JSON_EXTRACT(doc,'$.num_vol','$.date_vol') AS elements_vol,
       JSON_EXTRACT(doc,'$.desc_vol.sieges[*].siege') AS passagers
FROM   bd_json.tab_vol_json3 
WHERE  id = 3;

UPDATE bd_json.tab_vol_json3 
SET doc = CAST('{"date_vol":"2016-07-18","num_vol":"AF6140"}' AS JSON)
WHERE  id = 1;

SELECT id,doc FROM bd_json.tab_vol_json3 WHERE  id = 1;

-- COMPARAISON

SELECT id,
       JSON_EXTRACT(doc, '$.sequence')            AS seq,
       JSON_EXTRACT(doc,'$.num_vol')              AS num_vol,
        JSON_TYPE(doc)                            AS type_doc,
       JSON_EXTRACT(doc,'$.num_vol','$.date_vol') AS elements_vol
FROM   bd_json.tab_vol_json3 
WHERE  id IN (3,4)
AND    JSON_EXTRACT(doc,'$.num_vol') > JSON_EXTRACT(doc, '$.sequence')
AND    JSON_EXTRACT(doc,'$.num_vol','$.date_vol') > JSON_EXTRACT(doc,'$.num_vol')
AND    JSON_EXTRACT(doc,'$.num_vol','$.date_vol') > doc;

--- INDEXATION

ALTER TABLE bd_json.tab_vol_json3 DROP doc_sequence;

ALTER TABLE bd_json.tab_vol_json3 
	ADD doc_sequence INT
	GENERATED ALWAYS AS (JSON_EXTRACT(doc, '$.sequence'));

DROP INDEX index_doc_seq ON bd_json.tab_vol_json3;

CREATE UNIQUE INDEX index_doc_seq
    ON bd_json.tab_vol_json3 (doc_sequence);
 
ALTER TABLE bd_json.tab_vol_json3 
	DROP doc_id;

ALTER TABLE bd_json.tab_vol_json3 
	ADD doc_id VARCHAR(8) 
	GENERATED ALWAYS AS (JSON_UNQUOTE(JSON_EXTRACT(doc, '$._id')));

CREATE UNIQUE INDEX index_doc_id
    ON bd_json.tab_vol_json3 (doc_id);
 
EXPLAIN SELECT id,doc_id,
	       JSON_EXTRACT(doc,'$.num_vol','$.date_vol') AS elements_vol
        FROM   bd_json.tab_vol_json3 WHERE  doc_id = 'FE345_90';
		
