/* exceptions */

delimiter ;

DROP TABLE IF EXISTS bdsoutou.Pilote;

CREATE TABLE bdsoutou.Pilote
	(brevet VARCHAR(6) PRIMARY KEY,
	 nom VARCHAR(20), nbHVol DECIMAL(7,2), comp VARCHAR(4));


INSERT INTO Pilote VALUES ('PL-1', 'Roux', 2450, 'AF');
INSERT INTO Pilote VALUES ('PL-2', 'Peyrard', 900, 'AF');
INSERT INTO Pilote VALUES ('PL-3', 'Mansalier', 1000, 'SING');
INSERT INTO Pilote VALUES ('PL-4', 'Labat', 2450, 'CAST');
INSERT INTO Pilote VALUES ('PL-5', 'Marti', 200, 'AF');
INSERT INTO Pilote VALUES ('PL-6', 'Brulin', 2450, 'SING');


SELECT * FROM bdsoutou.Pilote;


delimiter $


--idem

--avec 1 handler

delimiter $

CREATE PROCEDURE bdsoutou.exception1(IN p_comp VARCHAR(4)) 
BEGIN
 DECLARE flagNOTFOUND BOOLEAN DEFAULT 0;
 DECLARE var1 VARCHAR(20);
 BEGIN
 
    DECLARE EXIT HANDLER FOR NOT FOUND SET flagNOTFOUND :=1;

  SELECT nom INTO var1 FROM Pilote WHERE comp = p_comp;
  SELECT CONCAT('Le seul pilote de la compagnie ',p_comp,' est ',var1) AS 'Resultat procException1';
 END;
 IF flagNOTFOUND THEN
  SELECT CONCAT('Il n''y a pas de pilote pour la compagnie ',p_comp) AS 'Resultat procException1';
 END IF; 
END;
$

CALL bdsoutou.exception1('AF')$

CALL bdsoutou.exception1('RIEN')$

CALL bdsoutou.exception1('CAST')$

/* avec 2 handlers */

CREATE PROCEDURE bdsoutou.exception2(IN p_comp VARCHAR(4)) 
BEGIN
 DECLARE flagNOTFOUND BOOLEAN DEFAULT 0;
 DECLARE flagPlusDun  BOOLEAN DEFAULT 0;
 DECLARE var1 VARCHAR(20);

 BEGIN
   DECLARE EXIT HANDLER FOR 1172      SET flagPlusDun  :=1;
   DECLARE EXIT HANDLER FOR NOT FOUND SET flagNOTFOUND :=1;

  SELECT nom INTO var1 FROM Pilote WHERE comp = p_comp;
  SELECT CONCAT('Le seul pilote de la compagnie ',p_comp,' est ',var1) AS 'Resultat procException1';
 END;

 IF flagNOTFOUND THEN
  SELECT CONCAT('Il n''y a pas de pilote pour la compagnie ',p_comp) AS 'Resultat procException1';
 END IF; 

 IF flagPlusDun  THEN
  SELECT CONCAT('Il y a plusieurs pilotes pour la compagnie ',p_comp) AS 'Resultat procException1';
 END IF; 
END;
$

CALL bdsoutou.exception2('AF')$

CALL bdsoutou.exception2('RIEN')$

CALL bdsoutou.exception2('CAST')$


/* avec 2 handlers et un OTHERS */


CREATE PROCEDURE bdsoutou.exception3 (IN p_comp VARCHAR(4)) 
BEGIN
 DECLARE flagNOTFOUND BOOLEAN DEFAULT 0;
 DECLARE flagPlusDun  BOOLEAN DEFAULT 0;
 DECLARE flagAutre    BOOLEAN DEFAULT 0;

 DECLARE var1 VARCHAR(20);

 BEGIN
   DECLARE EXIT HANDLER FOR 1172         SET flagPlusDun  :=1;
   DECLARE EXIT HANDLER FOR NOT FOUND    SET flagNOTFOUND :=1;
   DECLARE EXIT HANDLER FOR SQLEXCEPTION SET flagAutre :=1;

  SELECT nom INTO var1 FROM Pilote WHERE comp = p_comp;
  SELECT CONCAT('Le seul pilote de la compagnie ',p_comp,' est ',var1) AS 'Resultat procException1';
 END;

 IF flagNOTFOUND THEN
  SELECT CONCAT('Il n''y a pas de pilote pour la compagnie ',p_comp) AS 'Resultat procException1';
 END IF; 

 IF flagPlusDun  THEN
  SELECT CONCAT('Il y a plusieurs pilotes pour la compagnie ',p_comp) AS 'Resultat procException1';
 END IF; 

 IF flagAutre THEN
  SELECT CONCAT('Erreur ',' ??') AS 'Resultat exception3';
 END IF; 
END;
$
       

CALL bdsoutou.exception3('CodeDepassantLaTailleDeBeaucoup')$

CALL bdsoutou.exception3(0123)$

CALL bdsoutou.exception3('AF')$

CALL bdsoutou.exception3('RIEN')$

CALL bdsoutou.exception3('CAST')$


/* CALL dans un handler */

CREATE PROCEDURE bdsoutou.tropdeLignes(IN p_comp VARCHAR(4))
BEGIN
  SELECT CONCAT('Il y a plusieurs pilotes pour la compagnie ',p_comp)
       AS 'Resultat tropdeLignes';
END;
$

CREATE PROCEDURE bdsoutou.pasTrouve(IN p_comp VARCHAR(4)) 
BEGIN
  SELECT CONCAT('Il n''y a pas de pilote pour la compagnie ',p_comp) 
        AS 'Resultat pasTrouve';
END;
$

CREATE PROCEDURE bdsoutou.autreErreur()
BEGIN
  SELECT 'Erreur mais laquelle?' AS 'Resultat autreErreur';
END;
$

CREATE PROCEDURE bdsoutou.exception4 (IN p_comp VARCHAR(4)) 
BEGIN
 DECLARE var1 VARCHAR(20);
 DECLARE EXIT HANDLER FOR 1172         CALL bdsoutou.tropdeLignes(p_comp);
 DECLARE EXIT HANDLER FOR NOT FOUND    CALL bdsoutou.pasTrouve(p_comp);
 DECLARE EXIT HANDLER FOR SQLEXCEPTION CALL bdsoutou.autreErreur();
 SELECT nom INTO var1 FROM Pilote WHERE comp = p_comp;
 SELECT CONCAT('Le seul pilote de la compagnie ',p_comp,' est ',var1) 
        AS 'Resultat procException1';
END;
$

CALL bdsoutou.exception4('RIEN')$

CALL bdsoutou.exception4('AF')$

CALL bdsoutou.exception4('CAST')$