SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='TRADITIONAL';


-- -----------------------------------------------------
-- Table `Service`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `Service` ;

CREATE  TABLE IF NOT EXISTS `Service` (
  `idService` INT NOT NULL ,
  `nomSer` VARCHAR(45) NOT NULL ,
  `budget` DOUBLE NULL ,
  PRIMARY KEY (`idService`) )
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `Client`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `Client` ;

CREATE  TABLE IF NOT EXISTS `Client` (
  `idClient` INT NOT NULL ,
  `nomCli` VARCHAR(45) NULL ,
  `mailCli` VARCHAR(45) NULL ,
  `Service_idService` INT NOT NULL ,
  PRIMARY KEY (`idClient`, `Service_idService`) ,
  INDEX `fk_Client_Service1` (`Service_idService` ASC) ,
  CONSTRAINT `fk_Client_Service1`
    FOREIGN KEY (`Service_idService` )
    REFERENCES `Service` (`idService` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB
COMMENT = 'Les clients';


-- -----------------------------------------------------
-- Table `Commande`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `Commande` ;

CREATE  TABLE IF NOT EXISTS `Commande` (
  `idCommande` INT NOT NULL ,
  `dateCde` DATETIME NOT NULL ,
  `remise` DECIMAL(2,1) NOT NULL ,
  `vers_client` INT NOT NULL ,
  PRIMARY KEY (`idCommande`, `vers_client`) ,
  INDEX (`vers_client` ASC) ,
  CONSTRAINT `cde_cli`
    FOREIGN KEY (`vers_client` )
    REFERENCES `Client` (`idClient` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;



SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;
