import java.sql.*;
import java.util.ArrayList;

public class ExoJDBC {
	public static Connection cx;
	public static ResultSet rs, rs2;
	public static Statement etat;
	public static Statement etatModifiable;
	public static CallableStatement cetat;
	
	public static ArrayList getSalles() 
	{
 		ArrayList tableauRsultat = new ArrayList();
 		try {
 			 etat = cx.createStatement();
			 rs = etat.executeQuery("SELECT * FROM Salle");
			 String [] ligne = null;
			while (rs.next()) {
				ligne = new String[4];
				ligne[0] = rs.getString(1);
				ligne[1] = rs.getString(2);
				ligne[2] = (new Integer(rs.getInt(3))).toString();
				ligne[3] = rs.getString(4);
				tableauRsultat.add(ligne);
				}
			rs.close();
			etat.close();
			}
		catch (SQLException ex) {
    		while (ex != null) {
    			System.out.println ("Statut SQL  : "+ex.getSQLState());
	 			System.out.println ("Message     : "+ex.getMessage());
	 			System.out.println ("Code erreur : "+ex.getErrorCode());
	 			ex = ex.getNextException();
	 			}
			}
		return tableauRsultat;
		}
		
	public static void deleteSalle(int nl) 
	{				
 	try {
 		etatModifiable = cx.createStatement(ResultSet.TYPE_SCROLL_INSENSITIVE,
	  						   ResultSet.CONCUR_UPDATABLE);
		cx.setAutoCommit(false);
		rs2 = etatModifiable.executeQuery("SELECT s.* FROM Salle s");
		if (rs2.absolute(nl)) 
		  {	rs2.deleteRow(); cx.commit();
		 	System.out.println("Salle supprime");} 
		else System.out.println("Dsol, pas de "+ nl +" me salle !");
		rs2.close();
		etatModifiable.close();
     	}
		catch (SQLException ex) {
    		while (ex != null) {
    			System.out.println ("Statut SQL  : "+ex.getSQLState());
	 			System.out.println ("Message     : "+ex.getMessage());
	 			System.out.println ("Code erreur : "+ex.getErrorCode());
	 			ex = ex.getNextException();
	 			}
	 		}
		}
	
	public static int deleteSalleSP(String ns) {
 		int result = 0;
 		try {cetat = cx.prepareCall("{call supprimeSalle(?,?)}");
			 cetat.registerOutParameter(2,java.sql.Types.INTEGER);
			 cetat.setString(1,ns);
			 cetat.execute();
			 result = cetat.getInt(2);
			 cetat.close(); }
		catch (SQLException ex) {
    		while (ex != null) {
    			System.out.println ("Statut SQL  : "+ex.getSQLState());
	 			System.out.println ("Message     : "+ex.getMessage());
	 			System.out.println ("Code erreur : "+ex.getErrorCode());
	 			ex = ex.getNextException(); } }
	 	return result;}
	
	public static void main(String args[]) throws SQLException, Exception
	{
	try {
     System.out.println("Initialisation de la connexion");
	 Class.forName("com.mysql.jdbc.Driver").newInstance();
	  } catch (ClassNotFoundException ex)
             { System.out.println ("Problme au chargement"+ex.toString()); }
    try 
     {
     cx = DriverManager.getConnection("jdbc:mysql://localhost/bdsoutou?user=soutou&password=iut");
	
	ArrayList lignes = getSalles();
	System.out.println("Liste des salles :\n");
	System.out.println("nSalle\tnomSalle  \tnbPoste\tindIP");
	System.out.println("------------------------------------------");
	String[] lig;
	for (int i=0;i<lignes.size();i++) 
	{	lig=(String [])lignes.get(i);
		System.out.println(lig[0]+"  \t"+lig[1]+"  \t"+lig[2]+"  \t"+lig[3]);}
	System.out.println();

//Pb intgrit
//	System.out.println("Salle 21  supprimer");
//	deleteSalle(6);
		
// dernre nouvelle salle pas rattache
//	System.out.println("Salle 77  supprimer");
//	deleteSalle(7);

// Suppression d'une salle
/*
	int excep = deleteSalleSP("s77");
	if (excep==0) 
	    System.out.println("Salle 77 supprime");
		else
		System.out.println("Suppression impossible, code retour : "+excep);
*/

// Pas de salle	
/*	
	int excep = deleteSalleSP("s90");
	if (excep==0) 
	    System.out.println("Salle 90 supprime");
		else
		System.out.println("Suppression impossible, code retour : "+excep);
*/

// Fils prsent
/*
	int excep = deleteSalleSP("s01");
	if (excep==0) 
	    System.out.println("Salle 01 supprime");
		else
		System.out.println("Suppression impossible, code retour : "+excep);
*/		
			
	}
	catch (SQLException ex) {
   	while (ex != null) {
    	System.out.println ("Statut SQL  : "+ex.getSQLState());
		System.out.println ("Message     : "+ex.getMessage());
		System.out.println ("Code erreur : "+ex.getErrorCode());
		ex = ex.getNextException(); } }
	}
}
